package com.macrofocus.common.timing

import java.lang.management.ManagementFactory
import java.lang.management.ThreadMXBean

actual class Timing {
    private val useThreadMXBean = false

    private fun getThreadMXBean() : ThreadMXBean? {
        if(useThreadMXBean) {
            ManagementFactory.getThreadMXBean()
            val threadBean = ManagementFactory.getThreadMXBean()
            val isSupported = threadBean.isCurrentThreadCpuTimeSupported
            if (isSupported) {
                return threadBean
            } else {
                return null
            }
        }  else {
            return null
        }
        }

    private var threadMXBean : ThreadMXBean? = null

    private var start: Long = 0
    private var end: Long = 0

    private var cpuStart: Long? = null
    private var cpuEnd: Long? = null

    private var _lastDurationNs = 0L
    private var durationNs = 0L
    private var count = 0

    private var _lastCpuDurationNs : Long? = null
    private var cpuDurationNs : Long?  = null

    actual val lastDuration: Long
        get() = _lastDurationNs / 1_000_000

    actual val averageDuration: Long
        get() = durationNs / count / 1_000_000

    val lastCpuDuration: Long?
        get() = _lastCpuDurationNs?.div(1_000_000)

    val averageCpuDuration: Long?
        get() = cpuDurationNs?.div(count)?.div(1_000_000)

    actual val fps : Int
        get() {
            if(lastDuration > 0) {
                return (1000L / lastDuration).toInt()
            } else {
                return 1000
            }
        }

    actual fun start() {
        start = System.nanoTime()

        threadMXBean = getThreadMXBean()

        cpuStart = threadMXBean?.currentThreadCpuTime
    }

    actual fun stop() {
        end = System.nanoTime()
        cpuEnd = threadMXBean?.currentThreadCpuTime

        threadMXBean = null

        _lastDurationNs = (end - start)
        durationNs += _lastDurationNs

        cpuStart?.let { _lastCpuDurationNs = (cpuEnd?.minus(it)) }
        if(cpuDurationNs == null) {
            cpuDurationNs = _lastCpuDurationNs
        } else {
            cpuDurationNs = _lastCpuDurationNs?.let { cpuDurationNs!! + it }
        }

        count++
    }

    actual fun print() {
        println(toString())
    }

    val formattedCpuLastDuration: String
        get() {
            val cpu = lastCpuDuration
            if(cpu != null) {
                return "${lastDuration} (${lastCpuDuration}) ms)"
            } else {
                return "${lastDuration} ms"
            }
        }

    override fun toString(): String {
        return "Timing(lastDuration=$lastDuration, fps=$fps, averageDuration=$averageDuration)"
    }
}