/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\b\u0011\n\u0002\u0010\u0018\n\u0002\u0010\u0016\n\u0002\u0010\u0012\n\u0002\u0010\u0017\n\u0002\u0010\u0019\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0000\u001a\u001f\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0010\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005\u001a;\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\u001a\u0010\t\u001a\u0016\u0012\u0006\b\u0000\u0012\u0002H\b0\nj\n\u0012\u0006\b\u0000\u0012\u0002H\b`\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e\u001a(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000e\u001a\u001e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e\u001aG\u0010\u001a\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\u00032\u0006\u0010\u001c\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\b0\u00032\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010 \u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u001a.\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e\u00a8\u0006("}, d2={"toString", "", "a", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "sort", "", "T", "c", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([Ljava/lang/Object;Ljava/util/Comparator;)V", "binarySearch", "", "", "key", "binarySearch0", "fromIndex", "toIndex", "copyOf", "original", "newLength", "copyOfRange", "from", "to", "arraycopy", "src", "srcPos", "dst", "dstPos", "size", "([Ljava/lang/Object;I[Ljava/lang/Object;II)V", "", "", "", "", "", "", "", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\narrayFn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 arrayFn.kt\ncom/macrofocus/common/collection/ArrayFnKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class ArrayFnKt {
    @Nullable
    public static final String toString(@Nullable Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static final <T> void sort(@NotNull T[] a, @NotNull Comparator<? super T> c) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        ArraysKt.sortWith((Object[])a, c);
    }

    public static final int binarySearch(@NotNull int[] a, int key) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        return ArrayFnKt.binarySearch0(a, 0, a.length, key);
    }

    private static final int binarySearch0(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @NotNull
    public static final int[] copyOf(@NotNull int[] original, int newLength) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int[] copy = new int[newLength];
        ArrayFnKt.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @NotNull
    public static final int[] copyOfRange(@NotNull int[] original, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int newLength = to - from;
        if (!(newLength >= 0)) {
            boolean bl = false;
            String string = from + " > " + to;
            throw new IllegalArgumentException(string.toString());
        }
        int[] copy = new int[newLength];
        ArrayFnKt.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static final <T> void arraycopy(@NotNull T[] src, int srcPos, @NotNull T[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter(src, (String)"src");
        Intrinsics.checkNotNullParameter(dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((Object[])src, (Object[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull boolean[] src, int srcPos, @NotNull boolean[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((boolean[])src, (boolean[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull long[] src, int srcPos, @NotNull long[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((long[])src, (long[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull byte[] src, int srcPos, @NotNull byte[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((byte[])src, (byte[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull short[] src, int srcPos, @NotNull short[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((short[])src, (short[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull char[] src, int srcPos, @NotNull char[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((char[])src, (char[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull int[] src, int srcPos, @NotNull int[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((int[])src, (int[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull float[] src, int srcPos, @NotNull float[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((float[])src, (float[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }

    public static final void arraycopy(@NotNull double[] src, int srcPos, @NotNull double[] dst, int dstPos, int size) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        boolean bl = false;
        ArraysKt.copyInto((double[])src, (double[])dst, (int)dstPos, (int)srcPos, (int)(srcPos + size));
    }
}

