/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import com.macrofocus.common.collection.ConcurrentHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0013\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0096\u0002J\u0015\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0018\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0016\u0010\u0019\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0013\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u00a2\u0006\u0002\u0010!J+\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\"0\u001f\"\n\b\u0001\u0010\"*\u0004\u0018\u00010 2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0\u001f\u00a2\u0006\u0002\u0010$R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lcom/macrofocus/common/collection/ConcurrentLinkedHashSet;", "K", "", "<init>", "()V", "set", "Lcom/macrofocus/common/collection/ConcurrentHashSet;", "holder", "Ljava/util/concurrent/CopyOnWriteArrayList;", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "size", "", "getSize", "()I", "toArray", "", "", "()[Ljava/lang/Object;", "T", "a", "([Ljava/lang/Object;)[Ljava/lang/Object;", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nConcurrentLinkedHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentLinkedHashSet.kt\ncom/macrofocus/common/collection/ConcurrentLinkedHashSet\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n37#2,2:91\n*S KotlinDebug\n*F\n+ 1 ConcurrentLinkedHashSet.kt\ncom/macrofocus/common/collection/ConcurrentLinkedHashSet\n*L\n84#1:91,2\n*E\n"})
public final class ConcurrentLinkedHashSet<K>
implements Set<K>,
KMutableSet {
    @NotNull
    private final ConcurrentHashSet<K> set = new ConcurrentHashSet();
    @NotNull
    private final CopyOnWriteArrayList<K> holder = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(K element) {
        if (this.set.contains(element)) {
            return false;
        }
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        synchronized (concurrentHashSet) {
            boolean bl = false;
            this.set.add(element);
            boolean bl2 = this.holder.add(element);
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (K element : elements) {
            changed = this.add(element) || changed;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        synchronized (concurrentHashSet) {
            boolean bl = false;
            this.set.clear();
            this.holder.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.set.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (Object o : elements) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.holder.size() == 0;
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        Iterator<K> iterator2 = this.holder.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        if (!this.set.contains(element)) {
            return false;
        }
        ConcurrentHashSet<K> concurrentHashSet = this.set;
        synchronized (concurrentHashSet) {
            boolean bl = false;
            this.set.remove(element);
            boolean bl2 = this.holder.remove(element);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (Object o : elements) {
            changed = this.remove(o) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.clear();
        for (Object element : elements) {
            this.add((K)element);
        }
        return true;
    }

    public int getSize() {
        return this.holder.size();
    }

    @Override
    @NotNull
    public final Object[] toArray() {
        Collection $this$toTypedArray$iv = this.holder;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    @Override
    @NotNull
    public final <T> T[] toArray(@NotNull T[] a) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        T[] TArray = this.holder.toArray(a);
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"toArray(...)");
        return TArray;
    }
}

