/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.format;

import com.macrofocus.common.collection.IdentityHashMap;
import com.macrofocus.common.format.AbstractFormat;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u00028\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/common/format/ConvertFormat;", "T", "Lcom/macrofocus/common/format/AbstractFormat;", "values", "", "labels", "", "<init>", "([Ljava/lang/Object;[Ljava/lang/String;)V", "forward", "", "backward", "formatHtml", "value", "htmlSupported", "", "(Ljava/lang/Object;Z)Ljava/lang/String;", "parse", "text", "(Ljava/lang/String;)Ljava/lang/Object;", "nativeFormat", "", "getNativeFormat", "()Ljava/lang/Object;", "macrofocus-common"})
public class ConvertFormat<T>
extends AbstractFormat<T> {
    @NotNull
    private final Map<T, String> forward;
    @NotNull
    private final Map<String, T> backward;

    public ConvertFormat(@NotNull T[] values, @NotNull String[] labels) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        this.forward = new IdentityHashMap(values.length);
        this.backward = new HashMap(values.length);
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            T value = values[i];
            String label = labels[i];
            this.forward.put(value, label);
            this.backward.put(label, value);
        }
    }

    @Override
    @Nullable
    public String formatHtml(T value, boolean htmlSupported) {
        return this.forward.get(value);
    }

    @Override
    public T parse(@Nullable String text) {
        T t = this.backward.get(text);
        Intrinsics.checkNotNull(t);
        return t;
    }

    @Override
    @Nullable
    public Object getNativeFormat() {
        return null;
    }
}

