/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.interval;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.interval.AbstractMutableInterval;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/common/interval/AbstractBoundedInterval;", "Lcom/macrofocus/common/interval/AbstractMutableInterval;", "Lcom/macrofocus/common/interval/BoundedInterval;", "<init>", "()V", "listeners", "", "Lcom/macrofocus/common/interval/BoundedIntervalListener;", "isFullRange", "", "()Z", "addBoundedIntervalListener", "", "listener", "addWeakBoundedIntervalListener", "removeBoundedIntervalListener", "removeBoundedIntervalListeners", "notifyBoundedIntervalChanged", "event", "Lcom/macrofocus/common/interval/BoundedIntervalEvent;", "WeakBoundedIntervalListener", "macrofocus-common"})
public abstract class AbstractBoundedInterval
extends AbstractMutableInterval
implements BoundedInterval {
    @NotNull
    private final List<BoundedIntervalListener> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    protected AbstractBoundedInterval() {
    }

    @Override
    public boolean isFullRange() {
        return this.getExtent() == Math.abs(this.getMaximum() - this.getMinimum());
    }

    @Override
    public void addBoundedIntervalListener(@NotNull BoundedIntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakBoundedIntervalListener(@NotNull BoundedIntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        WeakBoundedIntervalListener weakListener = new WeakBoundedIntervalListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeBoundedIntervalListener(@NotNull BoundedIntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (listener2 instanceof WeakBoundedIntervalListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            BoundedIntervalListener toRemove = null;
            for (BoundedIntervalListener intervalListener2 : this.listeners) {
                BoundedIntervalListener comparable = null;
                comparable = intervalListener2 instanceof WeakBoundedIntervalListener ? ((WeakBoundedIntervalListener)intervalListener2).getReference() : intervalListener2;
                if (!Intrinsics.areEqual((Object)listener2, (Object)comparable)) continue;
                toRemove = intervalListener2;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeBoundedIntervalListeners() {
        this.listeners.clear();
    }

    protected final void notifyBoundedIntervalChanged(@NotNull BoundedIntervalEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (BoundedIntervalListener listener2 : this.listeners) {
            listener2.boundedIntervalChanged(event);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/macrofocus/common/interval/AbstractBoundedInterval$WeakBoundedIntervalListener;", "Lcom/macrofocus/common/interval/BoundedIntervalListener;", "listener", "<init>", "(Lcom/macrofocus/common/interval/AbstractBoundedInterval;Lcom/macrofocus/common/interval/BoundedIntervalListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "boundedIntervalChanged", "", "event", "Lcom/macrofocus/common/interval/BoundedIntervalEvent;", "reference", "getReference", "()Lcom/macrofocus/common/interval/BoundedIntervalListener;", "toString", "", "macrofocus-common"})
    private final class WeakBoundedIntervalListener
    implements BoundedIntervalListener {
        @NotNull
        private final WeakReference<BoundedIntervalListener> l_ref;

        public WeakBoundedIntervalListener(BoundedIntervalListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.l_ref = new WeakReference<BoundedIntervalListener>(listener2);
        }

        @Override
        public void boundedIntervalChanged(@NotNull BoundedIntervalEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            BoundedIntervalListener l = this.getReference();
            if (l != null) {
                l.boundedIntervalChanged(event);
            } else {
                AbstractBoundedInterval.this.removeBoundedIntervalListener(this);
            }
        }

        @Nullable
        public final BoundedIntervalListener getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            BoundedIntervalListener l = this.getReference();
            return l != null ? "Weak[" + l + "]" : Reflection.getOrCreateKotlinClass(this.getClass()) + "@" + this.hashCode();
        }
    }
}

