/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonException;
import com.macrofocus.common.json.JsonFactory;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import com.macrofocus.common.math.MathKt;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u001f\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/macrofocus/common/json/JsonUtil;", "", "<init>", "()V", "escapeControlChars", "", "text", "parse", "T", "Lcom/macrofocus/common/json/JsonValue;", "json", "(Ljava/lang/String;)Lcom/macrofocus/common/json/JsonValue;", "quote", "value", "stringify", "jsonValue", "spaces", "", "indent", "escapeCharAsUnicode", "toEscape", "", "isControlChar", "", "c", "StringifyJsonVisitor", "macrofocus-common"})
public final class JsonUtil {
    @NotNull
    public static final JsonUtil INSTANCE = new JsonUtil();

    private JsonUtil() {
    }

    @NotNull
    public final String escapeControlChars(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder toReturn = new StringBuilder();
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            StringBuilder stringBuilder = this.isControlChar(c) ? toReturn.append(this.escapeCharAsUnicode(c)) : toReturn.append(c);
        }
        String string = toReturn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final <T extends JsonValue> T parse(@NotNull String json) throws JsonException {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return JsonFactory.INSTANCE.parse(json);
    }

    @NotNull
    public final String quote(@Nullable String value) {
        StringBuilder toReturn = new StringBuilder("\"");
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            String toAppend = String.valueOf(c);
            switch (c) {
                case '\b': {
                    toAppend = "\\b";
                    break;
                }
                case '\t': {
                    toAppend = "\\t";
                    break;
                }
                case '\n': {
                    toAppend = "\\n";
                    break;
                }
                case '\r': {
                    toAppend = "\\r";
                    break;
                }
                case '\"': {
                    toAppend = "\\\"";
                    break;
                }
                case '\\': {
                    toAppend = "\\\\";
                    break;
                }
                default: {
                    if (!this.isControlChar(c)) break;
                    toAppend = this.escapeCharAsUnicode(c);
                }
            }
            toReturn.append(toAppend);
        }
        toReturn.append("\"");
        String string2 = toReturn.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String stringify(@NotNull JsonValue jsonValue) {
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        return this.stringify(jsonValue, 0);
    }

    @NotNull
    public final String stringify(@NotNull JsonValue jsonValue, int spaces) {
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
        return this.stringify(jsonValue, sb.toString());
    }

    @NotNull
    public final String stringify(@NotNull JsonValue jsonValue, @Nullable String indent) {
        Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
        StringBuilder sb = new StringBuilder();
        boolean isPretty = indent != null && !Intrinsics.areEqual((Object)"", (Object)indent);
        new StringifyJsonVisitor(indent, sb, isPretty).accept(jsonValue);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String escapeCharAsUnicode(char toEscape) {
        String string = Integer.toString(toEscape, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String hexValue = string;
        int padding = 4 - hexValue.length();
        String string2 = "0000".substring(0, padding);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return "\\u" + string2 + hexValue;
    }

    private final boolean isControlChar(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c == '\u00ad' || c == '\u070f' || c == '\u17b4' || c == '\u17b5' || c == '\ufeff' || Intrinsics.compare((int)c, (int)1536) >= 0 && Intrinsics.compare((int)c, (int)1540) <= 0 || Intrinsics.compare((int)c, (int)8204) >= 0 && Intrinsics.compare((int)c, (int)8207) <= 0 || Intrinsics.compare((int)c, (int)8232) >= 0 && Intrinsics.compare((int)c, (int)8239) <= 0 || Intrinsics.compare((int)c, (int)8288) >= 0 && Intrinsics.compare((int)c, (int)8303) <= 0 || Intrinsics.compare((int)c, (int)65520) >= 0 && Intrinsics.compare((int)c, (int)65535) <= 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0017\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/macrofocus/common/json/JsonUtil$StringifyJsonVisitor;", "Lcom/macrofocus/common/json/JsonVisitor;", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pretty", "", "<init>", "(Ljava/lang/String;Ljava/lang/StringBuilder;Z)V", "indentLevel", "visited", "", "Lcom/macrofocus/common/json/JsonValue;", "endVisit", "", "array", "Lcom/macrofocus/common/json/JsonArray;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "object", "Lcom/macrofocus/common/json/JsonObject;", "visit", "number", "", "string", "bool", "visitIndex", "index", "", "visitKey", "key", "visitNull", "checkCycle", "value", "commaIfNotFirst", "format", "Companion", "macrofocus-common"})
    private static final class StringifyJsonVisitor
    extends JsonVisitor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String indent;
        @NotNull
        private final StringBuilder sb;
        private final boolean pretty;
        @NotNull
        private String indentLevel;
        @NotNull
        private final Set<JsonValue> visited;
        @Nullable
        private static Set<String> skipKeys;

        public StringifyJsonVisitor(@Nullable String indent, @NotNull StringBuilder sb, boolean pretty) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            this.indent = indent;
            this.sb = sb;
            this.pretty = pretty;
            this.indentLevel = "";
            this.visited = new HashSet();
        }

        @Override
        public void endVisit(@NotNull JsonArray array, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.pretty) {
                int n = this.indentLevel.length();
                String string = this.indent;
                Intrinsics.checkNotNull((Object)string);
                String string2 = this.indentLevel.substring(0, n - string.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                this.indentLevel = string2;
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("]");
            this.visited.remove(array);
        }

        @Override
        public void endVisit(@NotNull JsonObject object, @NotNull JsonContext ctx) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.pretty) {
                int n = this.indentLevel.length();
                String string = this.indent;
                Intrinsics.checkNotNull((Object)string);
                String string2 = this.indentLevel.substring(0, n - string.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                this.indentLevel = string2;
                this.sb.append('\n');
                this.sb.append(this.indentLevel);
            }
            this.sb.append("}");
            this.visited.remove(object);
            boolean bl2 = bl = !this.visited.contains(object);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @Override
        public void visit(double number, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append(MathKt.isInfinite(number) || MathKt.isNaN(number) ? "null" : this.format(number));
        }

        @Override
        public void visit(@Nullable String string, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append(INSTANCE.quote(string));
        }

        @Override
        public void visit(boolean bool, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append(bool);
        }

        @Override
        public boolean visit(@NotNull JsonArray array, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.checkCycle(array);
            this.sb.append("[");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visit(@NotNull JsonObject object, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"object");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.checkCycle(object);
            this.sb.append("{");
            if (this.pretty) {
                this.sb.append('\n');
                this.indentLevel = this.indentLevel + this.indent;
                this.sb.append(this.indentLevel);
            }
            return true;
        }

        @Override
        public boolean visitIndex(int index, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.commaIfNotFirst(ctx);
            return true;
        }

        @Override
        public boolean visitKey(@Nullable String key, @NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (Intrinsics.areEqual((Object)"", (Object)key)) {
                return true;
            }
            Set<String> set = skipKeys;
            Intrinsics.checkNotNull(set);
            if (CollectionsKt.contains((Iterable)set, (Object)key)) {
                return false;
            }
            this.commaIfNotFirst(ctx);
            this.sb.append(INSTANCE.quote(key) + ":");
            if (this.pretty) {
                this.sb.append(' ');
            }
            return true;
        }

        @Override
        public void visitNull(@NotNull JsonContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.sb.append("null");
        }

        private final void checkCycle(JsonValue value) {
            if (this.visited.contains(value)) {
                throw new JsonException("Cycled detected during stringify");
            }
            this.visited.add(value);
        }

        private final void commaIfNotFirst(JsonContext ctx) {
            if (!ctx.isFirst()) {
                this.sb.append(",");
                if (this.pretty) {
                    this.sb.append('\n');
                    this.sb.append(this.indentLevel);
                }
            }
        }

        private final String format(double number) {
            String n = String.valueOf(number);
            if (StringsKt.endsWith$default((String)n, (String)".0", (boolean)false, (int)2, null)) {
                String string = n.substring(0, n.length() - 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                n = string;
            }
            return n;
        }

        static {
            Set toSkip = new HashSet();
            toSkip.add("$H");
            toSkip.add("__gwt_ObjectId");
            skipKeys = toSkip;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/common/json/JsonUtil$StringifyJsonVisitor$Companion;", "", "<init>", "()V", "skipKeys", "", "", "macrofocus-common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

