/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math;

import com.macrofocus.common.collection.ArrayFnKt;
import com.macrofocus.common.math.MathKt;
import java.util.Comparator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u001d\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J#\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010\u0011J#\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0007\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ+\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u0019\u001a\u00020\f2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00072\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001fJ+\u0010\u0019\u001a\u00020\u00052\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\t\u00a2\u0006\u0002\u0010 J+\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010!J+\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010\"J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\fJ+\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010$J\u0016\u0010\u0019\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\fJ#\u0010&\u001a\u00020\f2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00072\u0006\u0010'\u001a\u00020\t\u00a2\u0006\u0002\u0010(J#\u0010&\u001a\u00020\u00052\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010'\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ+\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001cJ+\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010*J+\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u0006\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0002\u0010\"J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fJ\u001b\u0010,\u001a\u00020\f2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010.J\u001b\u0010,\u001a\u00020\f2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005J\u0016\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020%J\u001b\u00100\u001a\u00020\u00052\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u00103J\u001b\u00100\u001a\u00020\f2\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\fJ\u0016\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\u0006\u00104\u001a\u00020\tJ\u000e\u00105\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u00106\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u00108\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005J\u001e\u00105\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u00109\u001a\u00020\tJ\u0016\u00105\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u00109\u001a\u00020\tJ\u0016\u00105\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005J#\u00105\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u00109\u001a\u00020\t\u00a2\u0006\u0002\u0010:J#\u0010;\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u00109\u001a\u00020\t\u00a2\u0006\u0002\u0010:J\u001e\u00105\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tJ+\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u00072\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u00072\u0006\u0010@\u001a\u00020\t\u00a2\u0006\u0002\u0010AJ\u0016\u0010>\u001a\u00020\f2\u0006\u0010B\u001a\u00020\f2\u0006\u0010@\u001a\u00020\tJ\u0016\u0010>\u001a\u00020C2\u0006\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020\tJ\u0016\u0010>\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\tJ\u0016\u0010>\u001a\u00020%2\u0006\u0010B\u001a\u00020%2\u0006\u0010@\u001a\u00020\tJ\u0016\u0010>\u001a\u00020\u00122\u0006\u0010B\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\tJ\u001e\u0010>\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\t2\u0006\u0010D\u001a\u00020EJ+\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u000e\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00072\u0006\u0010@\u001a\u00020\t\u00a2\u0006\u0002\u0010FJ+\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010@\u001a\u00020\t\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\fJ#\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u00a2\u0006\u0002\u0010IJ#\u0010J\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010C0\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010KJ#\u0010L\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010C0\u0007\u00a2\u0006\u0002\u0010MJ#\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010OJ#\u0010P\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010C0\u0007\u00a2\u0006\u0002\u0010QJ\u000e\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\fJ\u000e\u0010R\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u0005J\u000e\u0010T\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010T\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010T\u001a\u00020U2\u0006\u0010\u0015\u001a\u00020%J\u000e\u0010V\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\u001b\u0010V\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u00103J\u001b\u0010W\u001a\u00020\u00172\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010XJ\u0018\u0010Y\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\f2\u0006\u0010[\u001a\u00020\tH\u0007J\u001e\u0010\\\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\f2\u0006\u0010[\u001a\u00020\u0017J\u0016\u0010^\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\f2\u0006\u0010[\u001a\u00020\tJ\"\u0010^\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\u00172\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J%\u0010^\u001a\u00020\t2\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u00072\b\u0010[\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010_J%\u0010^\u001a\u00020\t2\u000e\u0010Z\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\b\u0010[\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010`J#\u0010a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010\u0011J#\u0010a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u0007\u00a2\u0006\u0002\u0010bJ+\u0010c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00072\u0006\u0010d\u001a\u00020\t2\u0006\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\u0017\u00a2\u0006\u0002\u0010gJ\u0016\u0010h\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\t2\u0006\u0010f\u001a\u00020\u0017J\u0016\u0010h\u001a\u00020\f2\u0006\u0010=\u001a\u00020\t2\u0006\u0010f\u001a\u00020\tJW\u0010i\u001a\u00020j2\u000e\u0010k\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u000e\u0010l\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010m\u001a\u00020\t2\u0006\u0010n\u001a\u00020\t2\u001a\u0010o\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010pj\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`q\u00a2\u0006\u0002\u0010rJ-\u0010s\u001a\u00020j2\u000e\u0010t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010w\u00a8\u0006x"}, d2={"Lcom/macrofocus/common/math/Array;", "", "<init>", "()V", "crossSubArray", "", "source", "", "index", "", "([[FI)[F", "intList", "", "from", "to", "duplicate", "roleModel", "([[F)[[F", "", "([[Z)[[Z", "abs", "data", "interpolate", "", "sampleCount", "extract", "values", "indices", "([[F[I)[[F", "rowIndices", "columnIndex", "([[I[II)[I", "([[F[II)[F", "([[I[I)[[I", "([[Z[I)[[Z", "", "([Ljava/lang/String;[I)[Ljava/lang/String;", "", "extractColumn", "column", "([[II)[I", "extractColumns", "([[D[I)[[D", "extractValids", "lengths", "arrays", "([[F)[I", "([[I)[I", "concatenate", "xs", "ys", "([[F)[F", "y", "findValids", "findPositives", "findNegatives", "findInvalids", "minValids", "([[FI)[I", "findColumnValids", "start", "length", "trim", "strings", "len", "([Ljava/lang/String;I)[Ljava/lang/String;", "vector", "", "onlyValids", "", "([[ZI)[[Z", "([[FI)[[F", "intsToFloats", "([[I)[[F", "floatToBytes", "([[F)[[B", "bytesToFloats", "([[B)[[F", "floatsToDoubles", "([[F)[[D", "bytesToDoubles", "([[B)[[D", "reverse", "original", "getMax", "", "getMinMaxAndSmallestPositive", "getLogMean", "([[F)F", "find", "array", "value", "indexOfOrdered", "order", "indexOf", "([Ljava/lang/String;Ljava/lang/String;)I", "([Ljava/lang/Object;Ljava/lang/Object;)I", "transpose", "([[D)[[D", "createArray", "rows", "cols", "initial", "(IIF)[[F", "createVector", "mergeSort", "", "src", "dest", "low", "high", "c", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([Ljava/lang/Object;[Ljava/lang/Object;IILjava/util/Comparator;)V", "swap", "x", "a", "b", "([Ljava/lang/Object;II)V", "macrofocus-common"})
public final class Array {
    @NotNull
    public static final Array INSTANCE = new Array();

    private Array() {
    }

    @NotNull
    public final float[] crossSubArray(@NotNull float[][] source, int index) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        float[] result = new float[((Object[])source).length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = source[i];
            Intrinsics.checkNotNull((Object)fArray);
            result[i] = fArray[index];
        }
        return result;
    }

    @NotNull
    public final int[] intList(int from, int to) {
        int entryCount = Math.abs(to - from) + 1;
        int[] result = new int[entryCount];
        int direction = to <= from ? -1 : 1;
        for (int i = 0; i < entryCount; ++i) {
            result[i] = from + i * direction;
        }
        return result;
    }

    @NotNull
    public final int[] duplicate(@NotNull int[] roleModel) {
        Intrinsics.checkNotNullParameter((Object)roleModel, (String)"roleModel");
        int[] result = new int[roleModel.length];
        ArrayFnKt.arraycopy(roleModel, 0, result, 0, result.length);
        return result;
    }

    @NotNull
    public final float[] duplicate(@NotNull float[] roleModel) {
        Intrinsics.checkNotNullParameter((Object)roleModel, (String)"roleModel");
        float[] result = new float[roleModel.length];
        ArrayFnKt.arraycopy(roleModel, 0, result, 0, result.length);
        return result;
    }

    @NotNull
    public final float[][] duplicate(@NotNull float[][] roleModel) {
        Intrinsics.checkNotNullParameter((Object)roleModel, (String)"roleModel");
        float[][] result = new float[((Object[])roleModel).length][];
        int n = ((Object[])roleModel).length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = roleModel[i];
            Intrinsics.checkNotNull((Object)fArray);
            result[i] = new float[fArray.length];
            float[] fArray2 = roleModel[i];
            Intrinsics.checkNotNull((Object)fArray2);
            float[] fArray3 = result[i];
            Intrinsics.checkNotNull((Object)fArray3);
            float[] fArray4 = roleModel[i];
            Intrinsics.checkNotNull((Object)fArray4);
            ArrayFnKt.arraycopy(fArray2, 0, fArray3, 0, fArray4.length);
        }
        return result;
    }

    @NotNull
    public final boolean[][] duplicate(@NotNull boolean[][] roleModel) {
        Intrinsics.checkNotNullParameter((Object)roleModel, (String)"roleModel");
        boolean[][] result = new boolean[((Object[])roleModel).length][];
        int n = ((Object[])roleModel).length;
        for (int i = 0; i < n; ++i) {
            boolean[] blArray = roleModel[i];
            Intrinsics.checkNotNull((Object)blArray);
            result[i] = new boolean[blArray.length];
            boolean[] blArray2 = roleModel[i];
            Intrinsics.checkNotNull((Object)blArray2);
            boolean[] blArray3 = result[i];
            Intrinsics.checkNotNull((Object)blArray3);
            boolean[] blArray4 = roleModel[i];
            Intrinsics.checkNotNull((Object)blArray4);
            ArrayFnKt.arraycopy(blArray2, 0, blArray3, 0, blArray4.length);
        }
        return result;
    }

    @NotNull
    public final float[] abs(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] result = new float[data.length];
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            result[i] = Math.abs(data[i]);
        }
        return result;
    }

    @NotNull
    public final float[] interpolate(float from, float to, int sampleCount) {
        if (sampleCount < 1) {
            return new float[0];
        }
        if (sampleCount == 1) {
            float[] fArray = new float[]{(from + to) / 2.0f};
            return fArray;
        }
        float[] result = new float[sampleCount];
        result[0] = from;
        float step = (to - from) / (float)(sampleCount - 1);
        int n = result.length;
        for (int i = 1; i < n; ++i) {
            result[i] = result[i - 1] + step;
        }
        return result;
    }

    @NotNull
    public final float[][] extract(@NotNull float[][] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        float[][] result = new float[indices.length][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final int[] extract(@NotNull int[][] values, @NotNull int[] rowIndices, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)rowIndices, (String)"rowIndices");
        int[] result = new int[rowIndices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray = values[rowIndices[i]];
            Intrinsics.checkNotNull((Object)nArray);
            result[i] = nArray[columnIndex];
        }
        return result;
    }

    @NotNull
    public final float[] extract(@NotNull float[][] values, @NotNull int[] rowIndices, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)rowIndices, (String)"rowIndices");
        float[] result = new float[rowIndices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = values[rowIndices[i]];
            Intrinsics.checkNotNull((Object)fArray);
            result[i] = fArray[columnIndex];
        }
        return result;
    }

    @NotNull
    public final int[][] extract(@NotNull int[][] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        int[][] result = new int[indices.length][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final boolean[][] extract(@NotNull boolean[][] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        boolean[][] result = new boolean[indices.length][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final float[] extract(@NotNull float[] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        float[] result = new float[indices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final boolean[] extract(@NotNull boolean[] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        boolean[] result = new boolean[indices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final String[] extract(@NotNull String[] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        String[] result = new String[indices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final double[] extract(@NotNull double[] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        double[] result = new double[indices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final int[] extractColumn(@NotNull int[][] values, int column) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int[] result = new int[((Object[])values).length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray = values[i];
            Intrinsics.checkNotNull((Object)nArray);
            result[i] = nArray[column];
        }
        return result;
    }

    @NotNull
    public final float[] extractColumn(@NotNull float[][] values, int column) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        float[] result = new float[((Object[])values).length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = values[i];
            Intrinsics.checkNotNull((Object)fArray);
            result[i] = fArray[column];
        }
        return result;
    }

    @NotNull
    public final float[][] extractColumns(@NotNull float[][] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        float[][] result = new float[((Object[])values).length][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = values[i];
            Intrinsics.checkNotNull((Object)fArray);
            result[i] = INSTANCE.extract(fArray, indices);
        }
        return result;
    }

    @NotNull
    public final double[][] extractColumns(@NotNull double[][] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        double[][] result = new double[((Object[])values).length][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = values[i];
            Intrinsics.checkNotNull((Object)dArray);
            result[i] = INSTANCE.extract(dArray, indices);
        }
        return result;
    }

    @NotNull
    public final boolean[][] extractColumns(@NotNull boolean[][] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        boolean[][] result = new boolean[((Object[])values).length][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            boolean[] blArray = values[i];
            Intrinsics.checkNotNull((Object)blArray);
            result[i] = INSTANCE.extract(blArray, indices);
        }
        return result;
    }

    @NotNull
    public final float[] extractValids(@NotNull float[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int count = 0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            if (MathKt.isNaN(values[i])) continue;
            ++count;
        }
        float[] result = new float[count];
        count = 0;
        int n2 = values.length;
        for (int i = 0; i < n2; ++i) {
            if (MathKt.isNaN(values[i])) continue;
            result[count++] = values[i];
        }
        return result;
    }

    @NotNull
    public final int[] extract(@NotNull int[] values, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        int[] result = new int[indices.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[indices[i]];
        }
        return result;
    }

    @NotNull
    public final int[] lengths(@NotNull float[][] arrays) {
        Intrinsics.checkNotNullParameter((Object)arrays, (String)"arrays");
        int[] result = new int[((Object[])arrays).length];
        int n = ((Object[])arrays).length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = arrays[i];
            Intrinsics.checkNotNull((Object)fArray);
            result[i] = fArray.length;
        }
        return result;
    }

    @NotNull
    public final int[] lengths(@NotNull int[][] arrays) {
        Intrinsics.checkNotNullParameter((Object)arrays, (String)"arrays");
        int[] result = new int[((Object[])arrays).length];
        int n = ((Object[])arrays).length;
        for (int i = 0; i < n; ++i) {
            int[] nArray = arrays[i];
            Intrinsics.checkNotNull((Object)nArray);
            result[i] = nArray.length;
        }
        return result;
    }

    @NotNull
    public final float[] concatenate(@NotNull float[] xs, @NotNull float[] ys) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        float[] result = new float[xs.length + ys.length];
        ArrayFnKt.arraycopy(xs, 0, result, 0, xs.length);
        ArrayFnKt.arraycopy(ys, 0, result, xs.length, ys.length);
        return result;
    }

    @NotNull
    public final double[] concatenate(@NotNull double[] xs, @NotNull double[] ys) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        double[] result = new double[xs.length + ys.length];
        ArrayFnKt.arraycopy(xs, 0, result, 0, xs.length);
        ArrayFnKt.arraycopy(ys, 0, result, xs.length, ys.length);
        return result;
    }

    @NotNull
    public final float[] concatenate(@NotNull float[][] xs) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        int num = 0;
        int n = ((Object[])xs).length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = xs[i];
            Intrinsics.checkNotNull((Object)fArray);
            num += fArray.length;
        }
        float[] result = new float[num];
        num = 0;
        int n2 = ((Object[])xs).length;
        for (int i = 0; i < n2; ++i) {
            float[] fArray = xs[i];
            Intrinsics.checkNotNull((Object)fArray);
            float[] fArray2 = xs[i];
            Intrinsics.checkNotNull((Object)fArray2);
            ArrayFnKt.arraycopy(fArray, 0, result, num, fArray2.length);
            float[] fArray3 = xs[i];
            Intrinsics.checkNotNull((Object)fArray3);
            num += fArray3.length;
        }
        return result;
    }

    @NotNull
    public final int[] concatenate(@NotNull int[][] xs) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        int num = 0;
        int n = ((Object[])xs).length;
        for (int i = 0; i < n; ++i) {
            int[] nArray = xs[i];
            Intrinsics.checkNotNull((Object)nArray);
            num += nArray.length;
        }
        int[] result = new int[num];
        num = 0;
        int n2 = ((Object[])xs).length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray = xs[i];
            Intrinsics.checkNotNull((Object)nArray);
            int[] nArray2 = xs[i];
            Intrinsics.checkNotNull((Object)nArray2);
            ArrayFnKt.arraycopy(nArray, 0, result, num, nArray2.length);
            int[] nArray3 = xs[i];
            Intrinsics.checkNotNull((Object)nArray3);
            num += nArray3.length;
        }
        return result;
    }

    @NotNull
    public final int[] concatenate(@NotNull int[] xs, @NotNull int[] ys) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        int[] result = new int[xs.length + ys.length];
        ArrayFnKt.arraycopy(xs, 0, result, 0, xs.length);
        ArrayFnKt.arraycopy(ys, 0, result, xs.length, ys.length);
        return result;
    }

    @NotNull
    public final int[] concatenate(@NotNull int[] xs, int y) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        int[] result = new int[xs.length + 1];
        ArrayFnKt.arraycopy(xs, 0, result, 0, xs.length);
        result[xs.length] = y;
        return result;
    }

    @NotNull
    public final int[] findValids(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] result = new int[data.length];
        int validCount = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (MathKt.isNaN(data[i])) continue;
            result[validCount++] = i;
        }
        return this.trim(result, validCount);
    }

    @NotNull
    public final int[] findPositives(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] result = new int[data.length];
        int validCount = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (!(data[i] > 0.0f)) continue;
            result[validCount++] = i;
        }
        return this.trim(result, validCount);
    }

    @NotNull
    public final int[] findNegatives(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] result = new int[data.length];
        int validCount = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (!(data[i] < 0.0f)) continue;
            result[validCount++] = i;
        }
        return this.trim(result, validCount);
    }

    @NotNull
    public final int[] findInvalids(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] result = new int[data.length];
        int validCount = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (!MathKt.isNaN(data[i])) continue;
            result[validCount++] = i;
        }
        return this.trim(result, validCount);
    }

    @NotNull
    public final int[] findValids(@NotNull float[] xs, @NotNull float[] ys, int minValids) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        int[] result = new int[xs.length];
        int validCount = 0;
        int n = xs.length;
        for (int i = 0; i < n; ++i) {
            if (MathKt.isNaN(xs[i]) || MathKt.isNaN(ys[i])) continue;
            result[validCount++] = i;
        }
        return validCount >= minValids ? this.trim(result, validCount) : new int[]{};
    }

    @NotNull
    public final int[] findValids(@NotNull float[] data, int minValids) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] result = new int[data.length];
        int validCount = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (MathKt.isNaN(data[i])) continue;
            result[validCount++] = i;
        }
        return validCount >= minValids ? this.trim(result, validCount) : new int[]{};
    }

    @NotNull
    public final int[] findValids(@NotNull float[] xs, @NotNull float[] ys) {
        Intrinsics.checkNotNullParameter((Object)xs, (String)"xs");
        Intrinsics.checkNotNullParameter((Object)ys, (String)"ys");
        int[] result = new int[xs.length];
        int validCount = 0;
        int n = xs.length;
        for (int i = 0; i < n; ++i) {
            if (MathKt.isNaN(xs[i]) || MathKt.isNaN(ys[i])) continue;
            result[validCount++] = i;
        }
        return this.trim(result, validCount);
    }

    @NotNull
    public final int[] findValids(@NotNull float[][] data, int minValids) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int[] valids = new int[((Object[])data).length];
        int validCount = 0;
        int n = ((Object[])data).length;
        for (int row = 0; row < n; ++row) {
            int validsInRow = 0;
            float[] fArray = data[row];
            Intrinsics.checkNotNull((Object)fArray);
            int n2 = fArray.length;
            for (int col = 0; col < n2; ++col) {
                float[] fArray2 = data[row];
                Intrinsics.checkNotNull((Object)fArray2);
                if (MathKt.isNaN(fArray2[col])) continue;
                ++validsInRow;
            }
            if (validsInRow < minValids) continue;
            valids[validCount++] = row;
        }
        return this.trim(valids, validCount);
    }

    @NotNull
    public final int[] findColumnValids(@NotNull float[][] data, int minValids) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] fArray = data[0];
        Intrinsics.checkNotNull((Object)fArray);
        int[] valids = new int[fArray.length];
        int validCount = 0;
        float[] fArray2 = data[0];
        Intrinsics.checkNotNull((Object)fArray2);
        int n = fArray2.length;
        for (int col = 0; col < n; ++col) {
            int validsInColumn = 0;
            int n2 = ((Object[])data).length;
            for (int row = 0; row < n2; ++row) {
                float[] fArray3 = data[row];
                Intrinsics.checkNotNull((Object)fArray3);
                if (MathKt.isNaN(fArray3[col])) continue;
                ++validsInColumn;
            }
            if (validsInColumn < minValids) continue;
            valids[validCount++] = col;
        }
        return this.trim(valids, validCount);
    }

    @NotNull
    public final int[] findValids(@NotNull float[] data, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int length2 = length;
        length2 = Math.min(length2, data.length - start);
        int[] result = new int[length2];
        int validCount = 0;
        int n = start + length2;
        for (int i = start; i < n; ++i) {
            if (MathKt.isNaN(data[i])) continue;
            result[validCount++] = i;
        }
        return this.trim(result, validCount);
    }

    @NotNull
    public final String[] trim(@NotNull String[] strings, int len) {
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        if (strings.length == len) {
            return strings;
        }
        String[] truncated = new String[len];
        ArrayFnKt.arraycopy(strings, 0, truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final int[] trim(@NotNull int[] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (vector.length == len) {
            return vector;
        }
        int[] truncated = new int[len];
        ArrayFnKt.arraycopy(vector, 0, truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final byte[] trim(@NotNull byte[] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (vector.length == len) {
            return vector;
        }
        byte[] truncated = new byte[len];
        ArrayFnKt.arraycopy(vector, 0, truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final float[] trim(@NotNull float[] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (vector.length == len) {
            return vector;
        }
        float[] truncated = new float[len];
        ArrayFnKt.arraycopy(vector, 0, truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final double[] trim(@NotNull double[] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (vector.length == len) {
            return vector;
        }
        double[] truncated = new double[len];
        ArrayFnKt.arraycopy(vector, 0, truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final boolean[] trim(@NotNull boolean[] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (vector.length == len) {
            return vector;
        }
        boolean[] truncated = new boolean[len];
        ArrayFnKt.arraycopy(vector, 0, truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final float[] trim(@NotNull float[] vector, int length, boolean onlyValids) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (onlyValids) {
            int validCount = 0;
            for (int i = 0; i < length; ++i) {
                if (MathKt.isNaN(vector[i]) || MathKt.isInfinite(vector[i])) continue;
                ++validCount;
            }
            float[] result = new float[validCount];
            validCount = 0;
            for (int i = 0; i < length; ++i) {
                if (MathKt.isNaN(vector[i]) || MathKt.isInfinite(vector[i])) continue;
                result[validCount++] = vector[i];
            }
            return result;
        }
        return this.trim(vector, length);
    }

    @NotNull
    public final boolean[][] trim(@NotNull boolean[][] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (((Object[])vector).length == len) {
            return vector;
        }
        boolean[][] truncated = new boolean[len][];
        ArrayFnKt.arraycopy((Object[])vector, 0, (Object[])truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final float[][] trim(@NotNull float[][] vector, int len) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (((Object[])vector).length == len) {
            return vector;
        }
        float[][] truncated = new float[len][];
        ArrayFnKt.arraycopy((Object[])vector, 0, (Object[])truncated, 0, len);
        return truncated;
    }

    @NotNull
    public final float[] intsToFloats(@NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        float[] result = new float[values.length];
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            result[i] = values[i];
        }
        return result;
    }

    @NotNull
    public final float[][] intsToFloats(@NotNull int[][] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        float[][] result = new float[((Object[])values).length][];
        int n = ((Object[])values).length;
        for (int i = 0; i < n; ++i) {
            int[] nArray = values[i];
            Intrinsics.checkNotNull((Object)nArray);
            result[i] = INSTANCE.intsToFloats(nArray);
        }
        return result;
    }

    @NotNull
    public final byte[][] floatToBytes(@NotNull float[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int rowCount = ((Object[])data).length;
        float[] fArray = data[0];
        Intrinsics.checkNotNull((Object)fArray);
        int colCount = fArray.length;
        int n = 0;
        byte[][] byArrayArray = new byte[rowCount][];
        while (n < rowCount) {
            int n2 = n++;
            byArrayArray[n2] = new byte[colCount];
        }
        byte[][] bdata = byArrayArray;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                byte[] byArray = bdata[i];
                Intrinsics.checkNotNull((Object)byArray);
                float[] fArray2 = data[i];
                Intrinsics.checkNotNull((Object)fArray2);
                byArray[j] = (byte)fArray2[j];
            }
        }
        return bdata;
    }

    @NotNull
    public final float[][] bytesToFloats(@NotNull byte[][] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int rowCount = ((Object[])values).length;
        byte[] byArray = values[0];
        Intrinsics.checkNotNull((Object)byArray);
        int colCount = byArray.length;
        int n = 0;
        float[][] fArrayArray = new float[rowCount][];
        while (n < rowCount) {
            int n2 = n++;
            fArrayArray[n2] = new float[colCount];
        }
        float[][] result = fArrayArray;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                float[] fArray = result[i];
                Intrinsics.checkNotNull((Object)fArray);
                byte[] byArray2 = values[i];
                Intrinsics.checkNotNull((Object)byArray2);
                fArray[j] = byArray2[j];
            }
        }
        return result;
    }

    @NotNull
    public final double[][] floatsToDoubles(@NotNull float[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int rowCount = ((Object[])data).length;
        float[] fArray = data[0];
        Intrinsics.checkNotNull((Object)fArray);
        int colCount = fArray.length;
        int n = 0;
        double[][] dArrayArray = new double[rowCount][];
        while (n < rowCount) {
            int n2 = n++;
            dArrayArray[n2] = new double[colCount];
        }
        double[][] ddata = dArrayArray;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                double[] dArray = ddata[i];
                Intrinsics.checkNotNull((Object)dArray);
                float[] fArray2 = data[i];
                Intrinsics.checkNotNull((Object)fArray2);
                dArray[j] = fArray2[j];
            }
        }
        return ddata;
    }

    @NotNull
    public final double[][] bytesToDoubles(@NotNull byte[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int rowCount = ((Object[])data).length;
        byte[] byArray = data[0];
        Intrinsics.checkNotNull((Object)byArray);
        int colCount = byArray.length;
        int n = 0;
        double[][] dArrayArray = new double[rowCount][];
        while (n < rowCount) {
            int n2 = n++;
            dArrayArray[n2] = new double[colCount];
        }
        double[][] ddata = dArrayArray;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                double[] dArray = ddata[i];
                Intrinsics.checkNotNull((Object)dArray);
                byte[] byArray2 = data[i];
                Intrinsics.checkNotNull((Object)byArray2);
                dArray[j] = byArray2[j];
            }
        }
        return ddata;
    }

    @NotNull
    public final int[] reverse(@NotNull int[] original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int[] result = new int[original.length];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = original[original.length - 1 - i];
        }
        return result;
    }

    @NotNull
    public final float[] reverse(@NotNull float[] original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int len = original.length;
        float[] result = new float[len];
        int i = len;
        int j = 0;
        while (--i >= 0) {
            result[j] = original[i];
            ++j;
        }
        return result;
    }

    public final int getMax(@NotNull int[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int max = Integer.MIN_VALUE;
        int i = data.length;
        while (--i >= 0) {
            int val = data[i];
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    public final float getMax(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float max = Float.NEGATIVE_INFINITY;
        int i = data.length;
        while (--i >= 0) {
            float val = data[i];
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public final double getMax(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double max = Double.NEGATIVE_INFINITY;
        int i = data.length;
        while (--i >= 0) {
            double val = data[i];
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    @NotNull
    public final float[] getMinMaxAndSmallestPositive(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float min = 3.402823E38f;
        float max = Float.MIN_VALUE;
        float minPos = Float.POSITIVE_INFINITY;
        for (float val : data) {
            if (val > max) {
                max = val;
            }
            if (val < min) {
                min = val;
            }
            if (!(val > 0.0f) || !(val < minPos)) continue;
            minPos = val;
        }
        if (minPos == 3.402823E38f) {
            minPos = Float.NaN;
        }
        float[] fArray = new float[]{min, max, minPos};
        return fArray;
    }

    @NotNull
    public final float[] getMinMaxAndSmallestPositive(@NotNull float[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        float minPos = Float.POSITIVE_INFINITY;
        int n = ((Object[])data).length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = data[0];
            Intrinsics.checkNotNull((Object)fArray);
            int n2 = fArray.length;
            for (int j = 0; j < n2; ++j) {
                float[] fArray2 = data[i];
                Intrinsics.checkNotNull((Object)fArray2);
                float val = fArray2[j];
                if (val < min) {
                    min = val;
                } else if (val > max) {
                    max = val;
                }
                if (!(val > 0.0f) || !(val < minPos)) continue;
                minPos = val;
            }
        }
        if (minPos == 3.402823E38f) {
            minPos = Float.NaN;
        }
        float[] fArray = new float[]{min, max, minPos};
        return fArray;
    }

    public final float getLogMean(@NotNull float[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float sum = 0.0f;
        int counter = 0;
        int n = ((Object[])data).length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = data[0];
            Intrinsics.checkNotNull((Object)fArray);
            int n2 = fArray.length;
            for (int j = 0; j < n2; ++j) {
                float[] fArray2 = data[i];
                Intrinsics.checkNotNull((Object)fArray2);
                if (!(fArray2[j] > 0.0f)) continue;
                float[] fArray3 = data[i];
                Intrinsics.checkNotNull((Object)fArray3);
                sum += (float)Math.log(fArray3[j]);
                ++counter;
            }
        }
        if (counter == 0) {
            return Float.NaN;
        }
        return (float)Math.exp(sum / (float)counter);
    }

    @Deprecated(message="Method find is deprecated")
    public final int find(@NotNull int[] array, int value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return this.indexOf(array, value);
    }

    public final int indexOfOrdered(@NotNull float[] array, @NotNull int[] order, float value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        int lower = 0;
        int upper = array.length;
        while (upper - lower > 1) {
            int middle = lower + upper >> 1;
            if (array[order[middle]] > value) {
                upper = middle;
                continue;
            }
            lower = middle;
        }
        return lower;
    }

    public final int indexOf(@NotNull int[] array, int value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    @JvmOverloads
    public final int indexOf(@NotNull float[] array, float value, int index) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int index2 = index;
        int len = array.length;
        if (index2 < 0) {
            index2 = 0;
        } else if (index2 >= len) {
            return -1;
        }
        for (int i = index2; i < len; ++i) {
            if (!(array[i] == value)) continue;
            return i;
        }
        return -1;
    }

    public static /* synthetic */ int indexOf$default(Array array, float[] fArray, float f, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return array.indexOf(fArray, f, n);
    }

    public final int indexOf(@NotNull String[] array, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int i = array.length;
        while (--i >= 0) {
            if (!Intrinsics.areEqual((Object)array[i], (Object)value)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(@NotNull Object[] array, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public final float[][] transpose(@NotNull float[][] data) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n2 = 0;
        float[] fArray = data[0];
        Intrinsics.checkNotNull((Object)fArray);
        int n3 = fArray.length;
        float[][] fArrayArray = new float[n3][];
        while (n2 < n3) {
            n = n2++;
            fArrayArray[n] = new float[((Object[])data).length];
        }
        float[][] result = fArrayArray;
        n3 = ((Object[])data).length;
        for (int i = 0; i < n3; ++i) {
            float[] fArray2 = data[i];
            Intrinsics.checkNotNull((Object)fArray2);
            n = fArray2.length;
            for (int j = 0; j < n; ++j) {
                float[] fArray3 = result[j];
                Intrinsics.checkNotNull((Object)fArray3);
                float[] fArray4 = data[i];
                Intrinsics.checkNotNull((Object)fArray4);
                fArray3[i] = fArray4[j];
            }
        }
        return result;
    }

    @NotNull
    public final double[][] transpose(@NotNull double[][] data) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n2 = 0;
        double[] dArray = data[0];
        Intrinsics.checkNotNull((Object)dArray);
        int n3 = dArray.length;
        double[][] dArrayArray = new double[n3][];
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[((Object[])data).length];
        }
        double[][] result = dArrayArray;
        n3 = ((Object[])data).length;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = data[i];
            Intrinsics.checkNotNull((Object)dArray2);
            n = dArray2.length;
            for (int j = 0; j < n; ++j) {
                double[] dArray3 = result[j];
                Intrinsics.checkNotNull((Object)dArray3);
                double[] dArray4 = data[i];
                Intrinsics.checkNotNull((Object)dArray4);
                dArray3[i] = dArray4[j];
            }
        }
        return result;
    }

    @NotNull
    public final float[][] createArray(int rows, int cols, float initial) {
        float[][] result = new float[rows][];
        int n = ((Object[])result).length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.createVector(cols, initial);
        }
        return result;
    }

    @NotNull
    public final float[] createVector(int length, float initial) {
        int n = 0;
        float[] fArray = new float[length];
        while (n < length) {
            int n2 = n++;
            fArray[n2] = initial;
        }
        float[] result = fArray;
        return result;
    }

    @NotNull
    public final int[] createVector(int length, int initial) {
        int n = 0;
        int[] nArray = new int[length];
        while (n < length) {
            int n2 = n++;
            nArray[n2] = initial;
        }
        int[] result = nArray;
        return result;
    }

    public final void mergeSort(@NotNull Object[] src, @NotNull Object[] dest, int low, int high, @NotNull Comparator<Object> c) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >> 1;
        this.mergeSort(dest, src, low, mid, c);
        this.mergeSort(dest, src, mid, high, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            ArrayFnKt.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private final void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    @JvmOverloads
    public final int indexOf(@NotNull float[] array, float value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return Array.indexOf$default(this, array, value, 0, 4, null);
    }
}

