/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math;

import com.macrofocus.common.math.Float3;
import com.macrofocus.common.math.Float4;
import com.macrofocus.common.math.Mat3;
import com.macrofocus.common.math.MatrixColumn;
import com.macrofocus.common.math.VectorKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 N2\u00020\u0001:\u0001NB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB+\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\u0010J\u0011\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u000202H\u0086\u0002J\u0019\u00100\u001a\u0002032\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u000202H\u0086\u0002J\u0011\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u000205H\u0086\u0002J\u0019\u00100\u001a\u0002032\u0006\u00101\u001a\u0002052\u0006\u00104\u001a\u000202H\u0086\u0002J\u0019\u00106\u001a\u0002032\u0006\u00104\u001a\u0002022\u0006\u00101\u001a\u000202H\u0086\u0002J!\u00106\u001a\u0002072\u0006\u00104\u001a\u0002022\u0006\u00101\u001a\u0002022\u0006\u00108\u001a\u000203H\u0086\u0002J\u0019\u00109\u001a\u0002072\u0006\u00101\u001a\u0002022\u0006\u00108\u001a\u00020\u0003H\u0086\u0002J!\u00109\u001a\u0002072\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002022\u0006\u00108\u001a\u000203H\u0086\u0002J\t\u0010:\u001a\u00020\u0000H\u0086\u0002J\t\u0010;\u001a\u00020\u0000H\u0086\u0002J\t\u0010<\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010=\u001a\u00020\u00002\u0006\u00108\u001a\u000203H\u0086\u0002J\u0011\u0010>\u001a\u00020\u00002\u0006\u00108\u001a\u000203H\u0086\u0002J\u0011\u0010?\u001a\u00020\u00002\u0006\u00108\u001a\u000203H\u0086\u0002J\u0011\u0010@\u001a\u00020\u00002\u0006\u00108\u001a\u000203H\u0086\u0002J\u0011\u0010?\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010?\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010A\u001a\u00020BJ\b\u0010C\u001a\u00020DH\u0016J\t\u0010E\u001a\u00020\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J1\u0010I\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010M\u001a\u000202H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R&\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n8\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n8\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR&\u0010\f\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n8\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001fR&\u0010\r\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n8\u00c6\u0002@\u00c6\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001fR\u0012\u0010&\u001a\u00020\n8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001dR\u0012\u0010(\u001a\u00020\n8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0011\u0010*\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001dR\u0012\u0010,\u001a\u00020-8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006O"}, d2={"Lcom/macrofocus/common/math/Mat4;", "", "x", "Lcom/macrofocus/common/math/Float4;", "y", "z", "w", "<init>", "(Lcom/macrofocus/common/math/Float4;Lcom/macrofocus/common/math/Float4;Lcom/macrofocus/common/math/Float4;Lcom/macrofocus/common/math/Float4;)V", "right", "Lcom/macrofocus/common/math/Float3;", "up", "forward", "position", "(Lcom/macrofocus/common/math/Float3;Lcom/macrofocus/common/math/Float3;Lcom/macrofocus/common/math/Float3;Lcom/macrofocus/common/math/Float3;)V", "m", "(Lcom/macrofocus/common/math/Mat4;)V", "getX", "()Lcom/macrofocus/common/math/Float4;", "setX", "(Lcom/macrofocus/common/math/Float4;)V", "getY", "setY", "getZ", "setZ", "getW", "setW", "value", "getRight", "()Lcom/macrofocus/common/math/Float3;", "setRight", "(Lcom/macrofocus/common/math/Float3;)V", "getUp", "setUp", "getForward", "setForward", "getPosition", "setPosition", "scale", "getScale", "translation", "getTranslation", "rotation", "getRotation", "upperLeft", "Lcom/macrofocus/common/math/Mat3;", "getUpperLeft", "()Lcom/macrofocus/common/math/Mat3;", "get", "column", "", "", "row", "Lcom/macrofocus/common/math/MatrixColumn;", "invoke", "", "v", "set", "unaryMinus", "inc", "dec", "plus", "minus", "times", "div", "toFloatArray", "", "toString", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/Mat4\n+ 2 Vector.kt\ncom/macrofocus/common/math/Float4\n+ 3 Vector.kt\ncom/macrofocus/common/math/VectorKt\n+ 4 Scalar.kt\ncom/macrofocus/common/math/ScalarKt\n*L\n1#1,559:1\n243#1:583\n248#1:585\n253#1:587\n410#2:560\n412#2,4:561\n410#2:565\n412#2,4:566\n410#2:570\n412#2,4:571\n410#2:575\n412#2,4:576\n410#2:580\n410#2:582\n410#2:584\n410#2:586\n410#2:588\n410#2:592\n435#2,5:593\n562#2:598\n563#2:599\n564#2:600\n565#2:601\n683#3:581\n35#4:589\n35#4:590\n35#4:591\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/Mat4\n*L\n269#1:583\n270#1:585\n271#1:587\n243#1:560\n245#1:561,4\n248#1:565\n250#1:566,4\n253#1:570\n255#1:571,4\n258#1:575\n260#1:576,4\n264#1:580\n266#1:582\n269#1:584\n270#1:586\n271#1:588\n282#1:592\n305#1:593,5\n327#1:598\n328#1:599\n329#1:600\n330#1:601\n264#1:581\n274#1:589\n275#1:590\n277#1:591\n*E\n"})
public final class Mat4 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Float4 x;
    @NotNull
    private Float4 y;
    @NotNull
    private Float4 z;
    @NotNull
    private Float4 w;

    public Mat4(@NotNull Float4 x, @NotNull Float4 y, @NotNull Float4 z, @NotNull Float4 w) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public /* synthetic */ Mat4(Float4 float4, Float4 float42, Float4 float43, Float4 float44, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            float4 = new Float4(1.0f, 0.0f, 0.0f, 0.0f, 14, null);
        }
        if ((n & 2) != 0) {
            float42 = new Float4(0.0f, 1.0f, 0.0f, 0.0f, 13, null);
        }
        if ((n & 4) != 0) {
            float43 = new Float4(0.0f, 0.0f, 1.0f, 0.0f, 11, null);
        }
        if ((n & 8) != 0) {
            float44 = new Float4(0.0f, 0.0f, 0.0f, 1.0f, 7, null);
        }
        this(float4, float42, float43, float44);
    }

    @NotNull
    public final Float4 getX() {
        return this.x;
    }

    public final void setX(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.x = float4;
    }

    @NotNull
    public final Float4 getY() {
        return this.y;
    }

    public final void setY(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.y = float4;
    }

    @NotNull
    public final Float4 getZ() {
        return this.z;
    }

    public final void setZ(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.z = float4;
    }

    @NotNull
    public final Float4 getW() {
        return this.w;
    }

    public final void setW(@NotNull Float4 float4) {
        Intrinsics.checkNotNullParameter((Object)float4, (String)"<set-?>");
        this.w = float4;
    }

    public Mat4(@NotNull Float3 right, @NotNull Float3 up, @NotNull Float3 forward, @NotNull Float3 position) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)up, (String)"up");
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this(new Float4(right, 0.0f, 2, null), new Float4(up, 0.0f, 2, null), new Float4(forward, 0.0f, 2, null), new Float4(position, 1.0f));
    }

    public /* synthetic */ Mat4(Float3 float3, Float3 float32, Float3 float33, Float3 float34, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            float34 = new Float3(0.0f, 0.0f, 0.0f, 7, null);
        }
        this(float3, float32, float33, float34);
    }

    public Mat4(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(Float4.copy$default(m.x, 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Float4.copy$default(m.y, 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Float4.copy$default(m.z, 0.0f, 0.0f, 0.0f, 0.0f, 15, null), Float4.copy$default(m.w, 0.0f, 0.0f, 0.0f, 0.0f, 15, null));
    }

    @NotNull
    public final Float3 getRight() {
        boolean $i$f$getRight = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    /*
     * WARNING - void declaration
     */
    public final void setRight(@NotNull Float3 value) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setRight = false;
        Float4 float4 = this.getX();
        Float3 value$iv = value;
        boolean $i$f$setXyz = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
        this_$iv.setZ(value$iv.getZ());
    }

    @NotNull
    public final Float3 getUp() {
        boolean $i$f$getUp = false;
        Float4 this_$iv = this.getY();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    /*
     * WARNING - void declaration
     */
    public final void setUp(@NotNull Float3 value) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setUp = false;
        Float4 float4 = this.getY();
        Float3 value$iv = value;
        boolean $i$f$setXyz = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
        this_$iv.setZ(value$iv.getZ());
    }

    @NotNull
    public final Float3 getForward() {
        boolean $i$f$getForward = false;
        Float4 this_$iv = this.getZ();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    /*
     * WARNING - void declaration
     */
    public final void setForward(@NotNull Float3 value) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setForward = false;
        Float4 float4 = this.getZ();
        Float3 value$iv = value;
        boolean $i$f$setXyz = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
        this_$iv.setZ(value$iv.getZ());
    }

    @NotNull
    public final Float3 getPosition() {
        boolean $i$f$getPosition = false;
        Float4 this_$iv = this.getW();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    /*
     * WARNING - void declaration
     */
    public final void setPosition(@NotNull Float3 value) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$setPosition = false;
        Float4 float4 = this.getW();
        Float3 value$iv = value;
        boolean $i$f$setXyz = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
        this_$iv.setZ(value$iv.getZ());
    }

    @NotNull
    public final Float3 getScale() {
        boolean $i$f$getScale = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        Float3 v$iv = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        boolean $i$f$length = false;
        float f = (float)Math.sqrt(v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ());
        this_$iv = this.getY();
        $i$f$getXyz = false;
        v$iv = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        $i$f$length = false;
        float f2 = (float)Math.sqrt(v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ());
        this_$iv = this.getZ();
        $i$f$getXyz = false;
        v$iv = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        $i$f$length = false;
        return new Float3(f, f2, (float)Math.sqrt(v$iv.getX() * v$iv.getX() + v$iv.getY() * v$iv.getY() + v$iv.getZ() * v$iv.getZ()));
    }

    @NotNull
    public final Float3 getTranslation() {
        boolean $i$f$getTranslation = false;
        Float4 this_$iv = this.getW();
        boolean $i$f$getXyz = false;
        return new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
    }

    @NotNull
    public final Float3 getRotation() {
        Float3 float3;
        Mat4 this_$iv = this;
        boolean $i$f$getRight = false;
        Float4 this_$iv$iv = this_$iv.getX();
        boolean $i$f$getXyz = false;
        Float3 x = VectorKt.normalize(new Float3(this_$iv$iv.getX(), this_$iv$iv.getY(), this_$iv$iv.getZ()));
        Mat4 this_$iv2 = this;
        boolean $i$f$getUp = false;
        Float4 this_$iv$iv2 = this_$iv2.getY();
        boolean $i$f$getXyz2 = false;
        Float3 y = VectorKt.normalize(new Float3(this_$iv$iv2.getX(), this_$iv$iv2.getY(), this_$iv$iv2.getZ()));
        Mat4 this_$iv3 = this;
        boolean $i$f$getForward = false;
        Float4 this_$iv$iv3 = this_$iv3.getZ();
        boolean $i$f$getXyz3 = false;
        Float3 z = VectorKt.normalize(new Float3(this_$iv$iv3.getX(), this_$iv$iv3.getY(), this_$iv$iv3.getZ()));
        if (z.getY() <= -1.0f) {
            float v$iv = -1.5707964f;
            $i$f$degrees = false;
            float f = v$iv * 57.295776f;
            v$iv = (float)Math.atan2(x.getZ(), y.getZ());
            $i$f$degrees = false;
            Float3 float32 = new Float3(f, 0.0f, v$iv * 57.295776f);
            float3 = float32;
        } else if (z.getY() >= 1.0f) {
            float v$iv = 1.5707964f;
            $i$f$degrees = false;
            float f = v$iv * 57.295776f;
            v$iv = (float)Math.atan2(-x.getZ(), -y.getZ());
            $i$f$degrees = false;
            Float3 float33 = new Float3(f, 0.0f, v$iv * 57.295776f);
            float3 = float33;
        } else {
            float v$iv = -((float)Math.asin(z.getY()));
            $i$f$degrees = false;
            float f = v$iv * 57.295776f;
            v$iv = -((float)Math.atan2(z.getX(), z.getZ()));
            $i$f$degrees = false;
            float f2 = v$iv * 57.295776f;
            v$iv = (float)Math.atan2(x.getY(), y.getY());
            $i$f$degrees = false;
            Float3 float34 = new Float3(f, f2, v$iv * 57.295776f);
            float3 = float34;
        }
        return float3;
    }

    @NotNull
    public final Mat3 getUpperLeft() {
        boolean $i$f$getUpperLeft = false;
        Float4 this_$iv = this.getX();
        boolean $i$f$getXyz = false;
        Float3 float3 = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        this_$iv = this.getY();
        $i$f$getXyz = false;
        Float3 float32 = new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ());
        this_$iv = this.getZ();
        $i$f$getXyz = false;
        return new Mat3(float3, float32, new Float3(this_$iv.getX(), this_$iv.getY(), this_$iv.getZ()));
    }

    @NotNull
    public final Float4 get(int column) {
        return switch (column) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            case 3 -> this.w;
            default -> throw new IllegalArgumentException("column must be in 0..3");
        };
    }

    public final float get(int column, int row) {
        return this.get(column).get(row);
    }

    @NotNull
    public final Float4 get(@NotNull MatrixColumn column) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return switch (WhenMappings.$EnumSwitchMapping$0[column.ordinal()]) {
            case 1 -> this.x;
            case 2 -> this.y;
            case 3 -> this.z;
            case 4 -> this.w;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final float get(@NotNull MatrixColumn column, int row) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return this.get(column).get(row);
    }

    public final float invoke(int row, int column) {
        return this.get(column - 1).get(row - 1);
    }

    public final void invoke(int row, int column, float v) {
        this.set(column - 1, row - 1, v);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int column, @NotNull Float4 v) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Float4 float4 = this.get(column);
        Float4 value$iv = v;
        boolean $i$f$setXyzw = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
        this_$iv.setZ(value$iv.getZ());
        this_$iv.setW(value$iv.getW());
    }

    public final void set(int column, int row, float v) {
        this.get(column).set(row, v);
    }

    @NotNull
    public final Mat4 unaryMinus() {
        return new Mat4(this.x.unaryMinus(), this.y.unaryMinus(), this.z.unaryMinus(), this.w.unaryMinus());
    }

    @NotNull
    public final Mat4 inc() {
        Float4 float4 = this.x;
        this.x = float4.inc();
        float4 = this.y;
        this.y = float4.inc();
        float4 = this.z;
        this.z = float4.inc();
        float4 = this.w;
        this.w = float4.inc();
        return this;
    }

    @NotNull
    public final Mat4 dec() {
        Float4 float4 = this.x;
        this.x = float4.dec();
        float4 = this.y;
        this.y = float4.dec();
        float4 = this.z;
        this.z = float4.dec();
        float4 = this.w;
        this.w = float4.dec();
        return this;
    }

    @NotNull
    public final Mat4 plus(float v) {
        Float4 this_$iv;
        Float4 float4 = this.x;
        float v$iv = v;
        boolean $i$f$plus = false;
        Float4 float42 = new Float4(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv, this_$iv.getW() + v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$plus = false;
        Float4 float43 = new Float4(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv, this_$iv.getW() + v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$plus = false;
        Float4 float44 = new Float4(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv, this_$iv.getW() + v$iv);
        this_$iv = this.w;
        v$iv = v;
        $i$f$plus = false;
        return new Mat4(float42, float43, float44, new Float4(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv, this_$iv.getW() + v$iv));
    }

    @NotNull
    public final Mat4 minus(float v) {
        Float4 this_$iv;
        Float4 float4 = this.x;
        float v$iv = v;
        boolean $i$f$minus = false;
        Float4 float42 = new Float4(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv, this_$iv.getW() - v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$minus = false;
        Float4 float43 = new Float4(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv, this_$iv.getW() - v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$minus = false;
        Float4 float44 = new Float4(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv, this_$iv.getW() - v$iv);
        this_$iv = this.w;
        v$iv = v;
        $i$f$minus = false;
        return new Mat4(float42, float43, float44, new Float4(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv, this_$iv.getW() - v$iv));
    }

    @NotNull
    public final Mat4 times(float v) {
        Float4 this_$iv;
        Float4 float4 = this.x;
        float v$iv = v;
        boolean $i$f$times = false;
        Float4 float42 = new Float4(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv, this_$iv.getW() * v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$times = false;
        Float4 float43 = new Float4(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv, this_$iv.getW() * v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$times = false;
        Float4 float44 = new Float4(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv, this_$iv.getW() * v$iv);
        this_$iv = this.w;
        v$iv = v;
        $i$f$times = false;
        return new Mat4(float42, float43, float44, new Float4(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv, this_$iv.getW() * v$iv));
    }

    @NotNull
    public final Mat4 div(float v) {
        Float4 this_$iv;
        Float4 float4 = this.x;
        float v$iv = v;
        boolean $i$f$div = false;
        Float4 float42 = new Float4(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv, this_$iv.getW() / v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$div = false;
        Float4 float43 = new Float4(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv, this_$iv.getW() / v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$div = false;
        Float4 float44 = new Float4(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv, this_$iv.getW() / v$iv);
        this_$iv = this.w;
        v$iv = v;
        $i$f$div = false;
        return new Mat4(float42, float43, float44, new Float4(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv, this_$iv.getW() / v$iv));
    }

    @NotNull
    public final Mat4 times(@NotNull Mat4 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat4(new Float4(this.x.getX() * m.x.getX() + this.y.getX() * m.x.getY() + this.z.getX() * m.x.getZ() + this.w.getX() * m.x.getW(), this.x.getY() * m.x.getX() + this.y.getY() * m.x.getY() + this.z.getY() * m.x.getZ() + this.w.getY() * m.x.getW(), this.x.getZ() * m.x.getX() + this.y.getZ() * m.x.getY() + this.z.getZ() * m.x.getZ() + this.w.getZ() * m.x.getW(), this.x.getW() * m.x.getX() + this.y.getW() * m.x.getY() + this.z.getW() * m.x.getZ() + this.w.getW() * m.x.getW()), new Float4(this.x.getX() * m.y.getX() + this.y.getX() * m.y.getY() + this.z.getX() * m.y.getZ() + this.w.getX() * m.y.getW(), this.x.getY() * m.y.getX() + this.y.getY() * m.y.getY() + this.z.getY() * m.y.getZ() + this.w.getY() * m.y.getW(), this.x.getZ() * m.y.getX() + this.y.getZ() * m.y.getY() + this.z.getZ() * m.y.getZ() + this.w.getZ() * m.y.getW(), this.x.getW() * m.y.getX() + this.y.getW() * m.y.getY() + this.z.getW() * m.y.getZ() + this.w.getW() * m.y.getW()), new Float4(this.x.getX() * m.z.getX() + this.y.getX() * m.z.getY() + this.z.getX() * m.z.getZ() + this.w.getX() * m.z.getW(), this.x.getY() * m.z.getX() + this.y.getY() * m.z.getY() + this.z.getY() * m.z.getZ() + this.w.getY() * m.z.getW(), this.x.getZ() * m.z.getX() + this.y.getZ() * m.z.getY() + this.z.getZ() * m.z.getZ() + this.w.getZ() * m.z.getW(), this.x.getW() * m.z.getX() + this.y.getW() * m.z.getY() + this.z.getW() * m.z.getZ() + this.w.getW() * m.z.getW()), new Float4(this.x.getX() * m.w.getX() + this.y.getX() * m.w.getY() + this.z.getX() * m.w.getZ() + this.w.getX() * m.w.getW(), this.x.getY() * m.w.getX() + this.y.getY() * m.w.getY() + this.z.getY() * m.w.getZ() + this.w.getY() * m.w.getW(), this.x.getZ() * m.w.getX() + this.y.getZ() * m.w.getY() + this.z.getZ() * m.w.getZ() + this.w.getZ() * m.w.getW(), this.x.getW() * m.w.getX() + this.y.getW() * m.w.getY() + this.z.getW() * m.w.getZ() + this.w.getW() * m.w.getW()));
    }

    @NotNull
    public final Float4 times(@NotNull Float4 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Float4(this.x.getX() * v.getX() + this.y.getX() * v.getY() + this.z.getX() * v.getZ() + this.w.getX() * v.getW(), this.x.getY() * v.getX() + this.y.getY() * v.getY() + this.z.getY() * v.getZ() + this.w.getY() * v.getW(), this.x.getZ() * v.getX() + this.y.getZ() * v.getY() + this.z.getZ() * v.getZ() + this.w.getZ() * v.getW(), this.x.getW() * v.getX() + this.y.getW() * v.getY() + this.z.getW() * v.getZ() + this.w.getW() * v.getW());
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] fArray = new float[]{this.x.getX(), this.y.getX(), this.z.getX(), this.w.getX(), this.x.getY(), this.y.getY(), this.z.getY(), this.w.getY(), this.x.getZ(), this.y.getZ(), this.z.getZ(), this.w.getZ(), this.x.getW(), this.y.getW(), this.z.getW(), this.w.getW()};
        return fArray;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            |" + this.x.getX() + " " + this.y.getX() + " " + this.z.getX() + " " + this.w.getX() + "|\n            |" + this.x.getY() + " " + this.y.getY() + " " + this.z.getY() + " " + this.w.getY() + "|\n            |" + this.x.getZ() + " " + this.y.getZ() + " " + this.z.getZ() + " " + this.w.getZ() + "|\n            |" + this.x.getW() + " " + this.y.getW() + " " + this.z.getW() + " " + this.w.getW() + "|\n            "));
    }

    @NotNull
    public final Float4 component1() {
        return this.x;
    }

    @NotNull
    public final Float4 component2() {
        return this.y;
    }

    @NotNull
    public final Float4 component3() {
        return this.z;
    }

    @NotNull
    public final Float4 component4() {
        return this.w;
    }

    @NotNull
    public final Mat4 copy(@NotNull Float4 x, @NotNull Float4 y, @NotNull Float4 z, @NotNull Float4 w) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return new Mat4(x, y, z, w);
    }

    public static /* synthetic */ Mat4 copy$default(Mat4 mat4, Float4 float4, Float4 float42, Float4 float43, Float4 float44, int n, Object object) {
        if ((n & 1) != 0) {
            float4 = mat4.x;
        }
        if ((n & 2) != 0) {
            float42 = mat4.y;
        }
        if ((n & 4) != 0) {
            float43 = mat4.z;
        }
        if ((n & 8) != 0) {
            float44 = mat4.w;
        }
        return mat4.copy(float4, float42, float43, float44);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = result * 31 + this.y.hashCode();
        result = result * 31 + this.z.hashCode();
        result = result * 31 + this.w.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mat4)) {
            return false;
        }
        Mat4 mat4 = (Mat4)other;
        if (!Intrinsics.areEqual((Object)this.x, (Object)mat4.x)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.y, (Object)mat4.y)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.z, (Object)mat4.z)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.w, (Object)mat4.w);
    }

    public Mat4() {
        this((Float4)null, (Float4)null, (Float4)null, (Float4)null, 15, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00020\u0007\"\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/math/Mat4$Companion;", "", "<init>", "()V", "of", "Lcom/macrofocus/common/math/Mat4;", "a", "", "", "identity", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Mat4 of(float ... a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (!(a.length >= 16)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Mat4(new Float4(a[0], a[4], a[8], a[12]), new Float4(a[1], a[5], a[9], a[13]), new Float4(a[2], a[6], a[10], a[14]), new Float4(a[3], a[7], a[11], a[15]));
        }

        @NotNull
        public final Mat4 identity() {
            return new Mat4(null, null, null, null, 15, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatrixColumn.values().length];
            try {
                nArray[MatrixColumn.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.W.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

