/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math.big;

import com.macrofocus.common.math.big.CommonBigInteger;
import com.macrofocus.common.math.big.MutableBigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bJ\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0082\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J \u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/macrofocus/common/math/big/BitSieve;", "", "<init>", "()V", "base", "Lcom/macrofocus/common/math/big/CommonBigInteger;", "searchLen", "", "(Lcom/macrofocus/common/math/big/CommonBigInteger;I)V", "bits", "", "length", "get", "", "bitIndex", "set", "", "sieveSearch", "limit", "start", "sieveSingle", "step", "retrieve", "initValue", "certainty", "random", "Lkotlin/random/Random;", "Companion", "macrofocus-common"})
public final class BitSieve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private long[] bits;
    private int length;
    @NotNull
    private static final BitSieve smallSieve = new BitSieve();

    private BitSieve() {
        this.length = 9600;
        this.bits = new long[BitSieve.Companion.unitIndex(this.length - 1) + 1];
        this.set(0);
        int nextIndex = 1;
        int nextPrime = 3;
        do {
            this.sieveSingle(this.length, nextIndex + nextPrime, nextPrime);
            nextIndex = this.sieveSearch(this.length, nextIndex + 1);
            nextPrime = 2 * nextIndex + 1;
        } while (nextIndex > 0 && nextPrime < this.length);
    }

    public BitSieve(@NotNull CommonBigInteger base, int searchLen) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.bits = new long[BitSieve.Companion.unitIndex(searchLen - 1) + 1];
        this.length = searchLen;
        int start = 0;
        int step = smallSieve.sieveSearch(BitSieve.smallSieve.length, start);
        int convertedStep = step * 2 + 1;
        MutableBigInteger b = new MutableBigInteger(base);
        MutableBigInteger q = new MutableBigInteger();
        do {
            start = b.divideOneWord(convertedStep, q);
            if ((start = convertedStep - start) % 2 == 0) {
                start += convertedStep;
            }
            this.sieveSingle(searchLen, (start - 1) / 2, convertedStep);
            step = smallSieve.sieveSearch(BitSieve.smallSieve.length, step + 1);
            convertedStep = step * 2 + 1;
        } while (step > 0);
    }

    private final boolean get(int bitIndex) {
        int unitIndex = BitSieve.Companion.unitIndex(bitIndex);
        Intrinsics.checkNotNull((Object)this.bits);
        return (this.bits[unitIndex] & BitSieve.Companion.bit(bitIndex)) != 0L;
    }

    private final void set(int bitIndex) {
        int unitIndex = BitSieve.Companion.unitIndex(bitIndex);
        Intrinsics.checkNotNull((Object)this.bits);
        Intrinsics.checkNotNull((Object)this.bits);
        this.bits[unitIndex] = this.bits[unitIndex] | BitSieve.Companion.bit(bitIndex);
    }

    private final int sieveSearch(int limit, int start) {
        if (start >= limit) {
            return -1;
        }
        int index = start;
        do {
            if (this.get(index)) continue;
            return index;
        } while (++index < limit - 1);
        return -1;
    }

    private final void sieveSingle(int limit, int start, int step) {
        for (int start2 = start; start2 < limit; start2 += step) {
            this.set(start2);
        }
    }

    @Nullable
    public final CommonBigInteger retrieve(@NotNull CommonBigInteger initValue, int certainty, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)initValue, (String)"initValue");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        int offset = 1;
        Intrinsics.checkNotNull((Object)this.bits);
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.bits);
            long nextLong = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            for (int j = 0; j < 64; ++j) {
                CommonBigInteger candidate;
                if ((nextLong & 1L) == 1L && (candidate = initValue.plus(CommonBigInteger.Companion.of((long)offset))).primeToCertainty$macrofocus_common(certainty, random)) {
                    return candidate;
                }
                nextLong >>>= 1;
                offset += 2;
            }
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/macrofocus/common/math/big/BitSieve$Companion;", "", "<init>", "()V", "smallSieve", "Lcom/macrofocus/common/math/big/BitSieve;", "unitIndex", "", "bitIndex", "bit", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        private final int unitIndex(int bitIndex) {
            return bitIndex >>> 6;
        }

        private final long bit(int bitIndex) {
            return 1L << (bitIndex & 0x3F);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

