/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math.big;

import com.macrofocus.common.math.big.BigDecimal;
import com.macrofocus.common.math.big.CommonBigInteger;
import com.macrofocus.common.math.big.MathContext;
import com.macrofocus.common.math.big.MutableBigInteger;
import com.macrofocus.common.math.big.RoundingMode;
import com.macrofocus.common.math.big.Utils;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\f\b\u0000\u0018\u0000 \u0081\u00012\u00020\u0001:\u0005\u007f\u0080\u0001\u0081\u0001B+\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u0011B\u0019\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u0012B\u0011\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0013\u00a2\u0006\u0004\b\t\u0010\u0014B\u0019\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0013\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u0015B\u001b\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u0017B\u0011\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u0018B\u0019\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u0019B\u0019\b\u0010\u0012\u0006\u0010\u001a\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\u001bB#\b\u0010\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u001cB\u0011\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\u001dB\u0019\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010\u001eB\u0011\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u001fB\u0019\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\t\u0010 J\u0018\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0013\u0010,\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010,\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J3\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000/2\u0006\u00100\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u00102J\u0011\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0001H\u0096\u0002J\u0018\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u00105\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0018\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0003J\u0018\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0007H\u0003J\u0011\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0001H\u0096\u0002J\u001a\u00107\u001a\u0004\u0018\u00010\u00002\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0001H\u0016J\u0018\u0010:\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010;\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010;\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000=2\u0006\u00108\u001a\u00020\u0001H\u0016J$\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000=2\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010>\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010A\u001a\u00020'2\u0006\u0010@\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0007H\u0096\u0004J\u001a\u0010B\u001a\u0004\u0018\u00010\u00002\u0006\u0010C\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010G\u001a\u00020\u0000H\u0096\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010H\u001a\u00020\u0000H\u0096\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010R\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u00072\u0006\u00109\u001a\u00020UH\u0016J\u0018\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0007H\u0017J\u0010\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0007H\u0016J\u0010\u0010V\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0007H\u0016J\u0010\u0010W\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0007H\u0016J\u0010\u0010X\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0007H\u0016J\b\u0010Y\u001a\u00020\u0000H\u0016J\u0011\u0010Z\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010\\\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0000H\u0002J\u0013\u0010]\u001a\u00020'2\b\u0010[\u001a\u0004\u0018\u00010^H\u0096\u0002J\u0010\u0010_\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0016J\u0010\u0010`\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0016J\b\u0010a\u001a\u00020\u0007H\u0016J\b\u0010b\u001a\u00020\u0013H\u0016J\b\u0010c\u001a\u00020\u0013H\u0016J\b\u0010d\u001a\u00020\u0013H\u0016J \u0010e\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u00072\u0006\u0010f\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010g\u001a\u00020\u0003H\u0016J\b\u0010h\u001a\u00020\u0003H\u0016J\b\u0010i\u001a\u00020\u0005H\u0016J\b\u0010j\u001a\u00020\u0005H\u0016J\b\u0010k\u001a\u00020\u0007H\u0016J\b\u0010l\u001a\u00020mH\u0016J\b\u0010n\u001a\u00020oH\u0016J\b\u0010p\u001a\u00020qH\u0016J\b\u0010r\u001a\u00020\u0007H\u0016J\b\u0010s\u001a\u00020qH\u0016J\b\u0010t\u001a\u00020mH\u0016J\b\u0010u\u001a\u00020vH\u0016J\b\u0010w\u001a\u00020\u0016H\u0016J\b\u0010x\u001a\u00020\u0000H\u0016J\u0010\u0010y\u001a\u00020\u00132\u0006\u0010z\u001a\u00020'H\u0002J\u0010\u0010{\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0007H\u0002J\b\u0010|\u001a\u00020\u0003H\u0002J\u0010\u0010}\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010~\u001a\u00020\u0000H\u0002R\u0010\u0010!\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u0014\u0010D\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010I\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010KR\u0014\u0010M\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010KR\u0014\u0010O\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q\u00a8\u0006\u0082\u0001"}, d2={"Lcom/macrofocus/common/math/big/CommonBigDecimal;", "Lcom/macrofocus/common/math/big/BigDecimal;", "intVal", "Lcom/macrofocus/common/math/big/CommonBigInteger;", "val", "", "scale", "", "prec", "<init>", "(Lcom/macrofocus/common/math/big/CommonBigInteger;JII)V", "in", "", "offset", "len", "mc", "Lcom/macrofocus/common/math/big/MathContext;", "([CIILcom/macrofocus/common/math/big/MathContext;)V", "([CLcom/macrofocus/common/math/big/MathContext;)V", "", "(Ljava/lang/String;)V", "(Ljava/lang/String;Lcom/macrofocus/common/math/big/MathContext;)V", "", "(DLcom/macrofocus/common/math/big/MathContext;)V", "(Lcom/macrofocus/common/math/big/CommonBigInteger;)V", "(Lcom/macrofocus/common/math/big/CommonBigInteger;Lcom/macrofocus/common/math/big/MathContext;)V", "unscaledVal", "(Lcom/macrofocus/common/math/big/CommonBigInteger;I)V", "(Lcom/macrofocus/common/math/big/CommonBigInteger;ILcom/macrofocus/common/math/big/MathContext;)V", "(I)V", "(ILcom/macrofocus/common/math/big/MathContext;)V", "(J)V", "(JLcom/macrofocus/common/math/big/MathContext;)V", "_intVal", "_scale", "_precision", "_stringCache", "_intCompact", "isPowerOfTen", "", "()Z", "adjustScale", "scl", "exp", "plus", "augend", "preAlign", "", "lhs", "padding", "(Lcom/macrofocus/common/math/big/CommonBigDecimal;Lcom/macrofocus/common/math/big/CommonBigDecimal;JLcom/macrofocus/common/math/big/MathContext;)[Lcom/macrofocus/common/math/big/CommonBigDecimal;", "minus", "subtrahend", "times", "multiplicand", "div", "divisor", "roundingMode", "divideToIntegralValue", "rem", "divideAndRemainder", "Lkotlin/Pair;", "sqrt", "squareRootResultAssertions", "result", "squareRootZeroResultAssertions", "pow", "n", "absoluteValue", "getAbsoluteValue", "()Lcom/macrofocus/common/math/big/CommonBigDecimal;", "unaryMinus", "unaryPlus", "signum", "getSignum", "()I", "getScale", "precision", "getPrecision", "unscaledValue", "getUnscaledValue", "()Lcom/macrofocus/common/math/big/CommonBigInteger;", "round", "setScale", "newScale", "Lcom/macrofocus/common/math/big/RoundingMode;", "movePointLeft", "movePointRight", "scaleByPowerOfTen", "stripTrailingZeros", "compareTo", "other", "compareMagnitude", "equals", "", "min", "max", "hashCode", "toString", "toEngineeringString", "toPlainString", "getValueString", "intString", "toBigInteger", "toBigIntegerExact", "toLong", "toLongExact", "toInt", "toByte", "", "toChar", "", "toShort", "", "toIntExact", "toShortExact", "toByteExact", "toFloat", "", "toDouble", "ulp", "layoutChars", "sci", "bigMultiplyPowerTen", "inflated", "checkScale", "audit", "LongOverflow", "StringBuilderHelper", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nCommonBigDecimal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBigDecimal.kt\ncom/macrofocus/common/math/big/CommonBigDecimal\n+ 2 JvmUtils.kt\ncom/macrofocus/common/math/big/JvmUtils\n*L\n1#1,5450:1\n44#2:5451\n44#2:5452\n44#2:5453\n44#2:5454\n44#2:5455\n44#2:5456\n44#2:5457\n44#2:5458\n44#2:5459\n44#2:5460\n44#2:5461\n44#2:5462\n*S KotlinDebug\n*F\n+ 1 CommonBigDecimal.kt\ncom/macrofocus/common/math/big/CommonBigDecimal\n*L\n1040#1:5451\n1060#1:5452\n1184#1:5453\n1207#1:5454\n1213#1:5455\n1234#1:5456\n1360#1:5457\n1425#1:5458\n1474#1:5459\n1521#1:5460\n1607#1:5461\n2119#1:5462\n*E\n"})
public final class CommonBigDecimal
implements BigDecimal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CommonBigInteger _intVal;
    private final int _scale;
    private int _precision;
    @Nullable
    private String _stringCache;
    private final long _intCompact;
    public static final long INFLATED = Long.MIN_VALUE;
    @NotNull
    private static final CommonBigInteger INFLATED_BIGINT = CommonBigInteger.Companion.of(Long.MIN_VALUE);
    private static final int MAX_COMPACT_DIGITS = 18;
    @NotNull
    private static final CommonBigDecimal[] ZERO_THROUGH_TEN;
    @NotNull
    private static final CommonBigDecimal[] ZERO_SCALED_BY;
    private static final long HALF_LONG_MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final long HALF_LONG_MIN_VALUE = -4611686018427387904L;
    @JvmField
    @NotNull
    public static final CommonBigDecimal ZERO;
    @JvmField
    @NotNull
    public static final CommonBigDecimal ONE;
    @JvmField
    @NotNull
    public static final CommonBigDecimal TWO;
    @JvmField
    @NotNull
    public static final CommonBigDecimal TEN;
    @JvmField
    @NotNull
    public static final CommonBigDecimal ONE_TENTH;
    @JvmField
    @NotNull
    public static final CommonBigDecimal ONE_HALF;
    @JvmField
    @NotNull
    public static final CommonBigDecimal PI;
    @JvmField
    @NotNull
    public static final CommonBigDecimal E;
    @NotNull
    private static final double[] DOUBLE_10_POW;
    @NotNull
    private static final float[] FLOAT_10_POW;
    @NotNull
    private static final long[] LONG_TEN_POWERS_TABLE;
    @NotNull
    private static CommonBigInteger[] BIG_TEN_POWERS_TABLE;
    private static final int BIG_TEN_POWERS_TABLE_INITLEN;
    private static final int BIG_TEN_POWERS_TABLE_MAX;
    @NotNull
    private static final long[] THRESHOLDS_TABLE;
    private static final long DIV_NUM_BASE = 0x100000000L;
    @NotNull
    private static final long[][] LONGLONG_TEN_POWERS_TABLE;

    private final boolean isPowerOfTen() {
        return Intrinsics.areEqual((Object)CommonBigInteger.ONE, (Object)this.getUnscaledValue());
    }

    public CommonBigDecimal(@Nullable CommonBigInteger intVal, long val, int scale, int prec) {
        this._scale = scale;
        this._precision = prec;
        this._intCompact = val;
        this._intVal = intVal;
    }

    public CommonBigDecimal(@NotNull char[] in, int offset, int len, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        int offset2 = offset;
        int len2 = len;
        if (offset2 + len2 > in.length || offset2 < 0) {
            throw new NumberFormatException("Bad offset or len arguments for char[] input.");
        }
        int prec = 0;
        int scl = 0;
        long rs = 0L;
        CommonBigInteger rb = null;
        try {
            boolean isneg = false;
            if (in[offset2] == '-') {
                isneg = true;
                ++offset2;
                --len2;
            } else if (in[offset2] == '+') {
                ++offset2;
                --len2;
            }
            boolean dot = false;
            long exp = 0L;
            char c = '\u0000';
            boolean isCompact = len2 <= 18;
            int idx = 0;
            if (isCompact) {
                while (len2 > 0) {
                    c = in[offset2];
                    if (c == '0') {
                        if (prec == 0) {
                            prec = 1;
                        } else if (rs != 0L) {
                            rs *= (long)10;
                            ++prec;
                        }
                        if (dot) {
                            ++scl;
                        }
                    } else {
                        boolean bl = '1' <= c ? c < ':' : false;
                        if (bl) {
                            digit = c - 48;
                            if (prec != 1 || rs != 0L) {
                                ++prec;
                            }
                            rs = rs * (long)10 + (long)digit;
                            if (dot) {
                                ++scl;
                            }
                        } else if (c == '.') {
                            if (dot) {
                                throw new NumberFormatException("Character array contains more than one decimal point.");
                            }
                            dot = true;
                        } else if (Utils.isDigit(c)) {
                            digit = Utils.toDigit(c, 10);
                            if (digit == 0) {
                                if (prec == 0) {
                                    prec = 1;
                                } else if (rs != 0L) {
                                    rs *= (long)10;
                                    ++prec;
                                }
                            } else {
                                if (prec != 1 || rs != 0L) {
                                    ++prec;
                                }
                                rs = rs * (long)10 + (long)digit;
                            }
                            if (dot) {
                                ++scl;
                            }
                        } else {
                            if (c == 'e' || c == 'E') {
                                exp = CommonBigDecimal.Companion.parseExp(in, offset2, len2);
                                if ((long)((int)exp) == exp) break;
                                throw new NumberFormatException("Exponent overflow.");
                            }
                            throw new NumberFormatException("Character " + c + " is neither a decimal digit number, decimal point, nor \"e\" notation exponential mark.");
                        }
                    }
                    ++offset2;
                    --len2;
                }
                if (prec == 0) {
                    throw new NumberFormatException("No digits found.");
                }
                if (exp != 0L) {
                    scl = this.adjustScale(scl, exp);
                }
                rs = isneg ? -rs : rs;
                int mcp = mc.getPrecision();
                int drop = prec - mcp;
                if (mcp > 0 && drop > 0) {
                    while (drop > 0) {
                        scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                        rs = CommonBigDecimal.Companion.divideAndRound(rs, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                        prec = Companion.longDigitLength$macrofocus_common(rs);
                        drop = prec - mcp;
                    }
                }
            } else {
                char[] coeff = new char[len2];
                while (len2 > 0) {
                    c = in[offset2];
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl || Utils.isDigit(c)) {
                        if (c == '0' || Utils.toDigit(c, 10) == 0) {
                            if (prec == 0) {
                                coeff[idx] = c;
                                prec = 1;
                            } else if (idx != 0) {
                                coeff[idx++] = c;
                                ++prec;
                            }
                        } else {
                            if (prec != 1 || idx != 0) {
                                ++prec;
                            }
                            coeff[idx++] = c;
                        }
                        if (dot) {
                            ++scl;
                        }
                        ++offset2;
                        --len2;
                        continue;
                    }
                    if (c == '.') {
                        if (dot) {
                            throw new NumberFormatException("Character array contains more than one decimal point.");
                        }
                        dot = true;
                        ++offset2;
                        --len2;
                        continue;
                    }
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException("Character array is missing \"e\" notation exponential mark.");
                    }
                    exp = CommonBigDecimal.Companion.parseExp(in, offset2, len2);
                    if ((long)((int)exp) == exp) break;
                    throw new NumberFormatException("Exponent overflow.");
                }
                if (prec == 0) {
                    throw new NumberFormatException("No digits found.");
                }
                if (exp != 0L) {
                    scl = this.adjustScale(scl, exp);
                }
                rb = new CommonBigInteger(coeff, isneg ? -1 : 1, prec);
                rs = CommonBigDecimal.Companion.compactValFor(rb);
                int mcp = mc.getPrecision();
                boolean bl = 1 <= mcp ? mcp < prec : false;
                if (bl) {
                    int drop;
                    if (rs == Long.MIN_VALUE) {
                        drop = prec - mcp;
                        while (drop > 0) {
                            scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                            CommonBigInteger commonBigInteger = rb;
                            Intrinsics.checkNotNull((Object)commonBigInteger);
                            rb = CommonBigDecimal.Companion.divideAndRoundByTenPow(commonBigInteger, drop, mc.getRoundingMode().getValue());
                            rs = CommonBigDecimal.Companion.compactValFor(rb);
                            if (rs != Long.MIN_VALUE) {
                                prec = Companion.longDigitLength$macrofocus_common(rs);
                                break;
                            }
                            prec = CommonBigDecimal.Companion.bigDigitLength(rb);
                            drop = prec - mcp;
                        }
                    }
                    if (rs != Long.MIN_VALUE) {
                        drop = prec - mcp;
                        while (drop > 0) {
                            scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                            rs = CommonBigDecimal.Companion.divideAndRound(rs, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                            prec = Companion.longDigitLength$macrofocus_common(rs);
                            drop = prec - mcp;
                        }
                        rb = null;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            NumberFormatException nfe = new NumberFormatException();
            throw nfe;
        }
        catch (RuntimeException e) {
            NumberFormatException nfe = new NumberFormatException();
            throw nfe;
        }
        this._scale = scl;
        this._precision = prec;
        this._intCompact = rs;
        this._intVal = rb;
    }

    public /* synthetic */ CommonBigDecimal(char[] cArray, int n, int n2, MathContext mathContext, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = cArray.length;
        }
        if ((n3 & 8) != 0) {
            mathContext = MathContext.UNLIMITED;
        }
        this(cArray, n, n2, mathContext);
    }

    private final int adjustScale(int scl, long exp) {
        int scl2 = scl;
        long adjustedScale = (long)scl2 - exp;
        if (adjustedScale > Integer.MAX_VALUE || adjustedScale < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range.");
        }
        scl2 = (int)adjustedScale;
        return scl2;
    }

    public CommonBigDecimal(@NotNull char[] in, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this(in, 0, in.length, mc);
    }

    public CommonBigDecimal(@NotNull String val) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        this(Utils.toCharArray(val), 0, val.length(), null, 8, null);
    }

    public CommonBigDecimal(@NotNull String val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this(Utils.toCharArray(val), 0, val.length(), mc);
    }

    public CommonBigDecimal(double val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        if (Double.isInfinite(val) || Double.isInfinite(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long valBits = Double.doubleToLongBits(val);
        int sign = valBits >> 63 == 0L ? 1 : -1;
        int exponent = (int)(valBits >> 52 & 0x7FFL);
        long significand = exponent == 0 ? (valBits & 0xFFFFFFFFFFFFFL) << 1 : valBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        exponent -= 1075;
        if (significand == 0L) {
            this._intVal = CommonBigInteger.ZERO;
            this._scale = 0;
            this._intCompact = 0L;
            this._precision = 1;
            return;
        }
        while ((significand & 1L) == 0L) {
            significand >>= 1;
            ++exponent;
        }
        int scl = 0;
        CommonBigInteger rb = null;
        long compactVal = (long)sign * significand;
        if (exponent == 0) {
            rb = compactVal == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        } else {
            if (exponent < 0) {
                rb = CommonBigInteger.Companion.of(5).pow(-exponent).timesLong$macrofocus_common(compactVal);
                scl = -exponent;
            } else {
                rb = CommonBigInteger.TWO.pow(exponent).timesLong$macrofocus_common(compactVal);
            }
            compactVal = CommonBigDecimal.Companion.compactValFor(rb);
        }
        int prec = 0;
        int mcp = mc.getPrecision();
        if (mcp > 0) {
            int mode = mc.getRoundingMode().getValue();
            int drop = 0;
            if (compactVal == Long.MIN_VALUE) {
                CommonBigInteger commonBigInteger = rb;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                prec = CommonBigDecimal.Companion.bigDigitLength(commonBigInteger);
                drop = prec - mcp;
                while (drop > 0) {
                    scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    CommonBigInteger commonBigInteger2 = rb;
                    Intrinsics.checkNotNull((Object)commonBigInteger2);
                    rb = CommonBigDecimal.Companion.divideAndRoundByTenPow(commonBigInteger2, drop, mode);
                    compactVal = CommonBigDecimal.Companion.compactValFor(rb);
                    if (compactVal != Long.MIN_VALUE) break;
                    prec = CommonBigDecimal.Companion.bigDigitLength(rb);
                    drop = prec - mcp;
                }
            }
            if (compactVal != Long.MIN_VALUE) {
                prec = Companion.longDigitLength$macrofocus_common(compactVal);
                drop = prec - mcp;
                while (drop > 0) {
                    scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    compactVal = CommonBigDecimal.Companion.divideAndRound(compactVal, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                    prec = Companion.longDigitLength$macrofocus_common(compactVal);
                    drop = prec - mcp;
                }
                rb = null;
            }
        }
        this._intVal = rb;
        this._intCompact = compactVal;
        this._scale = scl;
        this._precision = prec;
    }

    public /* synthetic */ CommonBigDecimal(double d, MathContext mathContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mathContext = MathContext.UNLIMITED;
        }
        this(d, mathContext);
    }

    public CommonBigDecimal(@NotNull CommonBigInteger val) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        this._scale = 0;
        this._intVal = val;
        this._intCompact = CommonBigDecimal.Companion.compactValFor(val);
    }

    public CommonBigDecimal(@NotNull CommonBigInteger val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this(val, 0, mc);
    }

    public CommonBigDecimal(@NotNull CommonBigInteger unscaledVal, int scale) {
        Intrinsics.checkNotNullParameter((Object)unscaledVal, (String)"unscaledVal");
        this._intVal = unscaledVal;
        this._intCompact = CommonBigDecimal.Companion.compactValFor(unscaledVal);
        this._scale = scale;
    }

    public CommonBigDecimal(@Nullable CommonBigInteger unscaledVal, int scale, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        CommonBigInteger unscaledVal2 = unscaledVal;
        int scale2 = scale;
        CommonBigInteger commonBigInteger = unscaledVal2;
        Intrinsics.checkNotNull((Object)commonBigInteger);
        long compactVal = CommonBigDecimal.Companion.compactValFor(commonBigInteger);
        int mcp = mc.getPrecision();
        int prec = 0;
        if (mcp > 0) {
            int drop;
            int mode = mc.getRoundingMode().getValue();
            if (compactVal == Long.MIN_VALUE) {
                prec = CommonBigDecimal.Companion.bigDigitLength(unscaledVal2);
                drop = prec - mcp;
                while (drop > 0) {
                    scale2 = CommonBigDecimal.Companion.checkScaleNonZero((long)scale2 - (long)drop);
                    CommonBigInteger commonBigInteger2 = unscaledVal2;
                    Intrinsics.checkNotNull((Object)commonBigInteger2);
                    unscaledVal2 = CommonBigDecimal.Companion.divideAndRoundByTenPow(commonBigInteger2, drop, mode);
                    compactVal = CommonBigDecimal.Companion.compactValFor(unscaledVal2);
                    if (compactVal != Long.MIN_VALUE) break;
                    prec = CommonBigDecimal.Companion.bigDigitLength(unscaledVal2);
                    drop = prec - mcp;
                }
            }
            if (compactVal != Long.MIN_VALUE) {
                prec = Companion.longDigitLength$macrofocus_common(compactVal);
                drop = prec - mcp;
                while (drop > 0) {
                    scale2 = CommonBigDecimal.Companion.checkScaleNonZero((long)scale2 - (long)drop);
                    compactVal = CommonBigDecimal.Companion.divideAndRound(compactVal, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], mode);
                    prec = Companion.longDigitLength$macrofocus_common(compactVal);
                    drop = prec - mcp;
                }
                unscaledVal2 = null;
            }
        }
        this._intVal = unscaledVal2;
        this._intCompact = compactVal;
        this._scale = scale2;
        this._precision = prec;
    }

    public CommonBigDecimal(int val) {
        this._intCompact = val;
        this._scale = 0;
        this._intVal = null;
    }

    public CommonBigDecimal(int val, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        int mcp = mc.getPrecision();
        long compactVal = val;
        int scl = 0;
        int prec = 0;
        if (mcp > 0) {
            prec = Companion.longDigitLength$macrofocus_common(compactVal);
            int drop = prec - mcp;
            while (drop > 0) {
                scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                compactVal = CommonBigDecimal.Companion.divideAndRound(compactVal, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                prec = Companion.longDigitLength$macrofocus_common(compactVal);
                drop = prec - mcp;
            }
        }
        this._intVal = null;
        this._intCompact = compactVal;
        this._scale = scl;
        this._precision = prec;
    }

    public CommonBigDecimal(long val) {
        this._intCompact = val;
        this._intVal = val == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        this._scale = 0;
    }

    public CommonBigDecimal(long val, @NotNull MathContext mc) {
        CommonBigInteger rb;
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        long val2 = val;
        int mcp = mc.getPrecision();
        int mode = mc.getRoundingMode().getValue();
        int prec = 0;
        int scl = 0;
        CommonBigInteger commonBigInteger = rb = val2 == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        if (mcp > 0) {
            int drop;
            if (val2 == Long.MIN_VALUE) {
                prec = 19;
                drop = prec - mcp;
                while (drop > 0) {
                    scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    CommonBigInteger commonBigInteger2 = rb;
                    Intrinsics.checkNotNull((Object)commonBigInteger2);
                    rb = CommonBigDecimal.Companion.divideAndRoundByTenPow(commonBigInteger2, drop, mode);
                    val2 = CommonBigDecimal.Companion.compactValFor(rb);
                    if (val2 != Long.MIN_VALUE) break;
                    prec = CommonBigDecimal.Companion.bigDigitLength(rb);
                    drop = prec - mcp;
                }
            }
            if (val2 != Long.MIN_VALUE) {
                prec = Companion.longDigitLength$macrofocus_common(val2);
                drop = prec - mcp;
                while (drop > 0) {
                    scl = CommonBigDecimal.Companion.checkScaleNonZero((long)scl - (long)drop);
                    val2 = CommonBigDecimal.Companion.divideAndRound(val2, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                    prec = Companion.longDigitLength$macrofocus_common(val2);
                    drop = prec - mcp;
                }
                rb = null;
            }
        }
        this._intVal = rb;
        this._intCompact = val2;
        this._scale = scl;
        this._precision = prec;
    }

    @Override
    @NotNull
    public CommonBigDecimal plus(@Nullable BigDecimal augend) {
        CommonBigDecimal commonBigDecimal;
        BigDecimal bigDecimal = augend;
        Intrinsics.checkNotNull((Object)bigDecimal);
        BigDecimal $this$castTo$iv = bigDecimal;
        boolean $i$f$castTo = false;
        BigDecimal bigDecimal2 = $this$castTo$iv;
        if (bigDecimal2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.math.big.CommonBigDecimal");
        }
        CommonBigDecimal augend2 = (CommonBigDecimal)bigDecimal2;
        if (this._intCompact != Long.MIN_VALUE) {
            if (augend2._intCompact != Long.MIN_VALUE) {
                commonBigDecimal = CommonBigDecimal.Companion.sum(this._intCompact, this._scale, augend2._intCompact, augend2._scale);
            } else {
                CommonBigInteger commonBigInteger = augend2._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                commonBigDecimal = CommonBigDecimal.Companion.sum(this._intCompact, this._scale, commonBigInteger, augend2._scale);
            }
        } else if (augend2._intCompact != Long.MIN_VALUE) {
            long l = augend2._intCompact;
            int n = augend2._scale;
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.sum(l, n, commonBigInteger, this._scale);
        } else {
            commonBigDecimal = CommonBigDecimal.Companion.sum(this._intVal, this._scale, augend2._intVal, augend2._scale);
        }
        return commonBigDecimal;
    }

    @Override
    @NotNull
    public CommonBigDecimal plus(@Nullable BigDecimal augend, @NotNull MathContext mc) {
        boolean augendIsZero;
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        CommonBigDecimal augend2 = null;
        BigDecimal bigDecimal = augend;
        Intrinsics.checkNotNull((Object)bigDecimal);
        BigDecimal $this$castTo$iv = bigDecimal;
        boolean $i$f$castTo = false;
        BigDecimal bigDecimal2 = $this$castTo$iv;
        if (bigDecimal2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.math.big.CommonBigDecimal");
        }
        augend2 = (CommonBigDecimal)bigDecimal2;
        if (mc.getPrecision() == 0) {
            return this.plus(augend2);
        }
        CommonBigDecimal lhs = null;
        lhs = this;
        CommonBigDecimal $this$plus_u24lambda_u240 = this;
        boolean bl = false;
        boolean lhsIsZero = lhs.getSignum() == 0;
        boolean bl2 = augendIsZero = augend2.getSignum() == 0;
        if (lhsIsZero || augendIsZero) {
            int scaleDiff;
            CommonBigDecimal result;
            int preferredScale = Math.max(lhs.getScale(), augend2.getScale());
            CommonBigDecimal commonBigDecimal = result = lhsIsZero ? CommonBigDecimal.Companion.doRound(augend2, mc) : CommonBigDecimal.Companion.doRound(lhs, mc);
            if (lhsIsZero && augendIsZero) {
                return Companion.zeroValueOf$macrofocus_common(preferredScale);
            }
            CommonBigDecimal commonBigDecimal2 = result;
            Intrinsics.checkNotNull((Object)commonBigDecimal2);
            if (commonBigDecimal2.getScale() == preferredScale) {
                return result;
            }
            if (result.getScale() > preferredScale) {
                return CommonBigDecimal.Companion.stripZerosToMatchScale(result._intVal, result._intCompact, result._scale, preferredScale);
            }
            int precisionDiff = mc.getPrecision() - result.getPrecision();
            return precisionDiff >= (scaleDiff = preferredScale - result.getScale()) ? result.setScale(preferredScale) : result.setScale(result.getScale() + precisionDiff);
        }
        long padding = (long)lhs._scale - (long)augend2._scale;
        if (padding != 0L) {
            CommonBigDecimal[] arg = this.preAlign(lhs, augend2, padding, mc);
            CommonBigDecimal.Companion.matchScale(arg);
            lhs = arg[0];
            augend2 = arg[1];
        }
        return CommonBigDecimal.Companion.doRound(lhs.inflated().plus(augend2.inflated()), lhs._scale, mc);
    }

    private final CommonBigDecimal[] preAlign(CommonBigDecimal lhs, CommonBigDecimal augend, long padding, MathContext mc) {
        if (!(padding != 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CommonBigDecimal big = null;
        CommonBigDecimal small = null;
        if (padding < 0L) {
            big = lhs;
            small = augend;
        } else {
            big = augend;
            small = lhs;
        }
        long estResultUlpScale = (long)big._scale - (long)big.getPrecision() + (long)mc.getPrecision();
        long smallHighDigitPos = (long)small._scale - (long)small.getPrecision() + 1L;
        if (smallHighDigitPos > (long)(big._scale + 2) && smallHighDigitPos > estResultUlpScale + (long)2) {
            small = Companion.of((long)small.getSignum(), this.checkScale(Math.max((long)big._scale, estResultUlpScale) + (long)3));
        }
        CommonBigDecimal[] commonBigDecimalArray = new CommonBigDecimal[]{big, small};
        return commonBigDecimalArray;
    }

    @Override
    @NotNull
    public CommonBigDecimal minus(@NotNull BigDecimal subtrahend) {
        CommonBigDecimal commonBigDecimal;
        Intrinsics.checkNotNullParameter((Object)subtrahend, (String)"subtrahend");
        BigDecimal $this$castTo$iv = subtrahend;
        boolean $i$f$castTo = false;
        CommonBigDecimal subtrahend2 = (CommonBigDecimal)$this$castTo$iv;
        if (this._intCompact != Long.MIN_VALUE) {
            if (subtrahend2._intCompact != Long.MIN_VALUE) {
                commonBigDecimal = CommonBigDecimal.Companion.sum(this._intCompact, this._scale, -subtrahend2._intCompact, subtrahend2._scale);
            } else {
                CommonBigInteger commonBigInteger = subtrahend2._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                commonBigDecimal = CommonBigDecimal.Companion.sum(this._intCompact, this._scale, commonBigInteger.unaryMinus(), subtrahend2._scale);
            }
        } else if (subtrahend2._intCompact != Long.MIN_VALUE) {
            long l = -subtrahend2._intCompact;
            int n = subtrahend2._scale;
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.sum(l, n, commonBigInteger, this._scale);
        } else {
            CommonBigInteger commonBigInteger = subtrahend2._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.sum(this._intVal, this._scale, commonBigInteger.unaryMinus(), subtrahend2._scale);
        }
        return commonBigDecimal;
    }

    @Override
    @NotNull
    public CommonBigDecimal minus(@NotNull BigDecimal subtrahend, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)subtrahend, (String)"subtrahend");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        BigDecimal $this$castTo$iv = subtrahend;
        boolean $i$f$castTo = false;
        CommonBigDecimal subtrahend2 = (CommonBigDecimal)$this$castTo$iv;
        return mc.getPrecision() == 0 ? this.minus(subtrahend2) : this.plus(subtrahend2.unaryMinus(), mc);
    }

    @Override
    @NotNull
    public CommonBigDecimal times(@Nullable BigDecimal multiplicand) {
        CommonBigDecimal commonBigDecimal;
        BigDecimal bigDecimal = multiplicand;
        Intrinsics.checkNotNull((Object)bigDecimal);
        BigDecimal $this$castTo$iv = bigDecimal;
        boolean $i$f$castTo = false;
        BigDecimal bigDecimal2 = $this$castTo$iv;
        if (bigDecimal2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.macrofocus.common.math.big.CommonBigDecimal");
        }
        CommonBigDecimal multiplicand2 = (CommonBigDecimal)bigDecimal2;
        int productScale = this.checkScale((long)this._scale + (long)multiplicand2._scale);
        if (this._intCompact != Long.MIN_VALUE) {
            commonBigDecimal = multiplicand2._intCompact != Long.MIN_VALUE ? CommonBigDecimal.Companion.multiply(this._intCompact, multiplicand2._intCompact, productScale) : CommonBigDecimal.Companion.multiply(this._intCompact, multiplicand2._intVal, productScale);
        } else if (multiplicand2._intCompact != Long.MIN_VALUE) {
            commonBigDecimal = CommonBigDecimal.Companion.multiply(multiplicand2._intCompact, this._intVal, productScale);
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.multiply(commonBigInteger, multiplicand2._intVal, productScale);
        }
        return commonBigDecimal;
    }

    @Override
    @NotNull
    public CommonBigDecimal times(@NotNull BigDecimal multiplicand, @NotNull MathContext mc) {
        CommonBigDecimal commonBigDecimal;
        Intrinsics.checkNotNullParameter((Object)multiplicand, (String)"multiplicand");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        BigDecimal $this$castTo$iv = multiplicand;
        boolean $i$f$castTo = false;
        CommonBigDecimal multiplicand2 = (CommonBigDecimal)$this$castTo$iv;
        if (mc.getPrecision() == 0) {
            return this.times(multiplicand2);
        }
        int productScale = this.checkScale((long)this._scale + (long)multiplicand2._scale);
        if (this._intCompact != Long.MIN_VALUE) {
            commonBigDecimal = multiplicand2._intCompact != Long.MIN_VALUE ? CommonBigDecimal.Companion.multiplyAndRound(this._intCompact, multiplicand2._intCompact, productScale, mc) : CommonBigDecimal.Companion.multiplyAndRound(this._intCompact, multiplicand2._intVal, productScale, mc);
        } else if (multiplicand2._intCompact != Long.MIN_VALUE) {
            commonBigDecimal = CommonBigDecimal.Companion.multiplyAndRound(multiplicand2._intCompact, this._intVal, productScale, mc);
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.multiplyAndRound(commonBigInteger, multiplicand2._intVal, productScale, mc);
        }
        return commonBigDecimal;
    }

    @Deprecated(message="The method {@link #div(CommonBigDecimal, int, RoundingMode)}\n      should be used in preference to this legacy method.\n     \n      ")
    private final CommonBigDecimal div(CommonBigDecimal divisor, int scale, int roundingMode) {
        if (roundingMode < RoundingMode.UP.getValue() || roundingMode > RoundingMode.UNNECESSARY.getValue()) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        return this._intCompact != Long.MIN_VALUE ? (divisor._intCompact != Long.MIN_VALUE ? CommonBigDecimal.Companion.divide(this._intCompact, this._scale, divisor._intCompact, divisor._scale, scale, roundingMode) : CommonBigDecimal.Companion.divide(this._intCompact, this._scale, divisor._intVal, divisor._scale, scale, roundingMode)) : (divisor._intCompact != Long.MIN_VALUE ? CommonBigDecimal.Companion.divide(this._intVal, this._scale, divisor._intCompact, divisor._scale, scale, roundingMode) : CommonBigDecimal.Companion.divide(this._intVal, this._scale, divisor._intVal, divisor._scale, scale, roundingMode));
    }

    @Deprecated(message="The method {@link #div(CommonBigDecimal, RoundingMode)}\n      should be used in preference to this legacy method.\n     \n      ")
    private final CommonBigDecimal div(CommonBigDecimal divisor, int roundingMode) {
        return this.div(divisor, this._scale, roundingMode);
    }

    @Override
    @NotNull
    public CommonBigDecimal div(@NotNull BigDecimal divisor) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        BigDecimal $this$castTo$iv = divisor;
        boolean $i$f$castTo = false;
        CommonBigDecimal divisor2 = (CommonBigDecimal)$this$castTo$iv;
        if (divisor2.getSignum() == 0) {
            if (this.getSignum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int preferredScale = CommonBigDecimal.Companion.saturateLong((long)this._scale - (long)divisor2._scale);
        if (this.getSignum() == 0) {
            return Companion.zeroValueOf$macrofocus_common(preferredScale);
        }
        MathContext mc = new MathContext((int)Math.min((long)this.getPrecision() + (long)Math.ceil(10.0 * (double)divisor2.getPrecision() / 3.0), Integer.MAX_VALUE), RoundingMode.UNNECESSARY);
        CommonBigDecimal quotient = null;
        try {
            quotient = this.div((BigDecimal)divisor2, mc);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        CommonBigDecimal commonBigDecimal = quotient;
        Intrinsics.checkNotNull((Object)commonBigDecimal);
        int quotientScale = commonBigDecimal.getScale();
        return preferredScale > quotientScale ? quotient.setScale(preferredScale, RoundingMode.UNNECESSARY.getValue()) : quotient;
    }

    @Override
    @Nullable
    public CommonBigDecimal div(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        BigDecimal $this$castTo$iv = divisor;
        boolean $i$f$castTo = false;
        CommonBigDecimal divisor2 = (CommonBigDecimal)$this$castTo$iv;
        int mcp = mc.getPrecision();
        if (mcp == 0) {
            return this.div(divisor2);
        }
        CommonBigDecimal dividend = this;
        long preferredScale = (long)dividend._scale - (long)divisor2._scale;
        if (divisor2.getSignum() == 0) {
            if (dividend.getSignum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (dividend.getSignum() == 0) {
            return Companion.zeroValueOf$macrofocus_common(CommonBigDecimal.Companion.saturateLong(preferredScale));
        }
        int xscale = dividend.getPrecision();
        int yscale = divisor2.getPrecision();
        return dividend._intCompact != Long.MIN_VALUE ? (divisor2._intCompact != Long.MIN_VALUE ? CommonBigDecimal.Companion.divide(dividend._intCompact, xscale, divisor2._intCompact, yscale, preferredScale, mc) : CommonBigDecimal.Companion.divide(dividend._intCompact, xscale, divisor2._intVal, yscale, preferredScale, mc)) : (divisor2._intCompact != Long.MIN_VALUE ? CommonBigDecimal.Companion.divide(dividend._intVal, xscale, divisor2._intCompact, yscale, preferredScale, mc) : CommonBigDecimal.Companion.divide(dividend._intVal, xscale, divisor2._intVal, yscale, preferredScale, mc));
    }

    @Override
    @NotNull
    public CommonBigDecimal divideToIntegralValue(@NotNull BigDecimal divisor) {
        CommonBigDecimal quotient;
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        BigDecimal $this$castTo$iv = divisor;
        boolean $i$f$castTo = false;
        CommonBigDecimal divisor2 = (CommonBigDecimal)$this$castTo$iv;
        int preferredScale = CommonBigDecimal.Companion.saturateLong((long)this._scale - (long)divisor2._scale);
        if (this.compareMagnitude(divisor2) < 0) {
            return Companion.zeroValueOf$macrofocus_common(preferredScale);
        }
        if (this.getSignum() == 0 && divisor2.getSignum() != 0) {
            return this.setScale(preferredScale, RoundingMode.UNNECESSARY.getValue());
        }
        int maxDigits = (int)Math.min((long)this.getPrecision() + (long)Math.ceil(10.0 * (double)divisor2.getPrecision() / 3.0) + Math.abs((long)this.getScale() - (long)divisor2.getScale()) + (long)2, Integer.MAX_VALUE);
        CommonBigDecimal commonBigDecimal = quotient = this.div((BigDecimal)divisor2, new MathContext(maxDigits, RoundingMode.DOWN));
        Intrinsics.checkNotNull((Object)commonBigDecimal);
        if (commonBigDecimal._scale > 0) {
            quotient = quotient.setScale(0, RoundingMode.DOWN);
            quotient = CommonBigDecimal.Companion.stripZerosToMatchScale(quotient._intVal, quotient._intCompact, quotient._scale, preferredScale);
        }
        if (quotient._scale < preferredScale) {
            quotient = quotient.setScale(preferredScale, RoundingMode.UNNECESSARY.getValue());
        }
        return quotient;
    }

    @Override
    @NotNull
    public CommonBigDecimal divideToIntegralValue(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        CommonBigDecimal result;
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        BigDecimal $this$castTo$iv = divisor;
        boolean $i$f$castTo = false;
        CommonBigDecimal divisor2 = (CommonBigDecimal)$this$castTo$iv;
        if (mc.getPrecision() == 0 || this.compareMagnitude(divisor2) < 0) {
            return this.divideToIntegralValue(divisor2);
        }
        int preferredScale = CommonBigDecimal.Companion.saturateLong((long)this._scale - (long)divisor2._scale);
        CommonBigDecimal commonBigDecimal = result = this.div((BigDecimal)divisor2, new MathContext(mc.getPrecision(), RoundingMode.DOWN));
        Intrinsics.checkNotNull((Object)commonBigDecimal);
        if (commonBigDecimal.getScale() < 0) {
            CommonBigDecimal product = result.times(divisor2);
            if (this.minus(product).compareMagnitude(divisor2) >= 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (result.getScale() > 0) {
            result = result.setScale(0, RoundingMode.DOWN);
        }
        int precisionDiff = 0;
        if (preferredScale > result.getScale() && (precisionDiff = mc.getPrecision() - result.getPrecision()) > 0) {
            return result.setScale(result.getScale() + Math.min(precisionDiff, preferredScale - result._scale));
        }
        return CommonBigDecimal.Companion.stripZerosToMatchScale(result._intVal, result._intCompact, result._scale, preferredScale);
    }

    @Override
    @NotNull
    public CommonBigDecimal rem(@NotNull BigDecimal divisor) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        Pair<CommonBigDecimal, CommonBigDecimal> divrem = this.divideAndRemainder(divisor);
        return (CommonBigDecimal)divrem.getSecond();
    }

    @Override
    @NotNull
    public CommonBigDecimal rem(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Pair<CommonBigDecimal, CommonBigDecimal> divrem = this.divideAndRemainder(divisor, mc);
        return (CommonBigDecimal)divrem.getSecond();
    }

    @NotNull
    public Pair<CommonBigDecimal, CommonBigDecimal> divideAndRemainder(@NotNull BigDecimal divisor) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        CommonBigDecimal temp = this.divideToIntegralValue(divisor);
        return new Pair((Object)temp, (Object)temp.times(divisor));
    }

    @NotNull
    public Pair<CommonBigDecimal, CommonBigDecimal> divideAndRemainder(@NotNull BigDecimal divisor, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        BigDecimal $this$castTo$iv = divisor;
        boolean $i$f$castTo = false;
        CommonBigDecimal divisor2 = (CommonBigDecimal)$this$castTo$iv;
        if (mc.getPrecision() == 0) {
            return this.divideAndRemainder(divisor2);
        }
        CommonBigDecimal lhs = this;
        CommonBigDecimal temp = lhs.divideToIntegralValue(divisor2, mc);
        return new Pair((Object)temp, (Object)lhs.minus(temp.times(divisor2)));
    }

    @Override
    @NotNull
    public CommonBigDecimal sqrt(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        int signum = this.getSignum();
        if (signum == 1) {
            int preferredScale = this.getScale() / 2;
            CommonBigDecimal zeroWithFinalPreferredScale = Companion.of(0L, preferredScale);
            CommonBigDecimal stripped = this.stripTrailingZeros();
            int strippedScale = stripped.getScale();
            if (stripped.isPowerOfTen() && strippedScale % 2 == 0) {
                CommonBigDecimal result = Companion.of(1L, strippedScale / 2);
                if (result.getScale() != preferredScale) {
                    result = result.plus(zeroWithFinalPreferredScale, mc);
                }
                return result;
            }
            int scale = stripped.getScale() - stripped.getPrecision() + 1;
            int scaleAdjust = scale % 2 == 0 ? scale : scale - 1;
            CommonBigDecimal working = stripped.scaleByPowerOfTen(scaleAdjust);
            if (!(ONE_TENTH.compareTo(working) <= 0 && working.compareTo(TEN) < 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            CommonBigDecimal guess = new CommonBigDecimal(Math.sqrt(working.toDouble()), null, 2, null);
            int guessPrecision = 15;
            int originalPrecision = mc.getPrecision();
            int targetPrecision = 0;
            targetPrecision = originalPrecision == 0 ? stripped.getPrecision() / 2 + 1 : originalPrecision;
            CommonBigDecimal approx = guess;
            int workingPrecision = working.getPrecision();
            do {
                int tmpPrecision = Math.max(Math.max(guessPrecision, targetPrecision + 2), workingPrecision);
                MathContext mcTmp = new MathContext(tmpPrecision, RoundingMode.HALF_EVEN);
                approx = ONE_HALF.times(approx.plus(working.div((BigDecimal)approx, mcTmp), mcTmp));
            } while ((guessPrecision *= 2) < targetPrecision + 2);
            CommonBigDecimal result = null;
            RoundingMode targetRm = mc.getRoundingMode();
            if (targetRm == RoundingMode.UNNECESSARY || originalPrecision == 0) {
                RoundingMode tmpRm = targetRm == RoundingMode.UNNECESSARY ? RoundingMode.DOWN : targetRm;
                MathContext mcTmp = new MathContext(targetPrecision, tmpRm);
                CommonBigDecimal commonBigDecimal = result = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mcTmp);
                Intrinsics.checkNotNull((Object)commonBigDecimal);
                if (this.minus(commonBigDecimal.times(result)).compareTo(ZERO) != 0) {
                    throw new ArithmeticException("Computed square root not exact.");
                }
            } else {
                result = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mc);
            }
            CommonBigDecimal commonBigDecimal = result;
            Intrinsics.checkNotNull((Object)commonBigDecimal);
            if (commonBigDecimal.getScale() != preferredScale) {
                result = result.stripTrailingZeros().plus(zeroWithFinalPreferredScale, new MathContext(originalPrecision, RoundingMode.UNNECESSARY));
            }
            if (!this.squareRootResultAssertions(result, mc)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return result;
        }
        switch (signum) {
            case -1: {
                throw new ArithmeticException("Attempted square root of negative CommonBigDecimal");
            }
            case 0: {
                return Companion.of(0L, this.getScale() / 2);
            }
        }
        throw new AssertionError((Object)"Bad value from _signum");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean squareRootResultAssertions(CommonBigDecimal result, MathContext mc) {
        if (result.getSignum() == 0) {
            return this.squareRootZeroResultAssertions(result, mc);
        }
        RoundingMode rm = mc.getRoundingMode();
        CommonBigDecimal ulp = result.ulp();
        CommonBigDecimal neighborUp = result.plus(ulp);
        if (this.isPowerOfTen()) {
            ulp = ulp.div(TEN);
        }
        CommonBigDecimal neighborDown = result.minus(ulp);
        if (result.getSignum() != 1) return false;
        if (this.getSignum() != 1) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[rm.ordinal()]) {
            case 1: 
            case 2: {
                if (result.times(result).compareTo(this) > 0) return false;
                if (neighborUp.times(neighborUp).compareTo(this) <= 0) return false;
                return true;
            }
            case 3: 
            case 4: {
                if (result.times(result).compareTo(this) < 0) return false;
                if (neighborDown.times(neighborDown).compareTo(this) >= 0) return false;
                return true;
            }
            case 5: 
            case 6: 
            case 7: {
                boolean bl;
                CommonBigDecimal err = result.times(result).minus(this).getAbsoluteValue();
                CommonBigDecimal errUp = neighborUp.times(neighborUp).minus(this);
                CommonBigDecimal errDown = this.minus(neighborDown.times(neighborDown));
                int errCompErrup = err.compareTo(errUp);
                int errCompErrdown = err.compareTo(errDown);
                if (errUp.getSignum() != 1) return false;
                if (errDown.getSignum() != 1) return false;
                if (errCompErrup > 0) return false;
                if (errCompErrdown > 0) return false;
                if (errCompErrup == 0) {
                    if (errCompErrdown >= 0) return false;
                    bl = true;
                } else {
                    bl = true;
                }
                if (!bl) return false;
                if (errCompErrdown != 0) return true;
                if (errCompErrup >= 0) return false;
                return true;
            }
        }
        return true;
    }

    private final boolean squareRootZeroResultAssertions(CommonBigDecimal result, MathContext mc) {
        return this.compareTo(ZERO) == 0;
    }

    @Override
    @NotNull
    public CommonBigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int newScale = this.checkScale((long)this._scale * (long)n);
        return new CommonBigDecimal(this.inflated().pow(n), newScale);
    }

    @Override
    @Nullable
    public CommonBigDecimal pow(int n, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        if (mc.getPrecision() == 0) {
            return this.pow(n);
        }
        if (n < -999999999 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n == 0) {
            return ONE;
        }
        CommonBigDecimal lhs = this;
        MathContext workmc = mc;
        int mag = Math.abs(n);
        if (mc.getPrecision() > 0) {
            int elength = Companion.longDigitLength$macrofocus_common(mag);
            if (elength > mc.getPrecision()) {
                throw new ArithmeticException("Invalid operation");
            }
            workmc = new MathContext(mc.getPrecision() + elength + 1, mc.getRoundingMode());
        }
        CommonBigDecimal acc = ONE;
        boolean seenbit = false;
        int i = 1;
        while (true) {
            if ((mag += mag) < 0) {
                seenbit = true;
                acc = acc.times(lhs, workmc);
            }
            if (i == 31) break;
            if (seenbit) {
                acc = acc.times(acc, workmc);
            }
            ++i;
        }
        if (n < 0) {
            CommonBigDecimal commonBigDecimal = ONE.div((BigDecimal)acc, workmc);
            Intrinsics.checkNotNull((Object)commonBigDecimal);
            acc = commonBigDecimal;
        }
        return CommonBigDecimal.Companion.doRound(acc, mc);
    }

    @Override
    @NotNull
    public CommonBigDecimal getAbsoluteValue() {
        return this.getSignum() < 0 ? this.unaryMinus() : this;
    }

    @Override
    @Nullable
    public CommonBigDecimal absoluteValue(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        return this.getSignum() < 0 ? this.unaryMinus(mc) : this.unaryPlus(mc);
    }

    @Override
    @NotNull
    public CommonBigDecimal unaryMinus() {
        CommonBigDecimal commonBigDecimal;
        if (this._intCompact == Long.MIN_VALUE) {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = new CommonBigDecimal(commonBigInteger.unaryMinus(), Long.MIN_VALUE, this._scale, this._precision);
        } else {
            commonBigDecimal = Companion.of(-this._intCompact, this._scale, this._precision);
        }
        return commonBigDecimal;
    }

    @Override
    @Nullable
    public CommonBigDecimal unaryMinus(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        return this.unaryMinus().unaryPlus(mc);
    }

    @Override
    @NotNull
    public CommonBigDecimal unaryPlus() {
        return this;
    }

    @Override
    @Nullable
    public CommonBigDecimal unaryPlus(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        return mc.getPrecision() == 0 ? this : CommonBigDecimal.Companion.doRound(this, mc);
    }

    @Override
    public int getSignum() {
        int n;
        if (this._intCompact != Long.MIN_VALUE) {
            n = MathKt.getSign((long)this._intCompact);
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            n = commonBigInteger.getSignum();
        }
        return n;
    }

    @Override
    public int getScale() {
        return this._scale;
    }

    @Override
    public int getPrecision() {
        int result = this._precision;
        if (result == 0) {
            long s = this._intCompact;
            if (s != Long.MIN_VALUE) {
                result = Companion.longDigitLength$macrofocus_common(s);
            } else {
                CommonBigInteger commonBigInteger = this._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                result = CommonBigDecimal.Companion.bigDigitLength(commonBigInteger);
            }
            this._precision = result;
        }
        return result;
    }

    @Override
    @NotNull
    public CommonBigInteger getUnscaledValue() {
        return this.inflated();
    }

    @Override
    @Nullable
    public CommonBigDecimal round(@NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        return this.unaryPlus(mc);
    }

    @Override
    @NotNull
    public CommonBigDecimal setScale(int newScale, @NotNull RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        return this.setScale(newScale, roundingMode.getValue());
    }

    @Override
    @Deprecated(message="The method {@link #setScale(int, RoundingMode)} should be used in preference to this legacy method.")
    @NotNull
    public CommonBigDecimal setScale(int newScale, int roundingMode) {
        CommonBigDecimal commonBigDecimal;
        if (roundingMode < RoundingMode.UP.getValue() || roundingMode > RoundingMode.UNNECESSARY.getValue()) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        int oldScale = this._scale;
        if (newScale == oldScale) {
            return this;
        }
        if (this.getSignum() == 0) {
            return Companion.zeroValueOf$macrofocus_common(newScale);
        }
        if (this._intCompact != Long.MIN_VALUE) {
            long rs = this._intCompact;
            if (newScale > oldScale) {
                int raise = this.checkScale((long)newScale - (long)oldScale);
                if ((rs = CommonBigDecimal.Companion.longMultiplyPowerTen(rs, raise)) != Long.MIN_VALUE) {
                    return Companion.of(rs, newScale);
                }
                CommonBigInteger rb = this.bigMultiplyPowerTen(raise);
                return new CommonBigDecimal(rb, Long.MIN_VALUE, newScale, this._precision > 0 ? this._precision + raise : 0);
            }
            int drop = this.checkScale((long)oldScale - (long)newScale);
            return drop < LONG_TEN_POWERS_TABLE.length ? CommonBigDecimal.Companion.divideAndRound(rs, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], newScale, roundingMode, newScale) : CommonBigDecimal.Companion.divideAndRound(this.inflated(), CommonBigDecimal.Companion.bigTenToThe(drop), newScale, roundingMode, newScale);
        }
        if (newScale > oldScale) {
            CommonBigInteger rb;
            int raise = this.checkScale((long)newScale - (long)oldScale);
            CommonBigInteger commonBigInteger = rb = CommonBigDecimal.Companion.bigMultiplyPowerTen(this._intVal, raise);
            Intrinsics.checkNotNull((Object)commonBigInteger);
            return new CommonBigDecimal(commonBigInteger, Long.MIN_VALUE, newScale, this._precision > 0 ? this._precision + raise : 0);
        }
        int drop = this.checkScale((long)oldScale - (long)newScale);
        if (drop < LONG_TEN_POWERS_TABLE.length) {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.divideAndRound(commonBigInteger, CommonBigDecimal.LONG_TEN_POWERS_TABLE[drop], newScale, roundingMode, newScale);
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.divideAndRound(commonBigInteger, CommonBigDecimal.Companion.bigTenToThe(drop), newScale, roundingMode, newScale);
        }
        return commonBigDecimal;
    }

    @Override
    @NotNull
    public CommonBigDecimal setScale(int newScale) {
        return this.setScale(newScale, RoundingMode.UNNECESSARY.getValue());
    }

    @Override
    @NotNull
    public CommonBigDecimal movePointLeft(int n) {
        int newScale = this.checkScale((long)this._scale + (long)n);
        CommonBigInteger commonBigInteger = this._intVal;
        Intrinsics.checkNotNull((Object)commonBigInteger);
        CommonBigDecimal num = new CommonBigDecimal(commonBigInteger, this._intCompact, newScale, 0);
        return num._scale < 0 ? num.setScale(0, RoundingMode.UNNECESSARY.getValue()) : num;
    }

    @Override
    @NotNull
    public CommonBigDecimal movePointRight(int n) {
        int newScale = this.checkScale((long)this._scale - (long)n);
        CommonBigInteger commonBigInteger = this._intVal;
        Intrinsics.checkNotNull((Object)commonBigInteger);
        CommonBigDecimal num = new CommonBigDecimal(commonBigInteger, this._intCompact, newScale, 0);
        return num._scale < 0 ? num.setScale(0, RoundingMode.UNNECESSARY.getValue()) : num;
    }

    @Override
    @NotNull
    public CommonBigDecimal scaleByPowerOfTen(int n) {
        return new CommonBigDecimal(this._intVal, this._intCompact, this.checkScale((long)this._scale - (long)n), this._precision);
    }

    @Override
    @NotNull
    public CommonBigDecimal stripTrailingZeros() {
        CommonBigDecimal commonBigDecimal;
        if (this._intCompact == 0L || this._intVal != null && this._intVal.getSignum() == 0) {
            commonBigDecimal = ZERO;
        } else if (this._intCompact != Long.MIN_VALUE) {
            commonBigDecimal = CommonBigDecimal.Companion.createAndStripZerosToMatchScale(this._intCompact, this._scale, Long.MIN_VALUE);
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            commonBigDecimal = CommonBigDecimal.Companion.createAndStripZerosToMatchScale(commonBigInteger, this._scale, Long.MIN_VALUE);
        }
        return commonBigDecimal;
    }

    @Override
    public int compareTo(@NotNull BigDecimal other) {
        int ysign;
        int xsign;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigDecimal $this$castTo$iv = other;
        boolean $i$f$castTo = false;
        CommonBigDecimal other2 = (CommonBigDecimal)$this$castTo$iv;
        if (this._scale == other2._scale) {
            long xs = this._intCompact;
            long ys = other2._intCompact;
            if (xs != Long.MIN_VALUE && ys != Long.MIN_VALUE) {
                return xs != ys ? (xs > ys ? 1 : -1) : 0;
            }
        }
        if ((xsign = this.getSignum()) != (ysign = other2.getSignum())) {
            return xsign > ysign ? 1 : -1;
        }
        if (xsign == 0) {
            return 0;
        }
        int cmp = this.compareMagnitude(other2);
        return xsign > 0 ? cmp : -cmp;
    }

    private final int compareMagnitude(CommonBigDecimal val) {
        int n;
        long xs;
        long ys;
        block17: {
            long sdiff;
            block20: {
                block18: {
                    block19: {
                        long yae;
                        ys = 0L;
                        ys = val._intCompact;
                        xs = 0L;
                        xs = this._intCompact;
                        if (xs == 0L) {
                            return ys == 0L ? 0 : -1;
                        }
                        if (ys == 0L) {
                            return 1;
                        }
                        sdiff = (long)this._scale - (long)val._scale;
                        if (sdiff == 0L) break block17;
                        long xae = (long)this.getPrecision() - (long)this._scale;
                        if (xae < (yae = (long)val.getPrecision() - (long)val._scale)) {
                            return -1;
                        }
                        if (xae > yae) {
                            return 1;
                        }
                        if (sdiff >= 0L) break block18;
                        if (sdiff <= Integer.MIN_VALUE) break block17;
                        if (xs == Long.MIN_VALUE) break block19;
                        CommonBigDecimal $this$compareMagnitude_u24lambda_u240 = this;
                        boolean bl = false;
                        xs = CommonBigDecimal.Companion.longMultiplyPowerTen(xs, (int)(-sdiff));
                        if (xs != Long.MIN_VALUE) break block17;
                    }
                    if (ys == Long.MIN_VALUE) {
                        CommonBigInteger rb = this.bigMultiplyPowerTen((int)(-sdiff));
                        CommonBigInteger commonBigInteger = val._intVal;
                        Intrinsics.checkNotNull((Object)commonBigInteger);
                        return rb.compareMagnitude$macrofocus_common(commonBigInteger);
                    }
                    break block17;
                }
                if (sdiff > Integer.MAX_VALUE) break block17;
                if (ys == Long.MIN_VALUE) break block20;
                CommonBigDecimal $this$compareMagnitude_u24lambda_u241 = this;
                boolean bl = false;
                ys = CommonBigDecimal.Companion.longMultiplyPowerTen(ys, (int)sdiff);
                if (ys != Long.MIN_VALUE) break block17;
            }
            if (xs == Long.MIN_VALUE) {
                CommonBigInteger rb = val.bigMultiplyPowerTen((int)sdiff);
                CommonBigInteger commonBigInteger = this._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                return commonBigInteger.compareMagnitude$macrofocus_common(rb);
            }
        }
        if (xs != Long.MIN_VALUE) {
            n = ys != Long.MIN_VALUE ? CommonBigDecimal.Companion.longCompareMagnitude(xs, ys) : -1;
        } else if (ys != Long.MIN_VALUE) {
            n = 1;
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            CommonBigInteger commonBigInteger2 = val._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger2);
            n = commonBigInteger.compareMagnitude$macrofocus_common(commonBigInteger2);
        }
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CommonBigDecimal)) {
            return false;
        }
        CommonBigDecimal xDec = (CommonBigDecimal)other;
        if (other == this) {
            return true;
        }
        if (this._scale != xDec._scale) {
            return false;
        }
        long s = this._intCompact;
        long xs = xDec._intCompact;
        if (s != Long.MIN_VALUE) {
            if (xs == Long.MIN_VALUE) {
                CommonBigInteger commonBigInteger = xDec._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                xs = CommonBigDecimal.Companion.compactValFor(commonBigInteger);
            }
            return xs == s;
        }
        if (xs != Long.MIN_VALUE) {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            return xs == CommonBigDecimal.Companion.compactValFor(commonBigInteger);
        }
        return Intrinsics.areEqual((Object)this.inflated(), (Object)xDec.inflated());
    }

    @Override
    @NotNull
    public BigDecimal min(@NotNull BigDecimal val) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        return this.compareTo(val) <= 0 ? (BigDecimal)this : val;
    }

    @Override
    @NotNull
    public BigDecimal max(@NotNull BigDecimal val) {
        Intrinsics.checkNotNullParameter((Object)val, (String)"val");
        return this.compareTo(val) >= 0 ? (BigDecimal)this : val;
    }

    public int hashCode() {
        int n;
        if (this._intCompact != Long.MIN_VALUE) {
            long val2 = this._intCompact < 0L ? -this._intCompact : this._intCompact;
            int temp = (int)((long)((int)(val2 >>> 32) * 31) + (val2 & 0xFFFFFFFFL));
            n = 31 * (this._intCompact < 0L ? -temp : temp) + this._scale;
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            n = 31 * commonBigInteger.hashCode() + this._scale;
        }
        return n;
    }

    @NotNull
    public String toString() {
        String sc = this._stringCache;
        if (sc == null) {
            this._stringCache = sc = this.layoutChars(true);
        }
        return sc;
    }

    @Override
    @NotNull
    public String toEngineeringString() {
        return this.layoutChars(false);
    }

    @Override
    @NotNull
    public String toPlainString() {
        if (this._scale == 0) {
            String string;
            if (this._intCompact != Long.MIN_VALUE) {
                string = String.valueOf(this._intCompact);
            } else {
                CommonBigInteger commonBigInteger = this._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                string = commonBigInteger.toString();
            }
            return string;
        }
        if (this._scale < 0) {
            if (this.getSignum() == 0) {
                return "0";
            }
            int trailingZeros = CommonBigDecimal.Companion.checkScaleNonZero(-((long)this._scale));
            StringBuilder buf = null;
            if (this._intCompact != Long.MIN_VALUE) {
                buf = new StringBuilder(20 + trailingZeros);
                v2 = buf.append(this._intCompact);
            } else {
                CommonBigInteger commonBigInteger = this._intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                String str = commonBigInteger.toString();
                buf = new StringBuilder(str.length() + trailingZeros);
                v2 = buf.append(str);
            }
            for (int i = 0; i < trailingZeros; ++i) {
                buf.append('0');
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        String str = null;
        if (this._intCompact != Long.MIN_VALUE) {
            str = String.valueOf(Math.abs(this._intCompact));
        } else {
            CommonBigInteger commonBigInteger = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            str = commonBigInteger.getAbsoluteValue().toString();
        }
        return this.getValueString(this.getSignum(), str, this._scale);
    }

    private final String getValueString(int signum, String intString, int scale) {
        StringBuilder buf = null;
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuilder(intString);
            Utils.insertChar(buf, insertionPoint, '.');
            if (signum < 0) {
                Utils.insertChar(buf, 0, '-');
            }
        } else {
            buf = new StringBuilder(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            int n = -insertionPoint;
            for (int i = 0; i < n; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public CommonBigInteger toBigInteger() {
        return this.setScale(0, RoundingMode.DOWN.getValue()).inflated();
    }

    @Override
    @NotNull
    public CommonBigInteger toBigIntegerExact() {
        return this.setScale(0, RoundingMode.UNNECESSARY.getValue()).inflated();
    }

    @Override
    public long toLong() {
        return this._intCompact != Long.MIN_VALUE && this._scale == 0 ? this._intCompact : this.toBigInteger().toLong();
    }

    @Override
    public long toLongExact() {
        if (this._intCompact != Long.MIN_VALUE && this._scale == 0) {
            return this._intCompact;
        }
        if (this.getPrecision() - this._scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.getSignum() == 0) {
            return 0L;
        }
        if (this.getPrecision() - this._scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        CommonBigDecimal num = this.setScale(0, RoundingMode.UNNECESSARY.getValue());
        if (num.getPrecision() >= 19) {
            LongOverflow.INSTANCE.check(num);
        }
        return num.inflated().toLong();
    }

    @Override
    public int toInt() {
        return this._intCompact != Long.MIN_VALUE && this._scale == 0 ? (int)this._intCompact : this.toBigInteger().toInt();
    }

    @Override
    public byte toByte() {
        return (byte)this.toInt();
    }

    @Override
    public char toChar() {
        return (char)this.toInt();
    }

    @Override
    public short toShort() {
        return (short)this.toInt();
    }

    @Override
    public int toIntExact() {
        long num = this.toLongExact();
        if ((long)((int)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (int)num;
    }

    @Override
    public short toShortExact() {
        long num = this.toLongExact();
        if ((long)((short)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (short)num;
    }

    @Override
    public byte toByteExact() {
        long num = this.toLongExact();
        if ((long)((byte)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)num;
    }

    @Override
    public float toFloat() {
        if (this._intCompact != Long.MIN_VALUE) {
            if (this._scale == 0) {
                return this._intCompact;
            }
            if (Math.abs(this._intCompact) < 0x400000L) {
                if (this._scale > 0 && this._scale < FLOAT_10_POW.length) {
                    return (float)this._intCompact / FLOAT_10_POW[this._scale];
                }
                if (this._scale < 0 && this._scale > -FLOAT_10_POW.length) {
                    return (float)this._intCompact * FLOAT_10_POW[-this._scale];
                }
            }
        }
        return Float.parseFloat(this.toString());
    }

    @Override
    public double toDouble() {
        if (this._intCompact != Long.MIN_VALUE) {
            if (this._scale == 0) {
                return this._intCompact;
            }
            if (Math.abs(this._intCompact) < 0x10000000000000L) {
                if (this._scale > 0 && this._scale < DOUBLE_10_POW.length) {
                    return (double)this._intCompact / DOUBLE_10_POW[this._scale];
                }
                if (this._scale < 0 && this._scale > -DOUBLE_10_POW.length) {
                    return (double)this._intCompact * DOUBLE_10_POW[-this._scale];
                }
            }
        }
        return Double.parseDouble(this.toString());
    }

    @Override
    @NotNull
    public CommonBigDecimal ulp() {
        return Companion.of(1L, this.getScale(), 1);
    }

    private final String layoutChars(boolean sci) {
        StringBuilder buf;
        block23: {
            Object object;
            long adjusted;
            block25: {
                int sig;
                int coeffLen;
                int offset;
                char[] coeff;
                block26: {
                    block24: {
                        block22: {
                            if (this._scale == 0) {
                                String string;
                                if (this._intCompact != Long.MIN_VALUE) {
                                    string = String.valueOf(this._intCompact);
                                } else {
                                    CommonBigInteger commonBigInteger = this._intVal;
                                    Intrinsics.checkNotNull((Object)commonBigInteger);
                                    string = commonBigInteger.toString();
                                }
                                return string;
                            }
                            if (this._scale == 2 && this._intCompact >= 0L && this._intCompact < Integer.MAX_VALUE) {
                                int lowInt = (int)this._intCompact % 100;
                                int highInt = (int)this._intCompact / 100;
                                return highInt + "." + StringBuilderHelper.Companion.getDIGIT_TENS()[lowInt] + StringBuilderHelper.Companion.getDIGIT_ONES()[lowInt];
                            }
                            StringBuilderHelper sbHelper = new StringBuilderHelper(null, null, 3, null);
                            coeff = null;
                            offset = 0;
                            if (this._intCompact != Long.MIN_VALUE) {
                                offset = sbHelper.putIntCompact(Math.abs(this._intCompact));
                                coeff = sbHelper.getCompactCharArray();
                            } else {
                                offset = 0;
                                CommonBigInteger commonBigInteger = this._intVal;
                                Intrinsics.checkNotNull((Object)commonBigInteger);
                                coeff = Utils.toCharArray(commonBigInteger.getAbsoluteValue().toString());
                            }
                            buf = sbHelper.getStringBuilder();
                            if (this.getSignum() < 0) {
                                buf.append('-');
                            }
                            coeffLen = coeff.length - offset;
                            adjusted = -((long)this._scale) + (long)(coeffLen - 1);
                            if (this._scale < 0 || adjusted < -6L) break block22;
                            int pad = this._scale - coeffLen;
                            if (pad >= 0) {
                                buf.append('0');
                                buf.append('.');
                                while (pad > 0) {
                                    buf.append('0');
                                    --pad;
                                }
                                object = Utils.appendCharArray(buf, coeff, offset, coeffLen);
                            } else {
                                Utils.appendCharArray(buf, coeff, offset, -pad);
                                buf.append('.');
                                object = Utils.appendCharArray(buf, coeff, -pad + offset, this._scale);
                            }
                            break block23;
                        }
                        if (!sci) break block24;
                        buf.append(coeff[offset]);
                        if (coeffLen > 1) {
                            buf.append('.');
                            Utils.appendCharArray(buf, coeff, offset + 1, coeffLen - 1);
                        }
                        break block25;
                    }
                    sig = (int)(adjusted % (long)3);
                    if (sig < 0) {
                        sig += 3;
                    }
                    adjusted -= (long)sig;
                    ++sig;
                    if (this.getSignum() != 0) break block26;
                    switch (sig) {
                        case 1: {
                            buf.append('0');
                            break block25;
                        }
                        case 2: {
                            buf.append("0.00");
                            adjusted += (long)3;
                            break block25;
                        }
                        case 3: {
                            buf.append("0.0");
                            adjusted += (long)3;
                            break block25;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + sig));
                        }
                    }
                }
                if (sig >= coeffLen) {
                    Utils.appendCharArray(buf, coeff, offset, coeffLen);
                    for (int i = sig - coeffLen; 0 < i; --i) {
                        buf.append('0');
                    }
                } else {
                    Utils.appendCharArray(buf, coeff, offset, sig);
                    buf.append('.');
                    Utils.appendCharArray(buf, coeff, offset + sig, coeffLen - sig);
                }
            }
            if (adjusted != 0L) {
                buf.append('E');
                if (adjusted > 0L) {
                    buf.append('+');
                }
                buf.append(adjusted);
            }
            object = Unit.INSTANCE;
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final CommonBigInteger bigMultiplyPowerTen(int n) {
        CommonBigInteger commonBigInteger;
        if (n <= 0) {
            return this.inflated();
        }
        if (this._intCompact != Long.MIN_VALUE) {
            commonBigInteger = CommonBigDecimal.Companion.bigTenToThe(n).timesLong$macrofocus_common(this._intCompact);
        } else {
            CommonBigInteger commonBigInteger2 = this._intVal;
            Intrinsics.checkNotNull((Object)commonBigInteger2);
            commonBigInteger = commonBigInteger2.times(CommonBigDecimal.Companion.bigTenToThe(n));
        }
        return commonBigInteger;
    }

    private final CommonBigInteger inflated() {
        CommonBigInteger commonBigInteger = this._intVal;
        if (commonBigInteger == null) {
            commonBigInteger = CommonBigInteger.Companion.of(this._intCompact);
        }
        return commonBigInteger;
    }

    private final int checkScale(long val) {
        int asInt;
        block2: {
            block3: {
                asInt = (int)val;
                if ((long)asInt == val) break block2;
                asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                CommonBigInteger b = null;
                if (this._intCompact == 0L) break block2;
                CommonBigDecimal $this$checkScale_u24lambda_u240 = this;
                boolean bl = false;
                b = $this$checkScale_u24lambda_u240._intVal;
                if (b == null) break block3;
                CommonBigInteger commonBigInteger = b;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                if (commonBigInteger.getSignum() == 0) break block2;
            }
            throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
        }
        return asInt;
    }

    private final CommonBigDecimal audit() {
        if (this._intCompact == Long.MIN_VALUE) {
            if (this._intVal == null) {
                CommonBigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)"null _intVal");
            }
            if (this._precision > 0 && this._precision != CommonBigDecimal.Companion.bigDigitLength(this._intVal)) {
                CommonBigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)"_precision mismatch");
            }
        } else {
            long val;
            if (this._intVal != null && (val = this._intVal.toLong()) != this._intCompact) {
                CommonBigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)("Inconsistent state, _intCompact=" + this._intCompact + "\t _intVal=" + val));
            }
            if (this._precision > 0 && this._precision != Companion.longDigitLength$macrofocus_common(this._intCompact)) {
                CommonBigDecimal.Companion.print("audit", this);
                throw new AssertionError((Object)"_precision mismatch");
            }
        }
        return this;
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(long unscaledVal, int scale) {
        return Companion.of(unscaledVal, scale);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(long unscaledVal, int scale, int prec) {
        return Companion.of(unscaledVal, scale, prec);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(int val) {
        return Companion.of(val);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(long val) {
        return Companion.of(val);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(@NotNull CommonBigInteger intVal, int scale, int prec) {
        return Companion.of(intVal, scale, prec);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(double val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(float val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CommonBigDecimal of(@NotNull String val, @Nullable MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CommonBigDecimal of(@NotNull CommonBigInteger val, @Nullable MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(int val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @NotNull
    public static final CommonBigDecimal of(long val, @NotNull MathContext ctx) {
        return Companion.of(val, ctx);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CommonBigDecimal of(@NotNull String val) {
        return Companion.of(val);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final CommonBigDecimal of(@NotNull CommonBigInteger val) {
        return Companion.of(val);
    }

    static {
        Object object = new CommonBigDecimal[]{new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 0, 1), new CommonBigDecimal(CommonBigInteger.ONE, 1L, 0, 1), new CommonBigDecimal(CommonBigInteger.TWO, 2L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(3), 3L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(4), 4L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(5), 5L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(6), 6L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(7), 7L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(8), 8L, 0, 1), new CommonBigDecimal(CommonBigInteger.Companion.of(9), 9L, 0, 1), new CommonBigDecimal(CommonBigInteger.TEN, 10L, 0, 2)};
        ZERO_THROUGH_TEN = object;
        object = new CommonBigDecimal[]{ZERO_THROUGH_TEN[0], new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 1, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 2, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 3, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 4, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 5, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 6, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 7, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 8, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 9, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 10, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 11, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 12, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 13, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 14, 1), new CommonBigDecimal(CommonBigInteger.ZERO, 0L, 15, 1)};
        ZERO_SCALED_BY = object;
        ZERO = ZERO_THROUGH_TEN[0];
        ONE = ZERO_THROUGH_TEN[1];
        TWO = ZERO_THROUGH_TEN[2];
        TEN = ZERO_THROUGH_TEN[10];
        ONE_TENTH = Companion.of(1L, 1);
        ONE_HALF = Companion.of(5L, 1);
        PI = com.macrofocus.common.math.big.CommonBigDecimal$Companion.of$default(Companion, "3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648", null, 2, null);
        E = com.macrofocus.common.math.big.CommonBigDecimal$Companion.of$default(Companion, "2.718281828459045235360287471352662497757247093699959574966967627724076630353547594571382178525166427427466391932003059921817413596629043572900334295260595630738132328627943490763233829880753195251019011573834187930702154089149934884167509244761460668082264", null, 2, null);
        object = new double[23];
        object[0] = (CommonBigDecimal)1.0;
        object[1] = (CommonBigDecimal)10.0;
        object[2] = (CommonBigDecimal)100.0;
        object[3] = (CommonBigDecimal)1000.0;
        object[4] = (CommonBigDecimal)10000.0;
        object[5] = (CommonBigDecimal)100000.0;
        object[6] = (CommonBigDecimal)1000000.0;
        object[7] = (CommonBigDecimal)1.0E7;
        object[8] = (CommonBigDecimal)1.0E8;
        object[9] = (CommonBigDecimal)1.0E9;
        object[10] = (CommonBigDecimal)1.0E10;
        object[11] = (CommonBigDecimal)1.0E11;
        object[12] = (CommonBigDecimal)1.0E12;
        object[13] = (CommonBigDecimal)1.0E13;
        object[14] = (CommonBigDecimal)1.0E14;
        object[15] = (CommonBigDecimal)1.0E15;
        object[16] = (CommonBigDecimal)1.0E16;
        object[17] = (CommonBigDecimal)1.0E17;
        object[18] = (CommonBigDecimal)1.0E18;
        object[19] = (CommonBigDecimal)1.0E19;
        object[20] = (CommonBigDecimal)1.0E20;
        object[21] = (CommonBigDecimal)1.0E21;
        object[22] = (CommonBigDecimal)1.0E22;
        DOUBLE_10_POW = (double[])object;
        object = new float[11];
        object[0] = (CommonBigDecimal)1.0f;
        object[1] = (CommonBigDecimal)10.0f;
        object[2] = (CommonBigDecimal)100.0f;
        object[3] = (CommonBigDecimal)1000.0f;
        object[4] = (CommonBigDecimal)10000.0f;
        object[5] = (CommonBigDecimal)100000.0f;
        object[6] = (CommonBigDecimal)1000000.0f;
        object[7] = (CommonBigDecimal)1.0E7f;
        object[8] = (CommonBigDecimal)1.0E8f;
        object[9] = (CommonBigDecimal)1.0E9f;
        object[10] = (CommonBigDecimal)1.0E10f;
        FLOAT_10_POW = (float[])object;
        object = new long[19];
        object[0] = (CommonBigDecimal)1L;
        object[1] = (CommonBigDecimal)10L;
        object[2] = (CommonBigDecimal)100L;
        object[3] = (CommonBigDecimal)1000L;
        object[4] = (CommonBigDecimal)10000L;
        object[5] = (CommonBigDecimal)100000L;
        object[6] = (CommonBigDecimal)1000000L;
        object[7] = (CommonBigDecimal)10000000L;
        object[8] = (CommonBigDecimal)100000000L;
        object[9] = (CommonBigDecimal)1000000000L;
        object[10] = (CommonBigDecimal)10000000000L;
        object[11] = (CommonBigDecimal)100000000000L;
        object[12] = (CommonBigDecimal)1000000000000L;
        object[13] = (CommonBigDecimal)10000000000000L;
        object[14] = (CommonBigDecimal)100000000000000L;
        object[15] = (CommonBigDecimal)1000000000000000L;
        object[16] = (CommonBigDecimal)10000000000000000L;
        object[17] = (CommonBigDecimal)100000000000000000L;
        object[18] = (CommonBigDecimal)1000000000000000000L;
        LONG_TEN_POWERS_TABLE = (long[])object;
        object = new CommonBigInteger[]{CommonBigInteger.ONE, CommonBigInteger.Companion.of(10), CommonBigInteger.Companion.of(100), CommonBigInteger.Companion.of(1000), CommonBigInteger.Companion.of(10000), CommonBigInteger.Companion.of(100000), CommonBigInteger.Companion.of(1000000), CommonBigInteger.Companion.of(10000000), CommonBigInteger.Companion.of(100000000), CommonBigInteger.Companion.of(1000000000), CommonBigInteger.Companion.of(10000000000L), CommonBigInteger.Companion.of(100000000000L), CommonBigInteger.Companion.of(1000000000000L), CommonBigInteger.Companion.of(10000000000000L), CommonBigInteger.Companion.of(100000000000000L), CommonBigInteger.Companion.of(1000000000000000L), CommonBigInteger.Companion.of(10000000000000000L), CommonBigInteger.Companion.of(100000000000000000L), CommonBigInteger.Companion.of(1000000000000000000L)};
        BIG_TEN_POWERS_TABLE = object;
        BIG_TEN_POWERS_TABLE_INITLEN = BIG_TEN_POWERS_TABLE.length;
        BIG_TEN_POWERS_TABLE_MAX = 16 * BIG_TEN_POWERS_TABLE_INITLEN;
        object = new long[19];
        object[0] = (CommonBigDecimal)Long.MAX_VALUE;
        object[1] = (CommonBigDecimal)0xCCCCCCCCCCCCCCCL;
        object[2] = (CommonBigDecimal)92233720368547758L;
        object[3] = (CommonBigDecimal)9223372036854775L;
        object[4] = (CommonBigDecimal)922337203685477L;
        object[5] = (CommonBigDecimal)92233720368547L;
        object[6] = (CommonBigDecimal)9223372036854L;
        object[7] = (CommonBigDecimal)922337203685L;
        object[8] = (CommonBigDecimal)92233720368L;
        object[9] = (CommonBigDecimal)9223372036L;
        object[10] = (CommonBigDecimal)922337203L;
        object[11] = (CommonBigDecimal)92233720L;
        object[12] = (CommonBigDecimal)0x8CBCCCL;
        object[13] = (CommonBigDecimal)922337L;
        object[14] = (CommonBigDecimal)92233L;
        object[15] = (CommonBigDecimal)9223L;
        object[16] = (CommonBigDecimal)922L;
        object[17] = (CommonBigDecimal)92L;
        object[18] = (CommonBigDecimal)9L;
        THRESHOLDS_TABLE = (long[])object;
        object = new long[20][];
        long[] lArray = new long[]{0L, -8446744073709551616L};
        object[0] = lArray;
        lArray = new long[]{5L, 7766279631452241920L};
        object[1] = lArray;
        lArray = new long[]{54L, 3875820019684212736L};
        object[2] = lArray;
        lArray = new long[]{542L, 1864712049423024128L};
        object[3] = lArray;
        lArray = new long[]{5421L, 200376420520689664L};
        object[4] = lArray;
        lArray = new long[]{54210L, 2003764205206896640L};
        object[5] = lArray;
        lArray = new long[]{542101L, 1590897978359414784L};
        object[6] = lArray;
        lArray = new long[]{5421010L, -2537764290115403776L};
        object[7] = lArray;
        lArray = new long[]{54210108L, -6930898827444486144L};
        object[8] = lArray;
        lArray = new long[]{542101086L, 4477988020393345024L};
        object[9] = lArray;
        lArray = new long[]{5421010862L, 7886392056514347008L};
        object[10] = lArray;
        lArray = new long[]{54210108624L, 5076944270305263616L};
        object[11] = lArray;
        lArray = new long[]{542101086242L, -4570789518076018688L};
        object[12] = lArray;
        lArray = new long[]{5421010862427L, -8814407033341083648L};
        object[13] = lArray;
        lArray = new long[]{54210108624275L, 4089650035136921600L};
        object[14] = lArray;
        lArray = new long[]{542101086242752L, 4003012203950112768L};
        object[15] = lArray;
        lArray = new long[]{5421010862427522L, 3136633892082024448L};
        object[16] = lArray;
        lArray = new long[]{54210108624275221L, -5527149226598858752L};
        object[17] = lArray;
        lArray = new long[]{542101086242752217L, 68739955140067328L};
        object[18] = lArray;
        lArray = new long[]{5421010862427522170L, 687399551400673280L};
        object[19] = lArray;
        LONGLONG_TEN_POWERS_TABLE = (long[][])object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0019\n\u0002\b\n\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b>\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002J\u0018\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\tH\u0007J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0007J\u0010\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u00020\tH\u0007J\u0010\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0005H\u0007J \u0010&\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0007J\u0015\u0010,\u001a\u00020\f2\u0006\u0010(\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b-J\u0018\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J\u0018\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u0002012\u0006\u0010/\u001a\u000200H\u0007J\u001c\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u0002022\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0007J\u001c\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00072\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0007J\u0018\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u00020\t2\u0006\u0010/\u001a\u000200H\u0007J\u0018\u0010&\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\tH\u0002J\u0010\u00109\u001a\u00020\u00072\u0006\u00108\u001a\u00020\tH\u0002J\u0018\u0010A\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u00108\u001a\u00020\tH\u0002J\u001b\u0010B\u001a\u00020C2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010DJ\u0015\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bGJ\u0010\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020\u0007H\u0002J\u0010\u0010J\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0007H\u0002J\u0018\u0010K\u001a\u00020\t2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u0005H\u0002J\u0010\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u00020\u0005H\u0002J\u0018\u0010O\u001a\u00020C2\u0006\u0010P\u001a\u0002022\u0006\u0010Q\u001a\u00020\fH\u0002J\u0010\u0010R\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0018\u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u001a\u0010S\u001a\u00020\t2\b\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010*\u001a\u00020\u0005H\u0002J\u001c\u0010U\u001a\u0004\u0018\u00010\f2\b\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010V\u001a\u000200H\u0002J \u0010U\u001a\u00020\f2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010V\u001a\u000200H\u0002J \u0010U\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\t2\u0006\u0010V\u001a\u000200H\u0002J \u0010X\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tH\u0002J0\u0010[\u001a\u00020\f2\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002J \u0010[\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\tH\u0002J(\u0010_\u001a\u00020`2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010b\u001a\u00020\t2\u0006\u0010c\u001a\u00020`H\u0002J0\u0010d\u001a\u00020`2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u0005H\u0002J \u0010[\u001a\u00020\u00072\u0006\u0010g\u001a\u00020\u00072\u0006\u0010]\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\tH\u0002J0\u0010[\u001a\u00020\f2\u0006\u0010g\u001a\u00020\u00072\u0006\u0010]\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002J0\u0010d\u001a\u00020`2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010h\u001a\u00020i2\u0006\u0010f\u001a\u00020\u0005H\u0002J \u0010[\u001a\u00020\u00072\u0006\u0010g\u001a\u00020\u00072\u0006\u0010j\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\tH\u0002J0\u0010[\u001a\u00020\f2\u0006\u0010g\u001a\u00020\u00072\u0006\u0010j\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002J0\u0010d\u001a\u00020`2\u0006\u0010k\u001a\u00020i2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010h\u001a\u00020i2\u0006\u0010l\u001a\u00020iH\u0002J \u0010m\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u0005H\u0002J \u0010m\u001a\u00020\f2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u0005H\u0002J*\u0010n\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010T\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002J\u0018\u0010o\u001a\u00020\u00052\u0006\u0010p\u001a\u00020\u00052\u0006\u0010q\u001a\u00020\u0005H\u0002J \u0010o\u001a\u00020\f2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010q\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\tH\u0002J(\u0010o\u001a\u00020\f2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010s\u001a\u00020\tH\u0002J(\u0010o\u001a\u00020\f2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\t2\u0006\u0010t\u001a\u00020\u00072\u0006\u0010s\u001a\u00020\tH\u0002J,\u0010o\u001a\u00020\f2\b\u0010u\u001a\u0004\u0018\u00010\u00072\u0006\u0010r\u001a\u00020\t2\b\u0010t\u001a\u0004\u0018\u00010\u00072\u0006\u0010s\u001a\u00020\tH\u0002J\u0018\u0010v\u001a\u00020\u00072\u0006\u0010w\u001a\u00020\u00052\u0006\u00108\u001a\u00020\tH\u0002J\u001c\u0010v\u001a\u0004\u0018\u00010\u00072\b\u0010w\u001a\u0004\u0018\u00010\u00072\u0006\u00108\u001a\u00020\tH\u0002J:\u0010x\u001a\u0004\u0018\u00010\f2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010y\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u00052\u0006\u0010V\u001a\u000200H\u0002J:\u0010{\u001a\u0004\u0018\u00010\f2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010y\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u00052\u0006\u0010V\u001a\u000200H\u0002J<\u0010{\u001a\u0004\u0018\u00010\f2\b\u0010p\u001a\u0004\u0018\u00010\u00072\u0006\u0010y\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u00052\u0006\u0010V\u001a\u000200H\u0002J<\u0010{\u001a\u0004\u0018\u00010\f2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010y\u001a\u00020\t2\b\u0010q\u001a\u0004\u0018\u00010\u00072\u0006\u0010z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u00052\u0006\u0010V\u001a\u000200H\u0002J>\u0010{\u001a\u0004\u0018\u00010\f2\b\u0010p\u001a\u0004\u0018\u00010\u00072\u0006\u0010y\u001a\u00020\t2\b\u0010q\u001a\u0004\u0018\u00010\u00072\u0006\u0010z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\u00052\u0006\u0010V\u001a\u000200H\u0002J:\u0010|\u001a\u0004\u0018\u00010\f2\u0006\u0010}\u001a\u00020\u00052\u0006\u0010~\u001a\u00020\u00052\u0006\u0010\u007f\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002JF\u0010\u0081\u0001\u001a\u0004\u0018\u00010\f2\u0007\u0010\u0082\u0001\u001a\u00020\u00052\u0007\u0010\u0083\u0001\u001a\u00020\u00052\u0006\u0010\u007f\u001a\u00020\u00052\u0007\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002J*\u0010\u0085\u0001\u001a\u00020\f2\u0006\u0010a\u001a\u00020\t2\u0007\u0010\u0086\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010^\u001a\u00020\tH\u0002J(\u0010\u0087\u0001\u001a\u00020\f2\u0006\u00108\u001a\u00020\t2\u0007\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0000\u00a2\u0006\u0003\b\u0088\u0001J\u001a\u0010\u0089\u0001\u001a\u00020;2\u0006\u00108\u001a\u00020\u00052\u0007\u0010\u008a\u0001\u001a\u00020\u0005H\u0002J\u001b\u0010\u008b\u0001\u001a\u00020\u00052\u0007\u0010\u008c\u0001\u001a\u00020\u00052\u0007\u0010\u008d\u0001\u001a\u00020\u0005H\u0002J6\u0010\u008e\u0001\u001a\u00020\u00052\u0007\u0010\u008f\u0001\u001a\u00020\u00052\u0007\u0010\u0090\u0001\u001a\u00020\u00052\u0007\u0010\u0091\u0001\u001a\u00020\u00052\u0007\u0010\u0092\u0001\u001a\u00020\u00052\u0007\u0010\u0093\u0001\u001a\u00020\u0005H\u0002J\u001b\u0010\u0094\u0001\u001a\u00020`2\u0007\u0010\u0095\u0001\u001a\u00020\u00052\u0007\u0010\u0096\u0001\u001a\u00020\u0005H\u0002J\u001b\u0010\u0097\u0001\u001a\u00020`2\u0007\u0010\u0095\u0001\u001a\u00020\u00052\u0007\u0010\u0096\u0001\u001a\u00020\u0005H\u0002J)\u0010\u0098\u0001\u001a\u00020\t2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010y\u001a\u00020\t2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\tH\u0002J+\u0010\u0098\u0001\u001a\u00020\t2\u0006\u0010p\u001a\u00020\u00052\u0006\u0010y\u001a\u00020\t2\b\u0010q\u001a\u0004\u0018\u00010\u00072\u0006\u0010z\u001a\u00020\tH\u0002J-\u0010\u0098\u0001\u001a\u00020\t2\b\u0010p\u001a\u0004\u0018\u00010\u00072\u0006\u0010y\u001a\u00020\t2\b\u0010q\u001a\u0004\u0018\u00010\u00072\u0006\u0010z\u001a\u00020\tH\u0002J\u0019\u0010\u0099\u0001\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u0005H\u0002J!\u0010\u0099\u0001\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\tH\u0002J#\u0010\u0099\u0001\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00052\b\u0010L\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\tH\u0002J#\u0010\u0099\u0001\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00072\b\u0010L\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\tH\u0002J)\u0010\u009a\u0001\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010V\u001a\u000200H\u0002J+\u0010\u009a\u0001\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00052\b\u0010L\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\t2\u0006\u0010V\u001a\u000200H\u0002J+\u0010\u009a\u0001\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u00072\b\u0010L\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\t2\u0006\u0010V\u001a\u000200H\u0002J6\u0010\u009b\u0001\u001a\u0004\u0018\u00010\f2\u0007\u0010\u008c\u0001\u001a\u00020\u00052\u0007\u0010\u008d\u0001\u001a\u00020\u00052\u0007\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010V\u001a\u000200H\u0002J\u001b\u0010\u009e\u0001\u001a\u00020\t2\u0007\u0010\u008c\u0001\u001a\u00020\u00052\u0007\u0010\u008d\u0001\u001a\u00020\u0005H\u0002J-\u0010\u009f\u0001\u001a\u00020`2\u0007\u0010\u00a0\u0001\u001a\u00020\u00052\u0007\u0010\u00a1\u0001\u001a\u00020\u00052\u0007\u0010\u00a2\u0001\u001a\u00020\u00052\u0007\u0010\u00a3\u0001\u001a\u00020\u0005H\u0002J;\u0010{\u001a\u00020\f2\u0007\u0010\u00a4\u0001\u001a\u00020\u00052\u0007\u0010\u00a5\u0001\u001a\u00020\t2\u0006\u0010\u007f\u001a\u00020\u00052\u0007\u0010\u00a6\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tH\u0002J=\u0010{\u001a\u00020\f2\t\u0010\u00a4\u0001\u001a\u0004\u0018\u00010\u00072\u0007\u0010\u00a5\u0001\u001a\u00020\t2\u0006\u0010\u007f\u001a\u00020\u00052\u0007\u0010\u00a6\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tH\u0002J=\u0010{\u001a\u00020\f2\u0007\u0010\u00a4\u0001\u001a\u00020\u00052\u0007\u0010\u00a5\u0001\u001a\u00020\t2\b\u0010\u007f\u001a\u0004\u0018\u00010\u00072\u0007\u0010\u00a6\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tH\u0002J?\u0010{\u001a\u00020\f2\t\u0010\u00a4\u0001\u001a\u0004\u0018\u00010\u00072\u0007\u0010\u00a5\u0001\u001a\u00020\t2\b\u0010\u007f\u001a\u0004\u0018\u00010\u00072\u0007\u0010\u00a6\u0001\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0003R\u0016\u0010\u0013\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0003R\u0016\u0010\u0015\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0003R\u0016\u0010\u0017\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0003R\u0016\u0010\u0019\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001a\u0010\u0003R\u0016\u0010\u001b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001c\u0010\u0003R\u0016\u0010\u001d\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\u0003R\u0016\u0010\u001f\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b \u0010\u0003R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010=R\u000e\u0010>\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0080\u0001\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020;0\u000bX\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u009d\u0001\u00a8\u0006\u00a7\u0001"}, d2={"Lcom/macrofocus/common/math/big/CommonBigDecimal$Companion;", "", "<init>", "()V", "INFLATED", "", "INFLATED_BIGINT", "Lcom/macrofocus/common/math/big/CommonBigInteger;", "MAX_COMPACT_DIGITS", "", "ZERO_THROUGH_TEN", "", "Lcom/macrofocus/common/math/big/CommonBigDecimal;", "[Lcom/macrofocus/common/math/big/CommonBigDecimal;", "ZERO_SCALED_BY", "HALF_LONG_MAX_VALUE", "HALF_LONG_MIN_VALUE", "ZERO", "getZERO$annotations", "ONE", "getONE$annotations", "TWO", "getTWO$annotations", "TEN", "getTEN$annotations", "ONE_TENTH", "getONE_TENTH$annotations", "ONE_HALF", "getONE_HALF$annotations", "PI", "getPI$annotations", "E", "getE$annotations", "parseExp", "in", "", "offset", "len", "of", "unscaledVal", "scale", "prec", "val", "intVal", "zeroValueOf", "zeroValueOf$macrofocus_common", "", "ctx", "Lcom/macrofocus/common/math/big/MathContext;", "", "", "DOUBLE_10_POW", "", "FLOAT_10_POW", "", "bigTenToThe", "n", "expandBigIntegerTenPowers", "LONG_TEN_POWERS_TABLE", "", "BIG_TEN_POWERS_TABLE", "[Lcom/macrofocus/common/math/big/CommonBigInteger;", "BIG_TEN_POWERS_TABLE_INITLEN", "BIG_TEN_POWERS_TABLE_MAX", "THRESHOLDS_TABLE", "longMultiplyPowerTen", "matchScale", "", "([Lcom/macrofocus/common/math/big/CommonBigDecimal;)V", "longDigitLength", "x", "longDigitLength$macrofocus_common", "bigDigitLength", "b", "compactValFor", "longCompareMagnitude", "y", "saturateLong", "s", "print", "name", "bd", "checkScaleNonZero", "checkScale", "intCompact", "doRound", "mc", "compactVal", "divideAndRoundByTenPow", "tenPow", "roundingMode", "divideAndRound", "ldividend", "ldivisor", "preferredScale", "commonNeedIncrement", "", "qsign", "cmpFracHalf", "oddQuot", "needIncrement", "q", "r", "bdividend", "mq", "Lcom/macrofocus/common/math/big/MutableBigInteger;", "bdivisor", "mdivisor", "mr", "createAndStripZerosToMatchScale", "stripZerosToMatchScale", "sum", "xs", "ys", "scale1", "scale2", "snd", "fst", "bigMultiplyPowerTen", "value", "divideSmallFastPath", "xscale", "yscale", "divide", "multiplyDivideAndRound", "dividend0", "dividend1", "divisor", "DIV_NUM_BASE", "divideAndRound128", "dividendHi", "dividendLo", "sign", "roundedTenPower", "raise", "scaledTenPow", "scaledTenPow$macrofocus_common", "divRemNegativeLong", "d", "make64", "hi", "lo", "mulsub", "u1", "u0", "v1", "v0", "q0", "unsignedLongCompare", "one", "two", "unsignedLongCompareEq", "compareMagnitudeNormalized", "multiply", "multiplyAndRound", "doRound128", "LONGLONG_TEN_POWERS_TABLE", "[[J", "precision", "longLongCompareMagnitude", "hi0", "lo0", "hi1", "lo1", "dividend", "dividendScale", "divisorScale", "macrofocus-common"})
    @SourceDebugExtension(value={"SMAP\nCommonBigDecimal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBigDecimal.kt\ncom/macrofocus/common/math/big/CommonBigDecimal$Companion\n+ 2 Lock.kt\ncom/macrofocus/common/math/big/LockKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,5450:1\n7#2:5451\n1#3:5452\n*S KotlinDebug\n*F\n+ 1 CommonBigDecimal.kt\ncom/macrofocus/common/math/big/CommonBigDecimal$Companion\n*L\n3424#1:5451\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getZERO$annotations() {
        }

        public static /* synthetic */ void getONE$annotations() {
        }

        public static /* synthetic */ void getTWO$annotations() {
        }

        public static /* synthetic */ void getTEN$annotations() {
        }

        public static /* synthetic */ void getONE_TENTH$annotations() {
        }

        public static /* synthetic */ void getONE_HALF$annotations() {
        }

        public static /* synthetic */ void getPI$annotations() {
        }

        public static /* synthetic */ void getE$annotations() {
        }

        private final long parseExp(char[] in, int offset, int len) {
            boolean negexp;
            int offset2 = offset;
            int len2 = len;
            long exp = 0L;
            char c = in[++offset2];
            --len2;
            boolean bl = negexp = c == '-';
            if (negexp || c == '+') {
                c = in[++offset2];
                --len2;
            }
            if (len2 <= 0) {
                throw new NumberFormatException("No exponent digits.");
            }
            while (len2 > 10 && (c == '0' || Utils.toDigit(c, 10) == 0)) {
                c = in[++offset2];
                --len2;
            }
            if (len2 > 10) {
                throw new NumberFormatException("Too many nonzero exponent digits.");
            }
            while (true) {
                int v = 0;
                boolean bl2 = '0' <= c ? c < ':' : false;
                if (bl2) {
                    v = c - 48;
                } else {
                    v = Utils.toDigit(c, 10);
                    if (v < 0) {
                        throw new NumberFormatException("Not a digit.");
                    }
                }
                exp = exp * (long)10 + (long)v;
                if (len2 == 1) break;
                c = in[++offset2];
                --len2;
            }
            if (negexp) {
                exp = -exp;
            }
            return exp;
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(long unscaledVal, int scale) {
            if (scale == 0) {
                return this.of(unscaledVal);
            }
            if (unscaledVal == 0L) {
                return this.zeroValueOf$macrofocus_common(scale);
            }
            return new CommonBigDecimal(unscaledVal == Long.MIN_VALUE ? INFLATED_BIGINT : null, unscaledVal, scale, 0);
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(long unscaledVal, int scale, int prec) {
            return scale == 0 && unscaledVal >= 0L && unscaledVal < (long)ZERO_THROUGH_TEN.length ? ZERO_THROUGH_TEN[(int)unscaledVal] : (unscaledVal == 0L ? this.zeroValueOf$macrofocus_common(scale) : new CommonBigDecimal(unscaledVal == Long.MIN_VALUE ? INFLATED_BIGINT : null, unscaledVal, scale, prec));
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(int val) {
            return this.of((long)val);
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(long val) {
            return val >= 0L && val < (long)ZERO_THROUGH_TEN.length ? ZERO_THROUGH_TEN[(int)val] : (val != Long.MIN_VALUE ? new CommonBigDecimal(null, val, 0, 0) : new CommonBigDecimal(INFLATED_BIGINT, val, 0, 0));
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(@NotNull CommonBigInteger intVal, int scale, int prec) {
            Intrinsics.checkNotNullParameter((Object)intVal, (String)"intVal");
            long val = this.compactValFor(intVal);
            if (val == 0L) {
                return this.zeroValueOf$macrofocus_common(scale);
            }
            if (scale == 0 && val >= 0L && val < (long)ZERO_THROUGH_TEN.length) {
                return ZERO_THROUGH_TEN[(int)val];
            }
            return new CommonBigDecimal(intVal, val, scale, prec);
        }

        @NotNull
        public final CommonBigDecimal zeroValueOf$macrofocus_common(int scale) {
            return scale >= 0 && scale < ZERO_SCALED_BY.length ? ZERO_SCALED_BY[scale] : new CommonBigDecimal(CommonBigInteger.ZERO, 0L, scale, 1);
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(double val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new CommonBigDecimal(val, ctx);
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(float val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return this.of((double)val, ctx);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CommonBigDecimal of(@NotNull String val, @Nullable MathContext ctx) {
            Intrinsics.checkNotNullParameter((Object)val, (String)"val");
            return ctx == null ? new CommonBigDecimal(val) : new CommonBigDecimal(val, ctx);
        }

        public static /* synthetic */ CommonBigDecimal of$default(Companion companion, String string, MathContext mathContext, int n, Object object) {
            if ((n & 2) != 0) {
                mathContext = null;
            }
            return companion.of(string, mathContext);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CommonBigDecimal of(@NotNull CommonBigInteger val, @Nullable MathContext ctx) {
            Intrinsics.checkNotNullParameter((Object)val, (String)"val");
            return ctx == null ? new CommonBigDecimal(val) : new CommonBigDecimal(val, ctx);
        }

        public static /* synthetic */ CommonBigDecimal of$default(Companion companion, CommonBigInteger commonBigInteger, MathContext mathContext, int n, Object object) {
            if ((n & 2) != 0) {
                mathContext = null;
            }
            return companion.of(commonBigInteger, mathContext);
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(int val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new CommonBigDecimal((long)val, ctx);
        }

        @JvmStatic
        @NotNull
        public final CommonBigDecimal of(long val, @NotNull MathContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new CommonBigDecimal(val, ctx);
        }

        private final CommonBigInteger bigTenToThe(int n) {
            if (n < 0) {
                return CommonBigInteger.ZERO;
            }
            if (n < BIG_TEN_POWERS_TABLE_MAX) {
                CommonBigInteger commonBigInteger;
                CommonBigInteger[] pows = BIG_TEN_POWERS_TABLE;
                if (n < pows.length) {
                    CommonBigInteger commonBigInteger2 = pows[n];
                    commonBigInteger = commonBigInteger2;
                    Intrinsics.checkNotNull((Object)commonBigInteger2);
                } else {
                    commonBigInteger = this.expandBigIntegerTenPowers(n);
                }
                return commonBigInteger;
            }
            return CommonBigInteger.TEN.pow(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final CommonBigInteger expandBigIntegerTenPowers(int n) {
            Companion any$iv = this;
            boolean $i$f$lock = false;
            Companion companion = any$iv;
            synchronized (companion) {
                boolean bl = false;
                CommonBigInteger[] pows = BIG_TEN_POWERS_TABLE;
                int curLen = pows.length;
                if (curLen <= n) {
                    int newLen;
                    for (newLen = curLen << 1; newLen <= n; newLen <<= 1) {
                    }
                    CommonBigInteger[] commonBigIntegerArray = Arrays.copyOf(pows, newLen);
                    Intrinsics.checkNotNullExpressionValue((Object)commonBigIntegerArray, (String)"copyOf(...)");
                    pows = commonBigIntegerArray;
                    int n2 = newLen;
                    for (int i = curLen; i < n2; ++i) {
                        CommonBigInteger commonBigInteger = pows[i - 1];
                        Intrinsics.checkNotNull((Object)commonBigInteger);
                        pows[i] = commonBigInteger.times(CommonBigInteger.TEN);
                    }
                    BIG_TEN_POWERS_TABLE = pows;
                }
                CommonBigInteger commonBigInteger = pows[n];
                Intrinsics.checkNotNull((Object)commonBigInteger);
                CommonBigInteger commonBigInteger2 = commonBigInteger;
                return commonBigInteger2;
            }
        }

        private final long longMultiplyPowerTen(long val, int n) {
            if (val == 0L || n <= 0) {
                return val;
            }
            long[] tab = LONG_TEN_POWERS_TABLE;
            long[] bounds = THRESHOLDS_TABLE;
            if (n < tab.length && n < bounds.length) {
                long tenpower = tab[n];
                if (val == 1L) {
                    return tenpower;
                }
                if (Math.abs(val) <= bounds[n]) {
                    return val * tenpower;
                }
            }
            return Long.MIN_VALUE;
        }

        private final void matchScale(CommonBigDecimal[] val) {
            if (val[0]._scale < val[1]._scale) {
                val[0] = val[0].setScale(val[1]._scale, RoundingMode.UNNECESSARY.getValue());
            } else if (val[1]._scale < val[0]._scale) {
                val[1] = val[1].setScale(val[0]._scale, RoundingMode.UNNECESSARY.getValue());
            }
        }

        public final int longDigitLength$macrofocus_common(long x) {
            long[] tab;
            long x2 = x;
            if (!(x2 != Long.MIN_VALUE)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (x2 < 0L) {
                x2 = -x2;
            }
            if (x2 < 10L) {
                return 1;
            }
            int r = (64 - Utils.numberOfLeadingZeros(x2) + 1) * 1233 >>> 12;
            return r >= (tab = LONG_TEN_POWERS_TABLE).length || x2 < tab[r] ? r : r + 1;
        }

        private final int bigDigitLength(CommonBigInteger b) {
            if (b.get_signum$macrofocus_common() == 0) {
                return 1;
            }
            int r = (int)(((long)b.getBitLength() + 1L) * (long)646456993 >>> 31);
            return b.compareMagnitude$macrofocus_common(this.bigTenToThe(r)) < 0 ? r : r + 1;
        }

        private final long compactValFor(CommonBigInteger b) {
            int[] m = b._mag;
            int len = m.length;
            if (len == 0) {
                return 0L;
            }
            int d = m[0];
            if (len > 2 || len == 2 && d < 0) {
                return Long.MIN_VALUE;
            }
            long u = len == 2 ? ((long)m[1] & 0xFFFFFFFFL) + ((long)d << 32) : (long)d & 0xFFFFFFFFL;
            return b.get_signum$macrofocus_common() < 0 ? -u : u;
        }

        private final int longCompareMagnitude(long x, long y) {
            long x2 = x;
            long y2 = y;
            if (x2 < 0L) {
                x2 = -x2;
            }
            if (y2 < 0L) {
                y2 = -y2;
            }
            return x2 < y2 ? -1 : (x2 == y2 ? 0 : 1);
        }

        private final int saturateLong(long s) {
            int i = (int)s;
            return s == (long)i ? i : (s < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE);
        }

        private final void print(String name, CommonBigDecimal bd) {
            String string = name + ":\t_intCompact " + bd._intCompact + "\t_intVal " + bd._intVal + "\t_scale " + bd._scale + "\t_precision " + bd._precision;
            System.out.println((Object)string);
        }

        private final int checkScaleNonZero(long val) {
            int asInt = (int)val;
            if ((long)asInt != val) {
                throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
            }
            return asInt;
        }

        private final int checkScale(long intCompact, long val) {
            int asInt = (int)val;
            if ((long)asInt != val) {
                int n = asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                if (intCompact != 0L) {
                    throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
                }
            }
            return asInt;
        }

        private final int checkScale(CommonBigInteger intVal, long val) {
            int asInt = (int)val;
            if ((long)asInt != val) {
                asInt = val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                CommonBigInteger commonBigInteger = intVal;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                if (commonBigInteger.getSignum() != 0) {
                    throw new ArithmeticException(asInt > 0 ? "Underflow" : "Overflow");
                }
            }
            return asInt;
        }

        private final CommonBigDecimal doRound(CommonBigDecimal val, MathContext mc) {
            int mcp = mc.getPrecision();
            boolean wasDivided = false;
            if (mcp > 0) {
                CommonBigDecimal commonBigDecimal = val;
                Intrinsics.checkNotNull((Object)commonBigDecimal);
                CommonBigInteger intVal = commonBigDecimal._intVal;
                long compactVal = val._intCompact;
                int scale = val._scale;
                int prec = val.getPrecision();
                int mode = mc.getRoundingMode().getValue();
                int drop = 0;
                if (compactVal == Long.MIN_VALUE) {
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale = this.checkScaleNonZero((long)scale - (long)drop);
                        CommonBigInteger commonBigInteger = intVal;
                        Intrinsics.checkNotNull((Object)commonBigInteger);
                        intVal = this.divideAndRoundByTenPow(commonBigInteger, drop, mode);
                        wasDivided = true;
                        compactVal = this.compactValFor(intVal);
                        if (compactVal != Long.MIN_VALUE) {
                            prec = this.longDigitLength$macrofocus_common(compactVal);
                            break;
                        }
                        prec = this.bigDigitLength(intVal);
                        drop = prec - mcp;
                    }
                }
                if (compactVal != Long.MIN_VALUE) {
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale = this.checkScaleNonZero((long)scale - (long)drop);
                        compactVal = this.divideAndRound(compactVal, LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                        wasDivided = true;
                        prec = this.longDigitLength$macrofocus_common(compactVal);
                        drop = prec - mcp;
                        intVal = null;
                    }
                }
                return wasDivided ? new CommonBigDecimal(intVal, compactVal, scale, prec) : val;
            }
            return val;
        }

        private final CommonBigDecimal doRound(long compactVal, int scale, MathContext mc) {
            long compactVal2 = compactVal;
            int scale2 = scale;
            int mcp = mc.getPrecision();
            if (mcp > 0 && mcp < 19) {
                int prec = this.longDigitLength$macrofocus_common(compactVal2);
                int drop = prec - mcp;
                while (drop > 0) {
                    scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                    compactVal2 = this.divideAndRound(compactVal2, LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                    prec = this.longDigitLength$macrofocus_common(compactVal2);
                    drop = prec - mcp;
                }
                return this.of(compactVal2, scale2, prec);
            }
            return this.of(compactVal2, scale2);
        }

        private final CommonBigDecimal doRound(CommonBigInteger intVal, int scale, MathContext mc) {
            CommonBigInteger intVal2 = intVal;
            int scale2 = scale;
            int mcp = mc.getPrecision();
            int prec = 0;
            if (mcp > 0) {
                long compactVal = this.compactValFor(intVal2);
                int mode = mc.getRoundingMode().getValue();
                int drop = 0;
                if (compactVal == Long.MIN_VALUE) {
                    prec = this.bigDigitLength(intVal2);
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                        compactVal = this.compactValFor(intVal2 = this.divideAndRoundByTenPow(intVal2, drop, mode));
                        if (compactVal != Long.MIN_VALUE) break;
                        prec = this.bigDigitLength(intVal2);
                        drop = prec - mcp;
                    }
                }
                if (compactVal != Long.MIN_VALUE) {
                    prec = this.longDigitLength$macrofocus_common(compactVal);
                    drop = prec - mcp;
                    while (drop > 0) {
                        scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                        compactVal = this.divideAndRound(compactVal, LONG_TEN_POWERS_TABLE[drop], mc.getRoundingMode().getValue());
                        prec = this.longDigitLength$macrofocus_common(compactVal);
                        drop = prec - mcp;
                    }
                    return this.of(compactVal, scale2, prec);
                }
            }
            return new CommonBigDecimal(intVal2, Long.MIN_VALUE, scale2, prec);
        }

        private final CommonBigInteger divideAndRoundByTenPow(CommonBigInteger intVal, int tenPow, int roundingMode) {
            CommonBigInteger intVal2 = intVal;
            intVal2 = tenPow < LONG_TEN_POWERS_TABLE.length ? this.divideAndRound(intVal2, LONG_TEN_POWERS_TABLE[tenPow], roundingMode) : this.divideAndRound(intVal2, this.bigTenToThe(tenPow), roundingMode);
            return intVal2;
        }

        private final CommonBigDecimal divideAndRound(long ldividend, long ldivisor, int scale, int roundingMode, int preferredScale) {
            int qsign = 0;
            long q = ldividend / ldivisor;
            if (roundingMode == RoundingMode.DOWN.getValue() && scale == preferredScale) {
                return this.of(q, scale);
            }
            long r = ldividend % ldivisor;
            int n = qsign = ldividend < 0L == ldivisor < 0L ? 1 : -1;
            if (r != 0L) {
                boolean increment = this.needIncrement(ldivisor, roundingMode, qsign, q, r);
                return this.of(increment ? q + (long)qsign : q, scale);
            }
            return preferredScale != scale ? this.createAndStripZerosToMatchScale(q, scale, (long)preferredScale) : this.of(q, scale);
        }

        private final long divideAndRound(long ldividend, long ldivisor, int roundingMode) {
            int qsign = 0;
            long q = ldividend / ldivisor;
            if (roundingMode == RoundingMode.DOWN.getValue()) {
                return q;
            }
            long r = ldividend % ldivisor;
            int n = qsign = ldividend < 0L == ldivisor < 0L ? 1 : -1;
            if (r != 0L) {
                boolean increment = this.needIncrement(ldivisor, roundingMode, qsign, q, r);
                return increment ? q + (long)qsign : q;
            }
            return q;
        }

        private final boolean commonNeedIncrement(int roundingMode, int qsign, int cmpFracHalf, boolean oddQuot) {
            int n = roundingMode;
            if (n == RoundingMode.UNNECESSARY.getValue()) {
                throw new ArithmeticException("Rounding necessary");
            }
            if (n == RoundingMode.UP.getValue()) {
                return true;
            }
            if (n == RoundingMode.DOWN.getValue()) {
                return false;
            }
            if (n == RoundingMode.CEILING.getValue()) {
                return qsign > 0;
            }
            if (n == RoundingMode.FLOOR.getValue()) {
                return qsign < 0;
            }
            if (!(roundingMode >= RoundingMode.HALF_UP.getValue() && roundingMode <= RoundingMode.HALF_EVEN.getValue())) {
                boolean bl = false;
                String string = "Unexpected rounding mode" + RoundingMode.Companion.valueOf(roundingMode);
                throw new IllegalArgumentException(string.toString());
            }
            if (cmpFracHalf < 0) {
                return false;
            }
            if (cmpFracHalf > 0) {
                return true;
            }
            if (!(cmpFracHalf == 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n2 = roundingMode;
            if (n2 == RoundingMode.HALF_DOWN.getValue()) {
                return false;
            }
            if (n2 == RoundingMode.HALF_UP.getValue()) {
                return true;
            }
            if (n2 == RoundingMode.HALF_EVEN.getValue()) {
                return oddQuot;
            }
            throw new AssertionError((Object)("Unexpected rounding mode" + roundingMode));
        }

        private final boolean needIncrement(long ldivisor, int roundingMode, int qsign, long q, long r) {
            if (!(r != 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int cmpFracHalf = 0;
            cmpFracHalf = r <= -4611686018427387904L || r > 0x3FFFFFFFFFFFFFFFL ? 1 : this.longCompareMagnitude((long)2 * r, ldivisor);
            return this.commonNeedIncrement(roundingMode, qsign, cmpFracHalf, (q & 1L) != 0L);
        }

        private final CommonBigInteger divideAndRound(CommonBigInteger bdividend, long ldivisor, int roundingMode) {
            int qsign;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend._mag);
            MutableBigInteger mq = new MutableBigInteger();
            long r = mdividend.divide(ldivisor, mq);
            boolean isRemainderZero = r == 0L;
            int n = qsign = ldivisor < 0L ? -bdividend.get_signum$macrofocus_common() : bdividend.get_signum$macrofocus_common();
            if (!isRemainderZero && this.needIncrement(ldivisor, roundingMode, qsign, mq, r)) {
                mq.add(MutableBigInteger.Companion.getONE());
            }
            return mq.toBigInteger(qsign);
        }

        private final CommonBigDecimal divideAndRound(CommonBigInteger bdividend, long ldivisor, int scale, int roundingMode, int preferredScale) {
            int qsign;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend._mag);
            MutableBigInteger mq = new MutableBigInteger();
            long r = mdividend.divide(ldivisor, mq);
            boolean isRemainderZero = r == 0L;
            int n = qsign = ldivisor < 0L ? -bdividend.get_signum$macrofocus_common() : bdividend.get_signum$macrofocus_common();
            if (!isRemainderZero) {
                if (this.needIncrement(ldivisor, roundingMode, qsign, mq, r)) {
                    mq.add(MutableBigInteger.Companion.getONE());
                }
                return mq.toBigDecimal(qsign, scale);
            }
            if (preferredScale != scale) {
                long compactVal = mq.toCompactValue(qsign);
                if (compactVal != Long.MIN_VALUE) {
                    return this.createAndStripZerosToMatchScale(compactVal, scale, (long)preferredScale);
                }
                CommonBigInteger intVal = mq.toBigInteger(qsign);
                return this.createAndStripZerosToMatchScale(intVal, scale, (long)preferredScale);
            }
            return mq.toBigDecimal(qsign, scale);
        }

        private final boolean needIncrement(long ldivisor, int roundingMode, int qsign, MutableBigInteger mq, long r) {
            if (!(r != 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int cmpFracHalf = 0;
            cmpFracHalf = r <= -4611686018427387904L || r > 0x3FFFFFFFFFFFFFFFL ? 1 : this.longCompareMagnitude((long)2 * r, ldivisor);
            return this.commonNeedIncrement(roundingMode, qsign, cmpFracHalf, mq.isOdd());
        }

        private final CommonBigInteger divideAndRound(CommonBigInteger bdividend, CommonBigInteger bdivisor, int roundingMode) {
            MutableBigInteger mr;
            boolean isRemainderZero = false;
            int qsign = 0;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend._mag);
            MutableBigInteger mq = new MutableBigInteger();
            MutableBigInteger mdivisor = new MutableBigInteger(bdivisor._mag);
            MutableBigInteger mutableBigInteger = mr = MutableBigInteger.divide$default(mdividend, mdivisor, mq, false, 4, null);
            Intrinsics.checkNotNull((Object)mutableBigInteger);
            isRemainderZero = mutableBigInteger.isZero();
            int n = qsign = bdividend.get_signum$macrofocus_common() != bdivisor.get_signum$macrofocus_common() ? -1 : 1;
            if (!isRemainderZero && this.needIncrement(mdivisor, roundingMode, qsign, mq, mr)) {
                mq.add(MutableBigInteger.Companion.getONE());
            }
            return mq.toBigInteger(qsign);
        }

        private final CommonBigDecimal divideAndRound(CommonBigInteger bdividend, CommonBigInteger bdivisor, int scale, int roundingMode, int preferredScale) {
            MutableBigInteger mr;
            boolean isRemainderZero = false;
            int qsign = 0;
            MutableBigInteger mdividend = new MutableBigInteger(bdividend._mag);
            MutableBigInteger mq = new MutableBigInteger();
            MutableBigInteger mdivisor = new MutableBigInteger(bdivisor._mag);
            MutableBigInteger mutableBigInteger = mr = MutableBigInteger.divide$default(mdividend, mdivisor, mq, false, 4, null);
            Intrinsics.checkNotNull((Object)mutableBigInteger);
            isRemainderZero = mutableBigInteger.isZero();
            int n = qsign = bdividend.get_signum$macrofocus_common() != bdivisor.get_signum$macrofocus_common() ? -1 : 1;
            if (!isRemainderZero) {
                if (this.needIncrement(mdivisor, roundingMode, qsign, mq, mr)) {
                    mq.add(MutableBigInteger.Companion.getONE());
                }
                return mq.toBigDecimal(qsign, scale);
            }
            if (preferredScale != scale) {
                long compactVal = mq.toCompactValue(qsign);
                if (compactVal != Long.MIN_VALUE) {
                    return this.createAndStripZerosToMatchScale(compactVal, scale, (long)preferredScale);
                }
                CommonBigInteger intVal = mq.toBigInteger(qsign);
                return this.createAndStripZerosToMatchScale(intVal, scale, (long)preferredScale);
            }
            return mq.toBigDecimal(qsign, scale);
        }

        private final boolean needIncrement(MutableBigInteger mdivisor, int roundingMode, int qsign, MutableBigInteger mq, MutableBigInteger mr) {
            if (!(!mr.isZero())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int cmpFracHalf = mr.compareHalf(mdivisor);
            return this.commonNeedIncrement(roundingMode, qsign, cmpFracHalf, mq.isOdd());
        }

        private final CommonBigDecimal createAndStripZerosToMatchScale(CommonBigInteger intVal, int scale, long preferredScale) {
            CommonBigInteger intVal2 = intVal;
            int scale2 = scale;
            CommonBigInteger[] qr = null;
            while (intVal2.compareMagnitude$macrofocus_common(CommonBigInteger.TEN) >= 0 && (long)scale2 > preferredScale && !intVal2.testBit(0) && (qr = intVal2.divideAndRemainder(CommonBigInteger.TEN))[1].getSignum() == 0) {
                intVal2 = qr[0];
                scale2 = this.checkScale(intVal2, (long)scale2 - 1L);
            }
            return this.of(intVal2, scale2, 0);
        }

        private final CommonBigDecimal createAndStripZerosToMatchScale(long compactVal, int scale, long preferredScale) {
            long r;
            long compactVal2 = compactVal;
            int scale2 = scale;
            while (Math.abs(compactVal2) >= 10L && (long)scale2 > preferredScale && (compactVal2 & 1L) == 0L && (r = compactVal2 % 10L) == 0L) {
                scale2 = this.checkScale(compactVal2 /= (long)10, (long)scale2 - 1L);
            }
            return this.of(compactVal2, scale2);
        }

        private final CommonBigDecimal stripZerosToMatchScale(CommonBigInteger intVal, long intCompact, int scale, int preferredScale) {
            CommonBigDecimal commonBigDecimal;
            if (intCompact != Long.MIN_VALUE) {
                commonBigDecimal = this.createAndStripZerosToMatchScale(intCompact, scale, (long)preferredScale);
            } else {
                CommonBigInteger commonBigInteger = intVal;
                if (commonBigInteger == null) {
                    commonBigInteger = INFLATED_BIGINT;
                }
                commonBigDecimal = this.createAndStripZerosToMatchScale(commonBigInteger, scale, (long)preferredScale);
            }
            return commonBigDecimal;
        }

        private final long sum(long xs, long ys) {
            long sum = xs + ys;
            return ((sum ^ xs) & (sum ^ ys)) >= 0L ? sum : Long.MIN_VALUE;
        }

        private final CommonBigDecimal sum(long xs, long ys, int scale) {
            long sum = this.sum(xs, ys);
            return sum != Long.MIN_VALUE ? Companion.of(sum, scale) : new CommonBigDecimal(CommonBigInteger.Companion.of(xs).plusLong$macrofocus_common(ys), scale);
        }

        private final CommonBigDecimal sum(long xs, int scale1, long ys, int scale2) {
            long sdiff = (long)scale1 - (long)scale2;
            if (sdiff == 0L) {
                return this.sum(xs, ys, scale1);
            }
            if (sdiff < 0L) {
                int raise = this.checkScale(xs, -sdiff);
                long scaledX = this.longMultiplyPowerTen(xs, raise);
                if (scaledX != Long.MIN_VALUE) {
                    return this.sum(scaledX, ys, scale2);
                }
                CommonBigInteger bigsum = this.bigMultiplyPowerTen(xs, raise).plusLong$macrofocus_common(ys);
                return (xs ^ ys) >= 0L ? new CommonBigDecimal(bigsum, Long.MIN_VALUE, scale2, 0) : this.of(bigsum, scale2, 0);
            }
            int raise = this.checkScale(ys, sdiff);
            long scaledY = this.longMultiplyPowerTen(ys, raise);
            if (scaledY != Long.MIN_VALUE) {
                return this.sum(xs, scaledY, scale1);
            }
            CommonBigInteger bigsum = this.bigMultiplyPowerTen(ys, raise).plusLong$macrofocus_common(xs);
            return (xs ^ ys) >= 0L ? new CommonBigDecimal(bigsum, Long.MIN_VALUE, scale1, 0) : this.of(bigsum, scale1, 0);
        }

        private final CommonBigDecimal sum(long xs, int scale1, CommonBigInteger snd, int scale2) {
            CommonBigInteger snd2 = snd;
            int rscale = scale1;
            long sdiff = (long)rscale - (long)scale2;
            boolean sameSigns = MathKt.getSign((long)xs) == snd2.get_signum$macrofocus_common();
            CommonBigInteger sum = null;
            if (sdiff < 0L) {
                int raise = this.checkScale(xs, -sdiff);
                rscale = scale2;
                long scaledX = this.longMultiplyPowerTen(xs, raise);
                sum = scaledX == Long.MIN_VALUE ? snd2.plus(this.bigMultiplyPowerTen(xs, raise)) : snd2.plusLong$macrofocus_common(scaledX);
            } else {
                int raise = this.checkScale(snd2, sdiff);
                CommonBigInteger commonBigInteger = this.bigMultiplyPowerTen(snd2, raise);
                Intrinsics.checkNotNull((Object)commonBigInteger);
                snd2 = commonBigInteger;
                sum = snd2.plusLong$macrofocus_common(xs);
            }
            return sameSigns ? new CommonBigDecimal(sum, Long.MIN_VALUE, rscale, 0) : this.of(sum, rscale, 0);
        }

        private final CommonBigDecimal sum(CommonBigInteger fst, int scale1, CommonBigInteger snd, int scale2) {
            CommonBigInteger fst2 = fst;
            CommonBigInteger snd2 = snd;
            int rscale = scale1;
            long sdiff = (long)rscale - (long)scale2;
            if (sdiff != 0L) {
                if (sdiff < 0L) {
                    raise = this.checkScale(fst2, -sdiff);
                    rscale = scale2;
                    fst2 = this.bigMultiplyPowerTen(fst2, raise);
                } else {
                    raise = this.checkScale(snd2, sdiff);
                    snd2 = this.bigMultiplyPowerTen(snd2, raise);
                }
            }
            CommonBigInteger commonBigInteger = fst2;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            CommonBigInteger commonBigInteger2 = snd2;
            Intrinsics.checkNotNull((Object)commonBigInteger2);
            CommonBigInteger sum = commonBigInteger.plus(commonBigInteger2);
            return fst2.get_signum$macrofocus_common() == snd2.get_signum$macrofocus_common() ? new CommonBigDecimal(sum, Long.MIN_VALUE, rscale, 0) : this.of(sum, rscale, 0);
        }

        private final CommonBigInteger bigMultiplyPowerTen(long value, int n) {
            return n <= 0 ? CommonBigInteger.Companion.of(value) : this.bigTenToThe(n).timesLong$macrofocus_common(value);
        }

        private final CommonBigInteger bigMultiplyPowerTen(CommonBigInteger value, int n) {
            CommonBigInteger commonBigInteger;
            if (n <= 0) {
                return value;
            }
            if (n < LONG_TEN_POWERS_TABLE.length) {
                CommonBigInteger commonBigInteger2 = value;
                Intrinsics.checkNotNull((Object)commonBigInteger2);
                commonBigInteger = commonBigInteger2.timesLong$macrofocus_common(LONG_TEN_POWERS_TABLE[n]);
            } else {
                CommonBigInteger commonBigInteger3 = value;
                Intrinsics.checkNotNull((Object)commonBigInteger3);
                commonBigInteger = commonBigInteger3.times(this.bigTenToThe(n));
            }
            return commonBigInteger;
        }

        private final CommonBigDecimal divideSmallFastPath(long xs, int xscale, long ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            int mcp = mc.getPrecision();
            int roundingMode = mc.getRoundingMode().getValue();
            if (!(xscale <= yscale2 && yscale2 < 18 && mcp < 18)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int xraise = yscale2 - xscale;
            long scaledX = xraise == 0 ? xs : this.longMultiplyPowerTen(xs, xraise);
            CommonBigDecimal quotient = null;
            int cmp = this.longCompareMagnitude(scaledX, ys);
            if (cmp > 0) {
                int scl = this.checkScaleNonZero(preferredScale + (long)(--yscale2) - (long)xscale + (long)mcp);
                if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                    int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                    long scaledXs = 0L;
                    scaledXs = this.longMultiplyPowerTen(xs, raise);
                    if (scaledXs == Long.MIN_VALUE) {
                        quotient = null;
                        if (mcp - 1 >= 0 && mcp - 1 < LONG_TEN_POWERS_TABLE.length) {
                            quotient = this.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[mcp - 1], scaledX, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                        }
                        if (quotient == null) {
                            CommonBigInteger rb = this.bigMultiplyPowerTen(scaledX, mcp - 1);
                            quotient = this.divideAndRound(rb, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                        }
                    } else {
                        quotient = this.divideAndRound(scaledXs, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    }
                } else {
                    int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                    if (newScale == yscale2) {
                        quotient = this.divideAndRound(xs, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    } else {
                        int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                        long scaledYs = this.longMultiplyPowerTen(ys, raise);
                        if (scaledYs == Long.MIN_VALUE) {
                            CommonBigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                            quotient = this.divideAndRound(CommonBigInteger.Companion.of(xs), rb, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                        } else {
                            quotient = this.divideAndRound(xs, scaledYs, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                        }
                    }
                }
            } else {
                int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
                if (cmp == 0) {
                    quotient = this.roundedTenPower(scaledX < 0L == ys < 0L ? 1 : -1, mcp, scl, this.checkScaleNonZero(preferredScale));
                } else {
                    long scaledXs = this.longMultiplyPowerTen(scaledX, mcp);
                    if (scaledXs == Long.MIN_VALUE) {
                        quotient = null;
                        if (mcp < LONG_TEN_POWERS_TABLE.length) {
                            quotient = this.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[mcp], scaledX, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                        }
                        if (quotient == null) {
                            CommonBigInteger rb = this.bigMultiplyPowerTen(scaledX, mcp);
                            quotient = this.divideAndRound(rb, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                        }
                    } else {
                        quotient = this.divideAndRound(scaledXs, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    }
                }
            }
            return this.doRound(quotient, mc);
        }

        private final CommonBigDecimal divide(long xs, int xscale, long ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            int mcp = mc.getPrecision();
            if (xscale <= yscale2 && yscale2 < 18 && mcp < 18) {
                return this.divideSmallFastPath(xs, xscale, ys, yscale2, preferredScale, mc);
            }
            if (this.compareMagnitudeNormalized(xs, xscale, ys, yscale2) > 0) {
                --yscale2;
            }
            int roundingMode = mc.getRoundingMode().getValue();
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            CommonBigDecimal quotient = null;
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                long scaledXs = this.longMultiplyPowerTen(xs, raise);
                if (scaledXs == Long.MIN_VALUE) {
                    CommonBigInteger rb = this.bigMultiplyPowerTen(xs, raise);
                    quotient = this.divideAndRound(rb, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                } else {
                    quotient = this.divideAndRound(scaledXs, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                }
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                if (newScale == yscale2) {
                    quotient = this.divideAndRound(xs, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                } else {
                    int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                    long scaledYs = this.longMultiplyPowerTen(ys, raise);
                    if (scaledYs == Long.MIN_VALUE) {
                        CommonBigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                        quotient = this.divideAndRound(CommonBigInteger.Companion.of(xs), rb, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    } else {
                        quotient = this.divideAndRound(xs, scaledYs, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    }
                }
            }
            return this.doRound(quotient, mc);
        }

        private final CommonBigDecimal divide(CommonBigInteger xs, int xscale, long ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            if (-this.compareMagnitudeNormalized(ys, yscale2, xs, xscale) > 0) {
                --yscale2;
            }
            int mcp = mc.getPrecision();
            int roundingMode = mc.getRoundingMode().getValue();
            CommonBigDecimal quotient = null;
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                CommonBigInteger rb;
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                CommonBigInteger commonBigInteger = rb = this.bigMultiplyPowerTen(xs, raise);
                Intrinsics.checkNotNull((Object)commonBigInteger);
                quotient = this.divideAndRound(commonBigInteger, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                if (newScale == yscale2) {
                    CommonBigInteger commonBigInteger = xs;
                    Intrinsics.checkNotNull((Object)commonBigInteger);
                    quotient = this.divideAndRound(commonBigInteger, ys, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                } else {
                    int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                    long scaledYs = this.longMultiplyPowerTen(ys, raise);
                    if (scaledYs == Long.MIN_VALUE) {
                        CommonBigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                        CommonBigInteger commonBigInteger = xs;
                        Intrinsics.checkNotNull((Object)commonBigInteger);
                        quotient = this.divideAndRound(commonBigInteger, rb, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    } else {
                        CommonBigInteger commonBigInteger = xs;
                        Intrinsics.checkNotNull((Object)commonBigInteger);
                        quotient = this.divideAndRound(commonBigInteger, scaledYs, scl, roundingMode, this.checkScaleNonZero(preferredScale));
                    }
                }
            }
            return this.doRound(quotient, mc);
        }

        private final CommonBigDecimal divide(long xs, int xscale, CommonBigInteger ys, int yscale, long preferredScale, MathContext mc) {
            RoundingMode roundingMode;
            int yscale2 = yscale;
            if (this.compareMagnitudeNormalized(xs, xscale, ys, yscale2) > 0) {
                --yscale2;
            }
            int mcp = mc.getPrecision();
            RoundingMode it = roundingMode = mc.getRoundingMode();
            boolean bl = false;
            Utils.log((Function0<? extends Object>)((Function0)() -> Companion.divide$lambda$0$0(it)));
            int roundingMode2 = roundingMode.getValue();
            CommonBigDecimal quotient = null;
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                CommonBigInteger rb = this.bigMultiplyPowerTen(xs, raise);
                CommonBigInteger commonBigInteger = ys;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                quotient = this.divideAndRound(rb, commonBigInteger, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                CommonBigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                CommonBigInteger commonBigInteger = CommonBigInteger.Companion.of(xs);
                CommonBigInteger commonBigInteger2 = rb;
                Intrinsics.checkNotNull((Object)commonBigInteger2);
                quotient = this.divideAndRound(commonBigInteger, commonBigInteger2, scl, roundingMode2, this.checkScaleNonZero(preferredScale));
            }
            return this.doRound(quotient, mc);
        }

        private final CommonBigDecimal divide(CommonBigInteger xs, int xscale, CommonBigInteger ys, int yscale, long preferredScale, MathContext mc) {
            int yscale2 = yscale;
            if (this.compareMagnitudeNormalized(xs, xscale, ys, yscale2) > 0) {
                --yscale2;
            }
            int mcp = mc.getPrecision();
            int roundingMode = mc.getRoundingMode().getValue();
            CommonBigDecimal quotient = null;
            int scl = this.checkScaleNonZero(preferredScale + (long)yscale2 - (long)xscale + (long)mcp);
            if (this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale) > 0) {
                CommonBigInteger rb;
                int raise = this.checkScaleNonZero((long)mcp + (long)yscale2 - (long)xscale);
                CommonBigInteger commonBigInteger = rb = this.bigMultiplyPowerTen(xs, raise);
                Intrinsics.checkNotNull((Object)commonBigInteger);
                CommonBigInteger commonBigInteger2 = ys;
                Intrinsics.checkNotNull((Object)commonBigInteger2);
                quotient = this.divideAndRound(commonBigInteger, commonBigInteger2, scl, roundingMode, this.checkScaleNonZero(preferredScale));
            } else {
                int newScale = this.checkScaleNonZero((long)xscale - (long)mcp);
                int raise = this.checkScaleNonZero((long)newScale - (long)yscale2);
                CommonBigInteger rb = this.bigMultiplyPowerTen(ys, raise);
                CommonBigInteger commonBigInteger = xs;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                CommonBigInteger commonBigInteger3 = rb;
                Intrinsics.checkNotNull((Object)commonBigInteger3);
                quotient = this.divideAndRound(commonBigInteger, commonBigInteger3, scl, roundingMode, this.checkScaleNonZero(preferredScale));
            }
            return this.doRound(quotient, mc);
        }

        private final CommonBigDecimal multiplyDivideAndRound(long dividend0, long dividend1, long divisor, int scale, int roundingMode, int preferredScale) {
            long dividend02 = dividend0;
            long dividend12 = dividend1;
            long divisor2 = divisor;
            int qsign = MathKt.getSign((long)dividend02) * MathKt.getSign((long)dividend12) * MathKt.getSign((long)divisor2);
            dividend02 = Math.abs(dividend02);
            dividend12 = Math.abs(dividend12);
            divisor2 = Math.abs(divisor2);
            long d0_hi = dividend02 >>> 32;
            long d0_lo = dividend02 & 0xFFFFFFFFL;
            long d1_hi = dividend12 >>> 32;
            long d1_lo = dividend12 & 0xFFFFFFFFL;
            long product = d0_lo * d1_lo;
            long d0 = product & 0xFFFFFFFFL;
            long d1 = product >>> 32;
            product = d0_hi * d1_lo + d1;
            d1 = product & 0xFFFFFFFFL;
            long d2 = product >>> 32;
            product = d0_lo * d1_hi + d1;
            d1 = product & 0xFFFFFFFFL;
            long d3 = (d2 += product >>> 32) >>> 32;
            product = d0_hi * d1_hi + (d2 &= 0xFFFFFFFFL);
            d2 = product & 0xFFFFFFFFL;
            d3 = (product >>> 32) + d3 & 0xFFFFFFFFL;
            long dividendHi = this.make64(d3, d2);
            long dividendLo = this.make64(d1, d0);
            return this.divideAndRound128(dividendHi, dividendLo, divisor2, qsign, scale, roundingMode, preferredScale);
        }

        private final CommonBigDecimal divideAndRound128(long dividendHi, long dividendLo, long divisor, int sign, int scale, int roundingMode, int preferredScale) {
            long divisor2 = divisor;
            if (dividendHi >= divisor2) {
                return null;
            }
            int shift = Utils.numberOfLeadingZeros(divisor2);
            long v1 = (divisor2 <<= shift) >>> 32;
            long v0 = divisor2 & 0xFFFFFFFFL;
            long tmp = dividendLo << shift;
            long u1 = tmp >>> 32;
            long u0 = tmp & 0xFFFFFFFFL;
            tmp = dividendHi << shift | dividendLo >>> 64 - shift;
            long u2 = tmp & 0xFFFFFFFFL;
            long q1 = 0L;
            long r_tmp = 0L;
            if (v1 == 1L) {
                q1 = tmp;
                r_tmp = 0L;
            } else if (tmp >= 0L) {
                q1 = tmp / v1;
                r_tmp = tmp - q1 * v1;
            } else {
                long[] rq = this.divRemNegativeLong(tmp, v1);
                q1 = rq[1];
                r_tmp = rq[0];
            }
            while (q1 >= 0x100000000L || this.unsignedLongCompare(q1 * v0, this.make64(r_tmp, u1))) {
                long rq = q1;
                q1 = rq + -1L;
                if ((r_tmp += v1) < 0x100000000L) continue;
            }
            tmp = this.mulsub(u2, u1, v1, v0, q1);
            u1 = tmp & 0xFFFFFFFFL;
            long q0 = 0L;
            if (v1 == 1L) {
                q0 = tmp;
                r_tmp = 0L;
            } else if (tmp >= 0L) {
                q0 = tmp / v1;
                r_tmp = tmp - q0 * v1;
            } else {
                long[] rq = this.divRemNegativeLong(tmp, v1);
                q0 = rq[1];
                r_tmp = rq[0];
            }
            while (q0 >= 0x100000000L || this.unsignedLongCompare(q0 * v0, this.make64(r_tmp, u0))) {
                long rq = q0;
                q0 = rq + -1L;
                if ((r_tmp += v1) < 0x100000000L) continue;
            }
            if ((int)q1 < 0) {
                int[] nArray = new int[]{(int)q1, (int)q0};
                MutableBigInteger mq = new MutableBigInteger(nArray);
                if (roundingMode == RoundingMode.DOWN.getValue() && scale == preferredScale) {
                    return mq.toBigDecimal(sign, scale);
                }
                long r = this.mulsub(u1, u0, v1, v0, q0) >>> shift;
                if (r != 0L) {
                    if (this.needIncrement(divisor2 >>> shift, roundingMode, sign, mq, r)) {
                        mq.add(MutableBigInteger.Companion.getONE());
                    }
                    return mq.toBigDecimal(sign, scale);
                }
                if (preferredScale != scale) {
                    CommonBigInteger intVal = mq.toBigInteger(sign);
                    return this.createAndStripZerosToMatchScale(intVal, scale, (long)preferredScale);
                }
                return mq.toBigDecimal(sign, scale);
            }
            long q = this.make64(q1, q0);
            q *= (long)sign;
            if (roundingMode == RoundingMode.DOWN.getValue() && scale == preferredScale) {
                return this.of(q, scale);
            }
            long r = this.mulsub(u1, u0, v1, v0, q0) >>> shift;
            if (r != 0L) {
                boolean increment = this.needIncrement(divisor2 >>> shift, roundingMode, sign, q, r);
                return this.of(increment ? q + (long)sign : q, scale);
            }
            return preferredScale != scale ? this.createAndStripZerosToMatchScale(q, scale, (long)preferredScale) : this.of(q, scale);
        }

        private final CommonBigDecimal roundedTenPower(int qsign, int raise, int scale, int preferredScale) {
            if (scale > preferredScale) {
                int diff = scale - preferredScale;
                return diff < raise ? this.scaledTenPow$macrofocus_common(raise - diff, qsign, preferredScale) : this.of((long)qsign, scale - raise);
            }
            return this.scaledTenPow$macrofocus_common(raise, qsign, scale);
        }

        @NotNull
        public final CommonBigDecimal scaledTenPow$macrofocus_common(int n, int sign, int scale) {
            if (n < LONG_TEN_POWERS_TABLE.length) {
                return this.of((long)sign * LONG_TEN_POWERS_TABLE[n], scale);
            }
            CommonBigInteger unscaledVal = this.bigTenToThe(n);
            if (sign == -1) {
                unscaledVal = unscaledVal.unaryMinus();
            }
            return new CommonBigDecimal(unscaledVal, Long.MIN_VALUE, scale, n + 1);
        }

        private final long[] divRemNegativeLong(long n, long d) {
            long l;
            long r;
            if (!(n < 0L)) {
                boolean $i$a$-require-CommonBigDecimal$Companion$divRemNegativeLong$32 = false;
                String $i$a$-require-CommonBigDecimal$Companion$divRemNegativeLong$32 = "Non-negative numerator " + n;
                throw new IllegalArgumentException($i$a$-require-CommonBigDecimal$Companion$divRemNegativeLong$32.toString());
            }
            if (!(d != 1L)) {
                boolean bl = false;
                String string = "Unity denominator";
                throw new IllegalArgumentException(string.toString());
            }
            long q = (n >>> 1) / (d >>> 1);
            for (r = n - q * d; r < 0L; r += d) {
                l = q;
                q = l + -1L;
            }
            while (r >= d) {
                r -= d;
                l = q;
                q = l + 1L;
            }
            long[] lArray = new long[]{r, q};
            return lArray;
        }

        private final long make64(long hi, long lo) {
            return hi << 32 | lo;
        }

        private final long mulsub(long u1, long u0, long v1, long v0, long q0) {
            long tmp = u0 - q0 * v0;
            return this.make64(u1 + (tmp >>> 32) - q0 * v1, tmp & 0xFFFFFFFFL);
        }

        private final boolean unsignedLongCompare(long one, long two) {
            return one + Long.MIN_VALUE > two + Long.MIN_VALUE;
        }

        private final boolean unsignedLongCompareEq(long one, long two) {
            return one + Long.MIN_VALUE >= two + Long.MIN_VALUE;
        }

        private final int compareMagnitudeNormalized(long xs, int xscale, long ys, int yscale) {
            long xs2 = xs;
            long ys2 = ys;
            int sdiff = xscale - yscale;
            if (sdiff != 0) {
                if (sdiff < 0) {
                    xs2 = this.longMultiplyPowerTen(xs2, -sdiff);
                } else {
                    ys2 = this.longMultiplyPowerTen(ys2, sdiff);
                }
            }
            return xs2 != Long.MIN_VALUE ? (ys2 != Long.MIN_VALUE ? this.longCompareMagnitude(xs2, ys2) : -1) : 1;
        }

        private final int compareMagnitudeNormalized(long xs, int xscale, CommonBigInteger ys, int yscale) {
            if (xs == 0L) {
                return -1;
            }
            int sdiff = xscale - yscale;
            if (sdiff < 0 && this.longMultiplyPowerTen(xs, -sdiff) == Long.MIN_VALUE) {
                CommonBigInteger commonBigInteger = this.bigMultiplyPowerTen(xs, -sdiff);
                CommonBigInteger commonBigInteger2 = ys;
                Intrinsics.checkNotNull((Object)commonBigInteger2);
                return commonBigInteger.compareMagnitude$macrofocus_common(commonBigInteger2);
            }
            return -1;
        }

        private final int compareMagnitudeNormalized(CommonBigInteger xs, int xscale, CommonBigInteger ys, int yscale) {
            int n;
            int sdiff = xscale - yscale;
            if (sdiff < 0) {
                CommonBigInteger commonBigInteger = this.bigMultiplyPowerTen(xs, -sdiff);
                Intrinsics.checkNotNull((Object)commonBigInteger);
                CommonBigInteger commonBigInteger2 = ys;
                Intrinsics.checkNotNull((Object)commonBigInteger2);
                n = commonBigInteger.compareMagnitude$macrofocus_common(commonBigInteger2);
            } else {
                CommonBigInteger commonBigInteger = xs;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                CommonBigInteger commonBigInteger3 = this.bigMultiplyPowerTen(ys, sdiff);
                Intrinsics.checkNotNull((Object)commonBigInteger3);
                n = commonBigInteger.compareMagnitude$macrofocus_common(commonBigInteger3);
            }
            return n;
        }

        private final long multiply(long x, long y) {
            long ay;
            long product = x * y;
            long ax = Math.abs(x);
            return (ax | (ay = Math.abs(y))) >>> 31 == 0L || y == 0L || product / y == x ? product : Long.MIN_VALUE;
        }

        private final CommonBigDecimal multiply(long x, long y, int scale) {
            long product = this.multiply(x, y);
            return product != Long.MIN_VALUE ? this.of(product, scale) : new CommonBigDecimal(CommonBigInteger.Companion.of(x).timesLong$macrofocus_common(y), Long.MIN_VALUE, scale, 0);
        }

        private final CommonBigDecimal multiply(long x, CommonBigInteger y, int scale) {
            CommonBigDecimal commonBigDecimal;
            if (x == 0L) {
                commonBigDecimal = this.zeroValueOf$macrofocus_common(scale);
            } else {
                CommonBigInteger commonBigInteger = y;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                commonBigDecimal = new CommonBigDecimal(commonBigInteger.timesLong$macrofocus_common(x), Long.MIN_VALUE, scale, 0);
            }
            return commonBigDecimal;
        }

        private final CommonBigDecimal multiply(CommonBigInteger x, CommonBigInteger y, int scale) {
            CommonBigInteger commonBigInteger = y;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            return new CommonBigDecimal(x.times(commonBigInteger), Long.MIN_VALUE, scale, 0);
        }

        private final CommonBigDecimal multiplyAndRound(long x, long y, int scale, MathContext mc) {
            long mLo;
            long x2 = x;
            long y2 = y;
            long product = this.multiply(x2, y2);
            if (product != Long.MIN_VALUE) {
                return this.doRound(product, scale, mc);
            }
            int rsign = 1;
            if (x2 < 0L) {
                x2 = -x2;
                rsign = -1;
            }
            if (y2 < 0L) {
                y2 = -y2;
                rsign *= -1;
            }
            long m0_hi = x2 >>> 32;
            long m0_lo = x2 & 0xFFFFFFFFL;
            long m1_hi = y2 >>> 32;
            long m1_lo = y2 & 0xFFFFFFFFL;
            product = m0_lo * m1_lo;
            long m0 = product & 0xFFFFFFFFL;
            long m1 = product >>> 32;
            product = m0_hi * m1_lo + m1;
            m1 = product & 0xFFFFFFFFL;
            long m2 = product >>> 32;
            product = m0_lo * m1_hi + m1;
            m1 = product & 0xFFFFFFFFL;
            long m3 = (m2 += product >>> 32) >>> 32;
            m2 &= 0xFFFFFFFFL;
            product = m0_hi * m1_hi + m2;
            long mHi = this.make64(m3 = (product >>> 32) + m3 & 0xFFFFFFFFL, m2 = product & 0xFFFFFFFFL);
            CommonBigDecimal res = this.doRound128(mHi, mLo = this.make64(m1, m0), rsign, scale, mc);
            if (res != null) {
                return res;
            }
            res = new CommonBigDecimal(CommonBigInteger.Companion.of(x2).timesLong$macrofocus_common(y2 * (long)rsign), Long.MIN_VALUE, scale, 0);
            CommonBigDecimal commonBigDecimal = this.doRound(res, mc);
            Intrinsics.checkNotNull((Object)commonBigDecimal);
            return commonBigDecimal;
        }

        private final CommonBigDecimal multiplyAndRound(long x, CommonBigInteger y, int scale, MathContext mc) {
            CommonBigDecimal commonBigDecimal;
            if (x == 0L) {
                commonBigDecimal = this.zeroValueOf$macrofocus_common(scale);
            } else {
                CommonBigInteger commonBigInteger = y;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                commonBigDecimal = this.doRound(commonBigInteger.timesLong$macrofocus_common(x), scale, mc);
            }
            return commonBigDecimal;
        }

        private final CommonBigDecimal multiplyAndRound(CommonBigInteger x, CommonBigInteger y, int scale, MathContext mc) {
            CommonBigInteger commonBigInteger = y;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            return this.doRound(x.times(commonBigInteger), scale, mc);
        }

        private final CommonBigDecimal doRound128(long hi, long lo, int sign, int scale, MathContext mc) {
            int scale2 = scale;
            int mcp = mc.getPrecision();
            int drop = this.precision(hi, lo) - mcp;
            CommonBigDecimal res = null;
            if (drop > 0 && drop < LONG_TEN_POWERS_TABLE.length) {
                scale2 = this.checkScaleNonZero((long)scale2 - (long)drop);
                res = this.divideAndRound128(hi, lo, LONG_TEN_POWERS_TABLE[drop], sign, scale2, mc.getRoundingMode().getValue(), scale2);
            }
            return res != null ? this.doRound(res, mc) : null;
        }

        private final int precision(long hi, long lo) {
            if (hi == 0L) {
                if (lo >= 0L) {
                    return this.longDigitLength$macrofocus_common(lo);
                }
                return this.unsignedLongCompareEq(lo, LONGLONG_TEN_POWERS_TABLE[0][1]) ? 20 : 19;
            }
            int r = (128 - Utils.numberOfLeadingZeros(hi) + 1) * 1233 >>> 12;
            int idx = r - 19;
            return idx >= ((Object[])LONGLONG_TEN_POWERS_TABLE).length || this.longLongCompareMagnitude(hi, lo, LONGLONG_TEN_POWERS_TABLE[idx][0], LONGLONG_TEN_POWERS_TABLE[idx][1]) ? r : r + 1;
        }

        private final boolean longLongCompareMagnitude(long hi0, long lo0, long hi1, long lo1) {
            return hi0 != hi1 ? hi0 < hi1 : lo0 + Long.MIN_VALUE < lo1 + Long.MIN_VALUE;
        }

        private final CommonBigDecimal divide(long dividend, int dividendScale, long divisor, int divisorScale, int scale, int roundingMode) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                if (raise < LONG_TEN_POWERS_TABLE.length) {
                    long xs = dividend;
                    if ((xs = this.longMultiplyPowerTen(xs, raise)) != Long.MIN_VALUE) {
                        return this.divideAndRound(xs, divisor, scale, roundingMode, scale);
                    }
                    CommonBigDecimal q = this.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[raise], dividend, divisor, scale, roundingMode, scale);
                    if (q != null) {
                        return q;
                    }
                }
                CommonBigInteger scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                return this.divideAndRound(scaledDividend, divisor, scale, roundingMode, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            if (raise < LONG_TEN_POWERS_TABLE.length) {
                long ys = divisor;
                if ((ys = this.longMultiplyPowerTen(ys, raise)) != Long.MIN_VALUE) {
                    return this.divideAndRound(dividend, ys, scale, roundingMode, scale);
                }
            }
            CommonBigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            return this.divideAndRound(CommonBigInteger.Companion.of(dividend), scaledDivisor, scale, roundingMode, scale);
        }

        private final CommonBigDecimal divide(CommonBigInteger dividend, int dividendScale, long divisor, int divisorScale, int scale, int roundingMode) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                CommonBigInteger scaledDividend;
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                CommonBigInteger commonBigInteger = scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                Intrinsics.checkNotNull((Object)commonBigInteger);
                return this.divideAndRound(commonBigInteger, divisor, scale, roundingMode, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            if (raise < LONG_TEN_POWERS_TABLE.length) {
                long ys = divisor;
                if ((ys = this.longMultiplyPowerTen(ys, raise)) != Long.MIN_VALUE) {
                    CommonBigInteger commonBigInteger = dividend;
                    Intrinsics.checkNotNull((Object)commonBigInteger);
                    return this.divideAndRound(commonBigInteger, ys, scale, roundingMode, scale);
                }
            }
            CommonBigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            CommonBigInteger commonBigInteger = dividend;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            return this.divideAndRound(commonBigInteger, scaledDivisor, scale, roundingMode, scale);
        }

        private final CommonBigDecimal divide(long dividend, int dividendScale, CommonBigInteger divisor, int divisorScale, int scale, int roundingMode) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                CommonBigInteger scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                CommonBigInteger commonBigInteger = divisor;
                Intrinsics.checkNotNull((Object)commonBigInteger);
                return this.divideAndRound(scaledDividend, commonBigInteger, scale, roundingMode, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            CommonBigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            CommonBigInteger commonBigInteger = CommonBigInteger.Companion.of(dividend);
            CommonBigInteger commonBigInteger2 = scaledDivisor;
            Intrinsics.checkNotNull((Object)commonBigInteger2);
            return this.divideAndRound(commonBigInteger, commonBigInteger2, scale, roundingMode, scale);
        }

        private final CommonBigDecimal divide(CommonBigInteger dividend, int dividendScale, CommonBigInteger divisor, int divisorScale, int scale, int roundingMode) {
            if (this.checkScale(dividend, (long)scale + (long)divisorScale) > dividendScale) {
                CommonBigInteger scaledDividend;
                int newScale = scale + divisorScale;
                int raise = newScale - dividendScale;
                CommonBigInteger commonBigInteger = scaledDividend = this.bigMultiplyPowerTen(dividend, raise);
                Intrinsics.checkNotNull((Object)commonBigInteger);
                CommonBigInteger commonBigInteger2 = divisor;
                Intrinsics.checkNotNull((Object)commonBigInteger2);
                return this.divideAndRound(commonBigInteger, commonBigInteger2, scale, roundingMode, scale);
            }
            int newScale = this.checkScale(divisor, (long)dividendScale - (long)scale);
            int raise = newScale - divisorScale;
            CommonBigInteger scaledDivisor = this.bigMultiplyPowerTen(divisor, raise);
            CommonBigInteger commonBigInteger = dividend;
            Intrinsics.checkNotNull((Object)commonBigInteger);
            CommonBigInteger commonBigInteger3 = scaledDivisor;
            Intrinsics.checkNotNull((Object)commonBigInteger3);
            return this.divideAndRound(commonBigInteger, commonBigInteger3, scale, roundingMode, scale);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CommonBigDecimal of(@NotNull String val) {
            Intrinsics.checkNotNullParameter((Object)val, (String)"val");
            return com.macrofocus.common.math.big.CommonBigDecimal$Companion.of$default(this, val, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final CommonBigDecimal of(@NotNull CommonBigInteger val) {
            Intrinsics.checkNotNullParameter((Object)val, (String)"val");
            return com.macrofocus.common.math.big.CommonBigDecimal$Companion.of$default(this, val, null, 2, null);
        }

        private static final Object divide$lambda$0$0(RoundingMode $it) {
            return $it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/macrofocus/common/math/big/CommonBigDecimal$LongOverflow;", "", "<init>", "()V", "LONGMIN", "Lcom/macrofocus/common/math/big/CommonBigInteger;", "LONGMAX", "check", "", "num", "Lcom/macrofocus/common/math/big/CommonBigDecimal;", "macrofocus-common"})
    private static final class LongOverflow {
        @NotNull
        public static final LongOverflow INSTANCE = new LongOverflow();
        @NotNull
        private static final CommonBigInteger LONGMIN = CommonBigInteger.Companion.of(Long.MIN_VALUE);
        @NotNull
        private static final CommonBigInteger LONGMAX = CommonBigInteger.Companion.of(Long.MAX_VALUE);

        private LongOverflow() {
        }

        public final void check(@NotNull CommonBigDecimal num) {
            Intrinsics.checkNotNullParameter((Object)num, (String)"num");
            CommonBigInteger intVal = num.inflated();
            if (intVal.compareTo(LONGMIN) < 0 || intVal.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00060\u0003j\u0002`\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/common/math/big/CommonBigDecimal$StringBuilderHelper;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "compactCharArray", "", "<init>", "(Ljava/lang/StringBuilder;[C)V", "getSb", "()Ljava/lang/StringBuilder;", "getCompactCharArray", "()[C", "stringBuilder", "getStringBuilder", "putIntCompact", "", "intCompact", "", "Companion", "macrofocus-common"})
    public static final class StringBuilderHelper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final StringBuilder sb;
        @NotNull
        private final char[] compactCharArray;
        @NotNull
        private static final char[] DIGIT_TENS;
        @NotNull
        private static final char[] DIGIT_ONES;

        public StringBuilderHelper(@NotNull StringBuilder sb, @NotNull char[] compactCharArray) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter((Object)compactCharArray, (String)"compactCharArray");
            this.sb = sb;
            this.compactCharArray = compactCharArray;
        }

        public /* synthetic */ StringBuilderHelper(StringBuilder stringBuilder, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                stringBuilder = new StringBuilder();
            }
            if ((n & 2) != 0) {
                cArray = new char[19];
            }
            this(stringBuilder, cArray);
        }

        @NotNull
        public final StringBuilder getSb() {
            return this.sb;
        }

        @NotNull
        public final char[] getCompactCharArray() {
            return this.compactCharArray;
        }

        @NotNull
        public final StringBuilder getStringBuilder() {
            StringsKt.removeRange((CharSequence)this.sb, (int)0, (int)this.sb.length());
            return this.sb;
        }

        public final int putIntCompact(long intCompact) {
            long intCompact2 = intCompact;
            if (!(intCompact2 >= 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long q = 0L;
            int r = 0;
            int charPos = this.compactCharArray.length;
            while (intCompact2 > Integer.MAX_VALUE) {
                q = intCompact2 / (long)100;
                r = (int)(intCompact2 - q * (long)100);
                intCompact2 = q;
                this.compactCharArray[--charPos] = DIGIT_ONES[r];
                this.compactCharArray[--charPos] = DIGIT_TENS[r];
            }
            int q2 = 0;
            int i2 = (int)intCompact2;
            while (i2 >= 100) {
                q2 = i2 / 100;
                r = i2 - q2 * 100;
                i2 = q2;
                this.compactCharArray[--charPos] = DIGIT_ONES[r];
                this.compactCharArray[--charPos] = DIGIT_TENS[r];
            }
            this.compactCharArray[--charPos] = DIGIT_ONES[i2];
            if (i2 >= 10) {
                this.compactCharArray[--charPos] = DIGIT_TENS[i2];
            }
            return charPos;
        }

        public StringBuilderHelper() {
            this(null, null, 3, null);
        }

        static {
            char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
            DIGIT_TENS = cArray;
            cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
            DIGIT_ONES = cArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/math/big/CommonBigDecimal$StringBuilderHelper$Companion;", "", "<init>", "()V", "DIGIT_TENS", "", "getDIGIT_TENS", "()[C", "DIGIT_ONES", "getDIGIT_ONES", "macrofocus-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final char[] getDIGIT_TENS() {
                return DIGIT_TENS;
            }

            @NotNull
            public final char[] getDIGIT_ONES() {
                return DIGIT_ONES;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoundingMode.values().length];
            try {
                nArray[RoundingMode.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoundingMode.FLOOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoundingMode.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoundingMode.CEILING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoundingMode.HALF_DOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoundingMode.HALF_EVEN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoundingMode.HALF_UP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

