/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.scale;

import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.OpenInterval;
import com.macrofocus.common.scale.Probit;
import com.macrofocus.common.scale.Transform;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002Bq\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\"\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)\u00a8\u0006*"}, d2={"Lcom/macrofocus/common/scale/NumericTransform;", "Lcom/macrofocus/common/scale/Transform;", "", "shortName", "", "transform", "Lkotlin/Function1;", "", "inverse", "dtransform", "dinverse", "domain", "Lcom/macrofocus/common/interval/Interval;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/macrofocus/common/interval/Interval;)V", "getShortName", "()Ljava/lang/String;", "getTransform", "()Lkotlin/jvm/functions/Function1;", "getInverse", "getDtransform", "getDinverse", "getDomain", "()Lcom/macrofocus/common/interval/Interval;", "ASN", "ATANH", "ASINH", "EXP", "EXP2", "EXP10", "EXP1P", "IDENTITY", "LOG", "LOG2", "LOG10", "LOG1P", "PSEUDO_LOG", "LOGIT", "PROBIT", "RECIPROCAL", "REVERSE", "SQRT", "macrofocus-common"})
public final class NumericTransform
extends Enum<NumericTransform>
implements Transform {
    @NotNull
    private final String shortName;
    @NotNull
    private final Function1<Double, Double> transform;
    @Nullable
    private final Function1<Double, Double> inverse;
    @Nullable
    private final Function1<Double, Double> dtransform;
    @Nullable
    private final Function1<Double, Double> dinverse;
    @Nullable
    private final Interval domain;
    public static final /* enum */ NumericTransform ASN = new NumericTransform("asn", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$0), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$1), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$2), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$3), new OpenInterval(0.0, 1.0));
    public static final /* enum */ NumericTransform ATANH = new NumericTransform("atanh", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$4), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$5), null, null, new OpenInterval(-1.0, 2.0));
    public static final /* enum */ NumericTransform ASINH = new NumericTransform("asinh", (Function1<? super Double, Double>)((Function1)7.INSTANCE), (Function1<? super Double, Double>)((Function1)8.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$6), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$7), new OpenInterval(-1.0, 2.0));
    public static final /* enum */ NumericTransform EXP = new NumericTransform("exp", (Function1<? super Double, Double>)((Function1)11.INSTANCE), (Function1<? super Double, Double>)((Function1)12.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$8), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$9), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform EXP2 = new NumericTransform("exp2", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$10), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$11), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$12), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$13), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform EXP10 = new NumericTransform("exp10", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$14), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$15), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$16), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$17), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform EXP1P = new NumericTransform("expm1", (Function1<? super Double, Double>)((Function1)23.INSTANCE), (Function1<? super Double, Double>)((Function1)24.INSTANCE), (Function1<? super Double, Double>)((Function1)25.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$18), new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform IDENTITY = new NumericTransform("identity", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$19), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$20), null, null, new OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform LOG = new NumericTransform("log", (Function1<? super Double, Double>)((Function1)29.INSTANCE), (Function1<? super Double, Double>)((Function1)30.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$21), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$22), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform LOG2 = new NumericTransform("log2", (Function1<? super Double, Double>)((Function1)33.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$23), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$24), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$25), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform LOG10 = new NumericTransform("log10", (Function1<? super Double, Double>)((Function1)37.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$26), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$27), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$28), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform LOG1P = new NumericTransform("log1p", (Function1<? super Double, Double>)((Function1)41.INSTANCE), (Function1<? super Double, Double>)((Function1)42.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$29), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$30), new OpenInterval(1.0, Double.POSITIVE_INFINITY));
    public static final /* enum */ NumericTransform PSEUDO_LOG = new NumericTransform("pseudo_log", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$31), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$32), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$33), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$34), null);
    public static final /* enum */ NumericTransform LOGIT = new NumericTransform("logit", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$35), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$36), null, null, null);
    public static final /* enum */ NumericTransform PROBIT = new NumericTransform("probit", (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>((Object)Probit.INSTANCE){

        public final Double invoke(double p0) {
            return ((Probit)this.receiver).probit(p0);
        }
    }), null, null, null, null);
    public static final /* enum */ NumericTransform RECIPROCAL = new NumericTransform("reciprocal", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$37), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$38), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$39), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$40), null);
    public static final /* enum */ NumericTransform REVERSE = new NumericTransform("reverse", (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$41), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$42), null, null, null);
    public static final /* enum */ NumericTransform SQRT = new NumericTransform("sqrt", (Function1<? super Double, Double>)((Function1)58.INSTANCE), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$43), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$44), (Function1<? super Double, Double>)((Function1)NumericTransform::_init_$lambda$45), new OpenInterval(0.0, Double.POSITIVE_INFINITY));
    private static final /* synthetic */ NumericTransform[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private NumericTransform(String shortName, Function1<? super Double, Double> transform, Function1<? super Double, Double> inverse, Function1<? super Double, Double> dtransform, Function1<? super Double, Double> dinverse, Interval domain) {
        this.shortName = shortName;
        this.transform = transform;
        this.inverse = inverse;
        this.dtransform = dtransform;
        this.dinverse = dinverse;
        this.domain = domain;
    }

    @Override
    @NotNull
    public String getShortName() {
        return this.shortName;
    }

    @Override
    @NotNull
    public Function1<Double, Double> getTransform() {
        return this.transform;
    }

    @Override
    @Nullable
    public Function1<Double, Double> getInverse() {
        return this.inverse;
    }

    @Override
    @Nullable
    public Function1<Double, Double> getDtransform() {
        return this.dtransform;
    }

    @Override
    @Nullable
    public Function1<Double, Double> getDinverse() {
        return this.dinverse;
    }

    @Override
    @Nullable
    public Interval getDomain() {
        return this.domain;
    }

    public static NumericTransform[] values() {
        return (NumericTransform[])$VALUES.clone();
    }

    public static NumericTransform valueOf(String value) {
        return Enum.valueOf(NumericTransform.class, value);
    }

    @NotNull
    public static EnumEntries<NumericTransform> getEntries() {
        return $ENTRIES;
    }

    private static final double _init_$lambda$0(double x) {
        return 2.0 * Math.asin(Math.sqrt(x));
    }

    private static final double _init_$lambda$1(double y) {
        return 1.0 / Math.sqrt(y - Math.pow(y, 2.0));
    }

    private static final double _init_$lambda$2(double x) {
        return 1.0 / Math.sqrt(x - Math.pow(x, 2.0));
    }

    private static final double _init_$lambda$3(double y) {
        return Math.sin(y) / (double)2;
    }

    private static final double _init_$lambda$4(double x) {
        return 1.0 / (1.0 - Math.pow(x, 2.0));
    }

    private static final double _init_$lambda$5(double y) {
        return 1.0 / Math.pow(Math.cosh(y), 2.0);
    }

    private static final double _init_$lambda$6(double x) {
        return 1.0 / Math.sqrt(Math.pow(x, 2.0) + 1.0);
    }

    private static final double _init_$lambda$7(double y) {
        return Math.cosh(y);
    }

    private static final double _init_$lambda$8(double x) {
        return Math.pow(x, Math.E) * Math.log(Math.E);
    }

    private static final double _init_$lambda$9(double y) {
        return 1.0 / y / Math.log(Math.E);
    }

    private static final double _init_$lambda$10(double x) {
        return Math.pow(x, 2.0);
    }

    private static final double _init_$lambda$11(double y) {
        return Math.log(y) / Math.log(2.0);
    }

    private static final double _init_$lambda$12(double x) {
        return Math.pow(x, 2.0) * Math.log(2.0);
    }

    private static final double _init_$lambda$13(double y) {
        return 1.0 / y / Math.log(2.0);
    }

    private static final double _init_$lambda$14(double x) {
        return Math.pow(x, 10.0);
    }

    private static final double _init_$lambda$15(double y) {
        return Math.log10(y);
    }

    private static final double _init_$lambda$16(double x) {
        return Math.pow(x, 10.0) * Math.log(10.0);
    }

    private static final double _init_$lambda$17(double y) {
        return 1.0 / y / Math.log(10.0);
    }

    private static final double _init_$lambda$18(double y) {
        return 1.0 / (1.0 + y);
    }

    private static final double _init_$lambda$19(double x) {
        return x;
    }

    private static final double _init_$lambda$20(double y) {
        return y;
    }

    private static final double _init_$lambda$21(double x) {
        return 1.0 / x / Math.log(Math.E);
    }

    private static final double _init_$lambda$22(double y) {
        return Math.pow(y, Math.E) * Math.log(Math.E);
    }

    private static final double _init_$lambda$23(double y) {
        return Math.pow(y, 2.0);
    }

    private static final double _init_$lambda$24(double x) {
        return 1.0 / x / Math.log(2.0);
    }

    private static final double _init_$lambda$25(double y) {
        return Math.pow(y, 2.0) * Math.log(2.0);
    }

    private static final double _init_$lambda$26(double y) {
        return Math.pow(y, 10.0);
    }

    private static final double _init_$lambda$27(double x) {
        return 1.0 / x / Math.log(10.0);
    }

    private static final double _init_$lambda$28(double y) {
        return Math.pow(y, 10.0) * Math.log(10.0);
    }

    private static final double _init_$lambda$29(double x) {
        return 1.0 / (1.0 + x);
    }

    private static final double _init_$lambda$30(double y) {
        return Math.exp(y);
    }

    private static final double _init_$lambda$31(double x) {
        return MathKt.asinh((double)(x / 2.0)) / Math.log(Math.exp(1.0));
    }

    private static final double _init_$lambda$32(double y) {
        return 2.0 * Math.sinh(y * Math.log(Math.exp(1.0)));
    }

    private static final double _init_$lambda$33(double x) {
        return 1.0 / (Math.sqrt(4.0 + Math.pow(x, 2.0) / Math.pow(1.0, 2.0)) * 1.0 * Math.log(Math.exp(1.0)));
    }

    private static final double _init_$lambda$34(double y) {
        return 2.0 * Math.cosh(y * Math.log(Math.exp(1.0))) * Math.log(Math.exp(1.0));
    }

    private static final double _init_$lambda$35(double x) {
        return Math.log(x / (1.0 - x));
    }

    private static final double _init_$lambda$36(double y) {
        return 1.0 / (1.0 + Math.exp(y));
    }

    private static final double _init_$lambda$37(double x) {
        return 1.0 / x;
    }

    private static final double _init_$lambda$38(double y) {
        return 1.0 / y;
    }

    private static final double _init_$lambda$39(double x) {
        return -1.0 / Math.pow(x, 2.0);
    }

    private static final double _init_$lambda$40(double y) {
        return (double)-1 / Math.pow(y, 2.0);
    }

    private static final double _init_$lambda$41(double x) {
        return -x;
    }

    private static final double _init_$lambda$42(double y) {
        return -y;
    }

    private static final double _init_$lambda$43(double y) {
        return Math.pow(y, 2.0);
    }

    private static final double _init_$lambda$44(double x) {
        return 0.5 / Math.sqrt(x);
    }

    private static final double _init_$lambda$45(double y) {
        return 2.0 * y;
    }

    static {
        $VALUES = numericTransformArray = new NumericTransform[]{NumericTransform.ASN, NumericTransform.ATANH, NumericTransform.ASINH, NumericTransform.EXP, NumericTransform.EXP2, NumericTransform.EXP10, NumericTransform.EXP1P, NumericTransform.IDENTITY, NumericTransform.LOG, NumericTransform.LOG2, NumericTransform.LOG10, NumericTransform.LOG1P, NumericTransform.PSEUDO_LOG, NumericTransform.LOGIT, NumericTransform.PROBIT, NumericTransform.RECIPROCAL, NumericTransform.REVERSE, NumericTransform.SQRT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

