/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.transform;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.transform.AbstractMutableOneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\u000eB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u001dH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\t\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u0014\u0010(\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u0010-\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*\u00a8\u00061"}, d2={"Lcom/macrofocus/common/transform/ComplexOneDScreenTransform;", "Lcom/macrofocus/common/transform/AbstractMutableOneDScreenTransform;", "world", "Lcom/macrofocus/common/interval/BoundedInterval;", "x1", "", "x2", "<init>", "(Lcom/macrofocus/common/interval/BoundedInterval;II)V", "screenSize", "(Lcom/macrofocus/common/interval/BoundedInterval;I)V", "invertDeviceCoordinates", "", "invertWorldCoordinates", "(Lcom/macrofocus/common/interval/BoundedInterval;IZZ)V", "(Lcom/macrofocus/common/interval/BoundedInterval;IIZZ)V", "screenMargins", "getScreenMargins", "()I", "setScreenMargins", "(I)V", "getScreenSize", "setScreenSize", "value", "isWorldCoordinatesInverted", "()Z", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "screenToWorld", "", "screen", "worldToScreen", "worldToScreenPrecise", "worldInterval", "Lcom/macrofocus/common/interval/Interval;", "getWorldInterval", "()Lcom/macrofocus/common/interval/Interval;", "setWorldInterval", "", "isAffine", "worldMin", "getWorldMin", "()D", "worldMax", "getWorldMax", "worldRange", "getWorldRange", "toString", "", "macrofocus-common"})
public final class ComplexOneDScreenTransform
extends AbstractMutableOneDScreenTransform {
    @NotNull
    private BoundedInterval world;
    private final int x1;
    private final int x2;
    private int screenMargins;
    private int screenSize;
    private boolean invertDeviceCoordinates;
    private boolean isWorldCoordinatesInverted;
    @NotNull
    private final IntervalListener intervalListener;

    public ComplexOneDScreenTransform(@NotNull BoundedInterval world, int x1, int x2) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x1 = x1;
        this.x2 = x2;
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ ComplexOneDScreenTransform this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(IntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.notifyTransformChanged(new ScreenTransformEvent());
            }
        };
        this.setScreenSize(this.x2 - this.x1);
        this.world.addWeakIntervalListener(this.intervalListener);
        this.setScreenSize(this.getScreenSize());
    }

    @Override
    public int getScreenMargins() {
        return this.screenMargins;
    }

    @Override
    public void setScreenMargins(int screenMargins) {
        if (this.screenMargins != screenMargins) {
            this.screenMargins = screenMargins;
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    @Override
    public int getScreenSize() {
        return this.screenSize;
    }

    @Override
    public void setScreenSize(int screenSize) {
        if (this.screenSize != screenSize) {
            this.screenSize = screenSize;
            this.notifyTransformChanged(new ScreenTransformEvent());
        }
    }

    @Override
    public boolean isWorldCoordinatesInverted() {
        return this.isWorldCoordinatesInverted;
    }

    public ComplexOneDScreenTransform(@NotNull BoundedInterval world, int screenSize) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, 0, screenSize);
    }

    public ComplexOneDScreenTransform(@NotNull BoundedInterval world, int screenSize, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, screenSize);
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.isWorldCoordinatesInverted = invertWorldCoordinates;
    }

    public ComplexOneDScreenTransform(@NotNull BoundedInterval world, int x1, int x2, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world, x1, x2);
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.isWorldCoordinatesInverted = invertWorldCoordinates;
    }

    @Override
    public double screenToWorld(int screen) {
        double normalized = 0.0;
        normalized = (double)(screen - this.x1 - this.getScreenMargins() / 2) / (double)(this.getScreenSize() - this.getScreenMargins());
        if (this.invertDeviceCoordinates) {
            normalized = 1.0 - normalized;
        }
        if (this.isWorldCoordinatesInverted()) {
            normalized = 1.0 - normalized;
        }
        normalized = normalized * this.getWorldRange() + this.getWorldMin();
        return normalized;
    }

    @Override
    public int worldToScreen(double world) {
        return (int)this.worldToScreenPrecise(world);
    }

    @Override
    public double worldToScreenPrecise(double world) {
        return this.isWorldCoordinatesInverted() ^ this.invertDeviceCoordinates ? (this.getWorldMax() - world) * (double)(this.getScreenSize() - this.getScreenMargins()) / this.getWorldRange() + (double)this.getScreenMargins() / 2.0 + (double)this.x1 : (world - this.getWorldMin()) * (double)(this.getScreenSize() - this.getScreenMargins()) / this.getWorldRange() + (double)this.getScreenMargins() / 2.0 + (double)this.x1;
    }

    @Override
    @NotNull
    public Interval getWorldInterval() {
        return this.world;
    }

    @Override
    public void setWorldInterval(@NotNull BoundedInterval world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world.removeIntervalListener(this.intervalListener);
        this.world = world;
        this.world.addIntervalListener(this.intervalListener);
        this.notifyTransformChanged(new ScreenTransformEvent());
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public double getWorldMin() {
        return this.isWorldCoordinatesInverted() ? this.world.getMinimum() + (this.world.getMaximum() - (this.world.getStart() + this.world.getExtent())) : this.world.getStart();
    }

    @Override
    public double getWorldMax() {
        return this.isWorldCoordinatesInverted() ? this.world.getMinimum() + (this.world.getMaximum() - this.world.getStart()) : this.world.getStart() + this.world.getExtent();
    }

    @Override
    public double getWorldRange() {
        return this.world.getExtent();
    }

    @NotNull
    public String toString() {
        return "ComplexOneDScreenTransform{world=" + this.world + ", screenMargins=" + this.getScreenMargins() + ", x1=" + this.x1 + ", x2=" + this.x2 + ", screenSize=" + this.getScreenSize() + ", invertDeviceCoordinates=" + this.invertDeviceCoordinates + ", invertWorldCoordinates=" + this.isWorldCoordinatesInverted() + "}";
    }
}

