/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.filter

/**
 * This class provides a skeletal implementation of the MutableFilter interface to minimize the effort required to implement this interface.
 */
abstract class AbstractMutableFilter<E> : AbstractFilter<E>(), MutableFilter<E> {
    override var isEnabled: Boolean = true
        get() = field
        set(enabled) {if (!enabled) {
            if (isActive) {
                clearFilter()
            }
        }
            super<AbstractFilter>.isEnabled = enabled
        }
}