/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * The listener interface for receiving "interesting" events about a selection.
 *
 * @param <E> the type of elements that can be selected
</E> */
interface SelectionListener<E> {
    /**
     * Called whenever the value of the selection changes.
     *
     * @param event the event that characterizes the change.
     */
    fun selectionChanged(event: SelectionEvent<E>)
}