package com.macrofocus.common.units

open class Current(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val Ampere = Current("Ampere", "A", 1.0)
        val Statampere = Current("Statampere", "statA", 3.335641e-10)
    }
}

val Number.Ampere: Quantity<Current> get() = Quantity(this.toDouble(), Current.Ampere)
val Number.Statampere: Quantity<Current> get() = Quantity(this.toDouble(), Current.Statampere)

