/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

/**
 * The listener interface for receiving "interesting" events (insertion, change, removal) about a hierarchy.
 */
interface HierarchyListener<T> {
    fun hierarchyNodeInserted(event: HierarchyEvent<T>)
    fun hierarchyNodeChanged(event: HierarchyEvent<T>)
    fun hierarchyNodeRemoved(event: HierarchyEvent<T>)
    fun hierarchyStructureChanged(event: HierarchyEvent<T>)
}