package com.macrofocus.common.interval

import com.macrofocus.common.properties.Property

/**
 * / ** This interface represents the current state of an interval.
 */
actual interface Interval {
    actual val startProperty: Property<Double>
    actual val endProperty: Property<Double>
    actual val start: Double
    actual val end: Double
    actual val extent: Double

    /**
     * Tests if this interval contains the specified value
     *
     * @param value the value to test
     * @return true if the interval contains the value, false otherwise
     */
    actual operator fun contains(value: Double): Boolean

    /**
     * Tests if this interval contains the specified interval
     *
     * @param start the value to test
     * @param end the value to test
     * @return true if the interval contains the value, false otherwise
     */
    actual fun containsStartEnd(start: Double, end: Double): Boolean

    /**
     * Tests if this interval contains the specified interval
     *
     * @param interval the interval to test
     * @return true if the interval contains the value, false otherwise
     */
    actual fun containsInterval(interval: Interval?): Boolean

    /**
     * Tests if this interval overlaps the specified interval.
     *
     * @param start the interval to test
     * @param end the interval to test
     * @return true if this interval overlaps the specified interval, false otherwise
     */
    actual fun overlaps(start: Double, end: Double): Boolean

    /**
     * Tests if this interval overlaps the specified interval.
     *
     * @param interval the interval to test
     * @return true if this interval overlaps the specified interval, false otherwise
     */
    actual fun overlapsInterval(interval: Interval?): Boolean

    /**
     * Tests whether the starting and ending values are the same
     *
     * @return true if start and end values are identical, false otherwise
     */
    actual val isDegenerate: Boolean
    actual val isInverted: Boolean
    actual fun addIntervalListener(listener: IntervalListener)
    actual fun addWeakIntervalListener(listener: IntervalListener)
    actual fun removeIntervalListener(listener: IntervalListener)
    actual fun removeIntervalListeners()

}