package com.macrofocus.common.concurrent

import com.macrofocus.common.command.Future

expect open class ExecutorService {
    /**
     * Submits a value-returning task for execution and returns a
     * Future representing the pending results of the task. The
     * Future's `get` method will return the task's result upon
     * successful completion.
     *
     *
     *
     * If you would like to immediately block waiting
     * for a task, you can use constructions of the form
     * `result = exec.submit(aCallable).get();`
     *
     *
     * Note: The [Executors] class includes a set of methods
     * that can convert some other common closure-like objects,
     * for example, [java.security.PrivilegedAction] to
     * [Callable] form so they can be submitted.
     *
     * @param task the task to submit
     * @param <T> the type of the task's result
     * @return a Future representing pending completion of the task
     * @throws RejectedExecutionException if the task cannot be
     * scheduled for execution
     * @throws NullPointerException if the task is null
    </T> */
    fun <T> submit(task: Callable<T>?): Future<T>?

    /**
     * Executes the given tasks, returning a list of Futures holding
     * their status and results when all complete.
     * [Future.isDone] is `true` for each
     * element of the returned list.
     * Note that a *completed* task could have
     * terminated either normally or by throwing an exception.
     * The results of this method are undefined if the given
     * collection is modified while this operation is in progress.
     *
     * @param tasks the collection of tasks
     * @param <T> the type of the values returned from the tasks
     * @return a list of Futures representing the tasks, in the same
     * sequential order as produced by the iterator for the
     * given task list, each of which has completed
     * @throws InterruptedException if interrupted while waiting, in
     * which case unfinished tasks are cancelled
     * @throws NullPointerException if tasks or any of its elements are `null`
     * @throws RejectedExecutionException if any task cannot be
     * scheduled for execution
    </T> */
    fun <T> invokeAll(tasks: Collection<Callable<T>>): List<Future<T>>

    /**
     * Initiates an orderly shutdown in which previously submitted
     * tasks are executed, but no new tasks will be accepted.
     * Invocation has no additional effect if already shut down.
     *
     *
     * This method does not wait for previously submitted tasks to
     * complete execution.  Use [awaitTermination][.awaitTermination]
     * to do that.
     *
     * @throws SecurityException if a security manager exists and
     * shutting down this ExecutorService may manipulate
     * threads that the caller is not permitted to modify
     * because it does not hold [         ]`("modifyThread")`,
     * or the security manager's `checkAccess` method
     * denies access.
     */
    fun shutdown()
}