package com.macrofocus.common.math

inline fun Double?.clampNormalize(value: Double?, minValue: Double, maxValue: Double, minNew : Double, maxNew : Double) =
    value?.clampNormalize(minValue, maxValue, minNew, maxNew)

inline fun Double.clampNormalize(minValue: Double, maxValue: Double, minNew : Double = 0.0, maxNew : Double = 1.0) =
    clamp(normalize(this, minValue, maxValue, minNew, maxNew), minNew, maxNew)

inline fun normalize(value: Double, minValue: Double, maxValue: Double, minNew : Double, maxNew : Double) =
    minNew + ((value - minValue) * (maxNew - minNew) / (maxValue - minValue))

inline fun clamp(x: Double, min: Double, max: Double) =
    if (x < min) min else (if (x > max) max else x)
