/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.timer

abstract class AbstractTimer : Timer {
    protected val actionListeners: MutableList<Timer.TimerListener>
    override fun addActionListener(listener: Timer.TimerListener) {
        actionListeners.add(listener)
    }

    override fun removeActionListener(listener: Timer.TimerListener) {
        actionListeners.remove(listener)
    }

    protected fun fireTimerTriggered() {
        for (listener in actionListeners) {
            listener.timerTriggered()
        }
    }

    init {
        actionListeners = ArrayList<Timer.TimerListener>()
    }
}