/*
 * Copyright (c) 2000-2005 Macrofocus GmbH. All Rights Reserved.
 *
 */
package com.macrofocus.common.timer

import com.macrofocus.common.concurrent.Runnable

interface Timer : Runnable {
    fun restart()
    fun addActionListener(listener: TimerListener)
    fun removeActionListener(listener: TimerListener)
    fun stop()
    val isScheduled: Boolean

    interface TimerListener {
        fun timerTriggered()
    }
}