package com.macrofocus.common.units

open class ReactivePower(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val VoltAmpereReactive = ReactivePower("Volt-ampere reactive", "var", 1.0)
        val KilovoltAmpereReactive = ReactivePower("Kilovolt-ampere reactive", "kvar", 1000.0)
        val MegavoltAmpereReactive = ReactivePower("Megavolt-ampere reactive", "Mvar", 1000000.0)
    }
}

val Number.VoltAmpereReactive: Quantity<ReactivePower> get() = Quantity(this.toDouble(), ReactivePower.VoltAmpereReactive)
val Number.KilovoltAmpereReactive: Quantity<ReactivePower> get() = Quantity(this.toDouble(), ReactivePower.KilovoltAmpereReactive)
val Number.MegavoltAmpereReactive: Quantity<ReactivePower> get() = Quantity(this.toDouble(), ReactivePower.MegavoltAmpereReactive)
