/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

internal class PostorderEnumeration<T>(hierarchy: Hierarchy<T>, rootNode: T) : MutableIterator<T> {
    protected var root: T?
    protected var children: Iterator<T>? = null
    protected var subtree: Iterator<T>
    private val hierarchy: Hierarchy<T>
    override fun hasNext(): Boolean {
        return root != null
    }

    override fun next(): T {
        val retval: T
        if (subtree.hasNext()) {
            retval = subtree.next()
        } else if (children!!.hasNext()) {
            subtree = PostorderEnumeration(hierarchy, children!!.next())
            retval = subtree.next()
        } else {
            retval = root!!
            root = null
        }
        return retval
    }

    override fun remove() {
        throw UnsupportedOperationException()
    }

    init {
        this.hierarchy = hierarchy
        root = rootNode
        val iterable = hierarchy.getChildren(root!!)
        if (iterable == null) {
            println("No children for $root")
            children = emptyList<T>().iterator()
        } else {
            children = iterable.iterator()
        }
        subtree = emptyList<T>().iterator()
    }
}