package com.macrofocus.common.timing

import com.macrofocus.common.crossplatform.CPHelper

actual class Timing {
    private var start: Long = 0
    private var end: Long = 0

    private var _lastDuration = 0L
    private var duration = 0L
    private var count = 0

    actual val lastDuration: Long
        get() = _lastDuration

    actual val averageDuration: Long
        get() = duration / count

    actual val fps : Int
        get() {
            if(lastDuration > 0) {
                return (1000L / lastDuration).toInt()
            } else {
                return 1000
            }
        }

    actual fun start() {
        start = CPHelper.instance.currentTimeMillis
    }

    actual fun stop() {
        end = CPHelper.instance.currentTimeMillis

        _lastDuration = (end - start).toLong()
        duration += _lastDuration
        count++
    }

    actual fun print() {
        println(toString())
    }

    override fun toString(): String {
        return "Timing(lastDuration=$lastDuration, fps=$fps, averageDuration=$averageDuration)"
    }
}