package com.macrofocus.common.json

/**
 * Base interface for all Json values.
 */
expect interface JsonValue {
}

/**
 * Coerces underlying value to boolean according to the rules of Javascript coercion.
 */
expect fun JsonValue.asBoolean(): Boolean

    /**
     * Coerces the underlying value to a number according to the rules of Javascript coercion.
     */
expect fun JsonValue.asNumber(): Double

    /**
     * Coerces the underlying value to a String according to the rules of JavaScript coercion.
     */
expect fun JsonValue.asString(): String?

expect fun JsonValue.asJsonArray(): JsonArray?

expect fun JsonValue.asJsonObject(): JsonObject?


    /**
     * Returns an enumeration representing the fundamental JSON type.
     */
expect val JsonValue.type: JsonType

    /**
     * Returns a serialized JSON string representing this value.
     * @return
     */
expect fun JsonValue.toJson(): String?

    /**
     * Equivalent of Javascript '==' operator comparison between two values.
     */
expect fun JsonValue.jsEquals(value: JsonValue?): Boolean

    /**
     * If used in a GWT context (dev or prod mode), converts the object to a native JavaScriptObject
     * suitable for passing to JSNI methods. Otherwise, returns the current object in other contexts,
     * such as server-side use.
     */
expect fun JsonValue.toNative(): Any?
