/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.persistence

class DefaultElement(override val localName: String) : Element {
    private val elemens: DefaultElements = DefaultElements()
    private val attributes: MutableList<Attribute> = ArrayList<Attribute>()
    private val map: MutableMap<String, Attribute> = HashMap<String, Attribute>()
    override val attributeCount: Int
        get() = attributes.size

    override fun getAttribute(index: Int): Attribute {
        return attributes[index]
    }

    override fun getAttribute(key: String): Attribute {
        return map[key]!!
    }

    override val childElements: Elements?
        get() = elemens

    override fun getAttributeValue(key: String): String {
        return getAttribute(key).value
    }

    override fun addAttribute(attribute: Attribute) {
        attributes.add(attribute)
        map[attribute.qualifiedName] = attribute
    }

    override fun appendChild(element: Element) {
        elemens.appendChild(element)
    }
}