package com.macrofocus.common.units

import com.macrofocus.common.math.convertDegreesToRadians
import kotlin.math.PI
import kotlin.test.Test
import kotlin.test.assertEquals

class PhaseAngleTest {
    @Test
    fun conversionTest() {
        assertEquals((180.0.Degree + PI.into(PhaseAngle.Radian)).into(PhaseAngle.Radian).amount, PI * 2.0)

        assertEquals(90.0.Degree.into(PhaseAngle.Radian).amount, convertDegreesToRadians(90.0))
    }
}
