package com.macrofocus.common.crossplatform

import com.macrofocus.common.concurrent.ExecutorService
import com.macrofocus.common.timer.CPTimer
import com.macrofocus.common.timer.CPTimerListener
import kotlin.js.Date
import kotlin.reflect.KClass

actual class CPHelper {
    actual companion object {
        actual val instance = CPHelper()
    }

    actual fun visualizationExecutorService(): ExecutorService? {
        return null
    }

    actual fun newFixedThreadPool(
        name: String,
        corePoolSize: Int,
        maximumPoolSize: Int
    ): ExecutorService? {
        return null
    }

    actual fun createTimer(
        name: String,
        delay: Int,
        postponing: Boolean
    ): CPTimer {
        return GWTTimer(name, delay, postponing)
    }

    actual fun createTimer(
        name: String,
        delay: Int,
        postponing: Boolean,
        timerListener: CPTimerListener
    ): CPTimer {
        val timer = createTimer(name, delay, postponing)
        timer.addTimerListener(timerListener)
        return timer
    }

    /**
     * Causes the currently executing thread to sleep (temporarily cease
     * execution) for the specified number of milliseconds, subject to
     * the precision and accuracy of system timers and schedulers. The thread
     * does not lose ownership of any monitors.
     *
     * @param  millis
     * the length of time to sleep in milliseconds
     *
     * @throws  IllegalArgumentException
     * if the value of `millis` is negative
     *
     * @throws  InterruptedException
     * if any thread has interrupted the current thread. The
     * *interrupted status* of the current thread is
     * cleared when this exception is thrown.
     */
    actual fun sleep(millis: Long) {
    }

    actual fun isAssignableFrom(a: KClass<*>, b: KClass<*>): Boolean {
        return a == b
    }

    actual fun isNumericType(cl: KClass<*>): Boolean {
        return cl != null && (isAssignableFrom(Number::class, cl)
                || cl == Double::class || cl == Int::class || cl == Float::class || cl == Short::class || cl == Long::class)
    }

    actual fun isTemporalType(cl: KClass<*>): Boolean {
        TODO("Not yet implemented")
//        return cl != null && (isAssignableFrom(java.util.Date::class.java, cl)
//                || cl == Double::class || cl == Long::class)
    }

    actual fun isVisualType(cl: KClass<*>): Boolean {
        return false
    }

    actual fun isArray(cl: KClass<*>): Boolean {
        return Array::class == cl
    }

    actual val isMac: Boolean = false

    /** Current UNIX time in millis */
    actual val currentTimeMillis: Long
        get() = Date.now().toLong()
}