package com.macrofocus.common.properties

abstract class AbstractMutableListProperty<T> : AbstractListProperty<T>(), MutableListProperty<T> {
    fun bind(source: Property<List<out T>?>) {
        val binding: PropertyListener<List<out T>?> = object : PropertyListener<List<out T>?> {
            override fun propertyChanged(event: PropertyEvent<List<out T>?>) {
                value = event.newValue
            }
        }
        source.addPropertyListener(binding)
        value = source.value
    }

    fun bindBidirectional(source: MutableProperty<List<out T>?>) {
        source.addPropertyListener(object : PropertyListener<List<out T>?> {
            override fun propertyChanged(event: PropertyEvent<List<out T>?>) {
                value = event.newValue
            }
        })
        addPropertyListener(object : PropertyListener<List<out T>?> {
            override fun propertyChanged(event: PropertyEvent<List<out T>?>) {
                source.value = event.newValue
            }
        })
        value = source.value
    }
}
