package com.macrofocus.common.json

import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNotNull
import kotlin.test.assertTrue

class JsonFactoryTest {
    @Test
    fun parseNumberObjectTest() {
        val `object` = JSON.parse<JsonValue>("{\"a\": 0, \"b\": 1, \"c\": 2.1}")
        assertEquals(JsonType.OBJECT, `object`.type)
        val jsonObject = `object`.asJsonObject()
        assertNotNull(jsonObject)
//        assertEquals(3, jsonObject.keys().size)
        assertEquals(0.0, jsonObject.getNumber("a"))
        assertEquals(1.0, jsonObject.getNumber("b"))
        assertEquals(2.1, jsonObject.getNumber("c"))
    }

    @Test
    fun createObjectTest() {
        val jsonObject = JsonFactory.createObject()
        jsonObject.put("a", "Ford" )
        jsonObject.put("b", 100.1)
        jsonObject.put("c", true)
        jsonObject.put("d", null)
        assertEquals(JsonType.OBJECT, jsonObject.type)
        assertNotNull(jsonObject)
        assertEquals(4, jsonObject.keys().size)
        assertTrue(jsonObject.hasKey("a"))
        assertTrue(jsonObject.hasKey("b"))
        assertTrue(jsonObject.hasKey("c"))
        assertTrue(jsonObject.hasKey("d"))
        assertEquals("Ford", jsonObject.getString("a"))
        assertEquals(100.1, jsonObject.getNumber("b"))
        assertEquals(true, jsonObject.getBoolean("c"))
        assertEquals(JsonType.NULL, jsonObject.get<JsonValue>("d").type)
    }

    @Test
    fun parseStringArrayTest() {
        val array = JSON.parse<JsonValue>("[ \"Ford\", \"BMW\", \"Fiat\" ]")
        assertEquals(JsonType.ARRAY, array.type)
        val jsonArray = array.asJsonArray()
        assertNotNull(jsonArray)
        assertEquals(3, jsonArray.length())
        assertEquals("Ford", jsonArray.getString(0))
        assertEquals("BMW", jsonArray.getString(1))
        assertEquals("Fiat", jsonArray.getString(2))
    }

    @Test
    fun parseArrayTest() {
        val array = JSON.parse<JsonValue>("[ \"Ford\", 100.1, true, null ]")
        assertEquals(JsonType.ARRAY, array.type)
        val jsonArray = array.asJsonArray()
        assertNotNull(jsonArray)
        assertEquals(4, jsonArray.length())
        assertEquals("Ford", jsonArray.getString(0))
        assertEquals(100.1, jsonArray.getNumber(1))
        assertEquals(true, jsonArray.getBoolean(2))
        assertEquals(JsonType.NULL, jsonArray.get<JsonValue>(3).type)
    }

    @Test
    fun createArrayTest() {
        val jsonArray = JsonFactory.createArray()
        jsonArray.set(0, "Ford" )
        jsonArray.set(1, 100.1)
        jsonArray.set(2, true)
        jsonArray.set(3, null)
        assertEquals(JsonType.ARRAY, jsonArray.type)
        assertNotNull(jsonArray)
        assertEquals(4, jsonArray.length())
        assertEquals("Ford", jsonArray.getString(0))
        assertEquals(100.1, jsonArray.getNumber(1))
        assertEquals(true, jsonArray.getBoolean(2))
        assertEquals(JsonType.NULL, jsonArray.get<JsonValue>(3).type)
    }

    @Test
    fun parseNullTest() {
        val json = JSON.parse<JsonValue>("[ \"Ford\", \"BMW\", null ]")
//        assertIs<JsonArray>(json)
//        assertNull((json as JsonArray)[2])
    }

    @Test
    fun stringTest() {
        assertEquals("Test", JsonFactory.create("Test").asString())
        assertEquals(JsonType.STRING, JsonFactory.create("Test").type)
    }

    @Test
    fun numberTest() {
        assertEquals(10.1, JsonFactory.create(10.1).asNumber())
        assertEquals(JsonType.NUMBER, JsonFactory.create(10.1).type)
    }

    @Test
    fun booleanTest() {
        assertEquals(true, JsonFactory.create(true).asBoolean())
        assertEquals(JsonType.BOOLEAN, JsonFactory.create(true).type)
    }

    @Test
    fun nullTest() {
        assertEquals(null, JsonFactory.createNull().toNative())
    }

    @Test
    fun arrayTest() {
        assertEquals(0, JsonFactory.createArray().length())
        assertEquals(3, JSON.parse<JsonValue>("[ \"Ford\", \"BMW\", \"Fiat\" ]").asJsonArray()?.length())
    }

//    @Test
//    fun objectTest() {
//        assertEquals(0, JsonFactory().createObject().keys().size)
//    }
}