package com.macrofocus.common.transform

import com.macrofocus.common.interval.SimpleBoundedInterval
import kotlin.test.Test
import kotlin.test.assertEquals

class OneDTransformTest {
    @Test
    fun test() {
        val xRangeModel = SimpleBoundedInterval(-180.0, 360.0, -180.0, 180.0)
        val yRangeModel = SimpleBoundedInterval(-90.0, 180.0, -90.0, 90.0)
//    val xRangeModel = SimpleBoundedInterval(5.0, 6.0, 5.0, 11.0)
//    val yRangeModel = SimpleBoundedInterval(45.0, 3.0, 45.0, 48.0)

        val xt = SimpleOneDScreenTransform(xRangeModel, 100)
        val yt = SimpleOneDScreenTransform(yRangeModel, 100)

        val xMin = -180
        val tx1 = (-90 - xMin) * xt.screenSize / 360.0
        val tx2 = (90 - xMin) * xt.screenSize / 360.0
        val yMin = -90
        val ty1 = (45 - yMin) * yt.screenSize / 180.0
        val ty2 = (-45 - yMin) * yt.screenSize / 180.0

        val x1 = xt.worldToScreenPrecise(-90.0)
        val y1 = yt.worldToScreenPrecise(45.0)
        val x2 = xt.worldToScreenPrecise(90.0)
        val y2 = yt.worldToScreenPrecise(-45.0)

        assertEquals(tx1, x1)
        assertEquals(tx2, x2)
        assertEquals(ty1, y1)
        assertEquals(ty2, y2)
    }
}