package com.macrofocus.common.units

import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNotEquals

class ElectricityTest {
    @Test
    fun conversion() {
        val watt = 100000.Watt
        val kilowatt = 100.Kilowatt
        val megawatt = 0.1.Megawatt
        val horsepower = 100.Kilowatt.into(Power.Horsepower)

        assertEquals(watt, kilowatt)
        assertEquals(watt, megawatt)
        assertEquals(kilowatt, megawatt)
        assertEquals(kilowatt, horsepower)
        assertEquals(kilowatt, 135.96216173039045.Horsepower)
    }

    @Suppress("TYPE_INFERENCE_ONLY_INPUT_TYPES_WARNING")
    @Test
    fun notEquals() {
        assertNotEquals<Quantity<out Unit>>(1.Watt, 1.Ampere)
        assertNotEquals<Quantity<out Unit>>(1.Watt, 1.Volt)
        assertNotEquals<Quantity<out Unit>>(1.Ampere, 1.Volt)
    }

    @Test
    fun formula() {
        assertEquals(10.Watt, power(5.Volt, 2.Ampere, Power.Watt))

        val voltage = 5.Volt
        val current = 2.Ampere
        val power = 10.Watt

        assertEquals(power, power(voltage, current))

        assertEquals(700.Watt, activePower(1000.4811735403881.VoltAmpere, 45.6.Degree))

        assertEquals(1000.4811735403881.VoltAmpere, apparentPower1(700.Watt, 45.6.Degree))
        assertEquals(1000.4811735403881.VoltAmpere, apparentPower2(700.Watt, 714.8164649815728.VoltAmpereReactive))

        assertEquals(714.8164649815728.VoltAmpereReactive, reactivePower(1000.4811735403881.VoltAmpere, 45.6.Degree))

        assertEquals(0.6996633405133654, powerFactor(45.6.Degree))
    }
}