package com.macrofocus.common.json

/**
 * A [JsonContext] with integer based location context.
 */
internal class JsonArrayContext(array: JsonArray) : JsonContext(array) {
    var currentIndex = 0
    fun array(): JsonArray {
        return getValue() as JsonArray
    }

    override fun removeMe() {
        array().remove(currentIndex)
    }

    override fun replaceMe(d: Double) {
        array().set(currentIndex, d)
    }

    override fun replaceMe(d: String) {
        array().set(currentIndex, d)
    }

    override fun replaceMe(d: Boolean) {
        array().set(currentIndex, d)
    }

    override fun replaceMe(value: JsonValue?) {
        array().set(currentIndex, value)
    }
}