/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.macrofocus.common.json

/**
 * JRE (non-Client) implementation of JreJsonValue.
 */
actual interface JsonValue {
    /**
     * Coerces underlying value to boolean according to the rules of Javascript coercion.
     */
    fun asBoolean(): Boolean

    /**
     * Coerces the underlying value to a number according to the rules of Javascript coercion.
     */
    fun asNumber(): Double

    /**
     * Coerces the underlying value to a String according to the rules of JavaScript coercion.
     */
    fun asString(): String?

    fun asJsonArray(): JsonArray?

    fun asJsonObject(): JsonObject?

    /**
     * Returns an enumeration representing the fundamental JSON type.
     */
    val type: JsonType

    /**
     * Returns a serialized JSON string representing this value.
     * @return
     */
    fun toJson(): String?

    /**
     * Equivalent of Javascript '==' operator comparison between two values.
     */
    fun jsEquals(value: JsonValue?): Boolean

    /**
     * If used in a GWT context (dev or prod mode), converts the object to a native JavaScriptObject
     * suitable for passing to JSNI methods. Otherwise, returns the current object in other contexts,
     * such as server-side use.
     */
    fun toNative(): Any?
//    {
//        return this
//    }

    abstract val `object`: Any
    abstract fun traverse(visitor: JsonVisitor, ctx: JsonContext)

//    @Throws(ClassNotFoundException::class, IOException::class)
//    protected fun <T : JsonValue?> parseJson(stream: ObjectInputStream): T {
//        val jsonString = stream.readObject() as String
//        return Json.instance().parse(jsonString)
//    }
}

    /**
     * Coerces underlying value to boolean according to the rules of Javascript coercion.
     */
actual fun JsonValue.asBoolean(): Boolean {
    return this.asBoolean()
}

    /**
     * Coerces the underlying value to a number according to the rules of Javascript coercion.
     */
    actual fun JsonValue.asNumber(): Double {
        return this.asNumber()
    }

    /**
     * Coerces the underlying value to a String according to the rules of JavaScript coercion.
     */
    actual fun JsonValue.asString(): String? {
        return this.asString()
    }

    actual fun JsonValue.asJsonArray(): JsonArray? {
        return this.asJsonArray()
    }

    actual fun JsonValue.asJsonObject(): JsonObject? {
        return this.asJsonObject()
    }

    /**
     * Returns an enumeration representing the fundamental JSON type.
     */
    actual val JsonValue.type: JsonType
    get() = this.type

    /**
     * Returns a serialized JSON string representing this value.
     * @return
     */
    actual fun JsonValue.toJson(): String? {
        return this.toJson()
    }

    /**
     * Equivalent of Javascript '==' operator comparison between two values.
     */
    actual fun JsonValue.jsEquals(value: JsonValue?): Boolean {
        return this.jsEquals(value)
    }

    /**
     * If used in a GWT context (dev or prod mode), converts the object to a native JavaScriptObject
     * suitable for passing to JSNI methods. Otherwise, returns the current object in other contexts,
     * such as server-side use.
     */
    actual fun JsonValue.toNative(): Any? {
        return this

//    abstract val `object`: Any
//    abstract fun traverse(visitor: JsonVisitor, ctx: JsonContext)

//    @Throws(ClassNotFoundException::class, IOException::class)
//    protected fun <T : JsonValue?> parseJson(stream: ObjectInputStream): T {
//        val jsonString = stream.readObject() as String
//        return Json.instance().parse(jsonString)
//    }
}
