package com.macrofocus.common.units

open class Voltage(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val Picovolt = Voltage("Picovolt", "pV", 0.0000001)
        val Nanovolt = Voltage("Nanovolt", "nV", 0.0000000001)
        val Microvolt = Voltage("Microvolt", "µV", 0.0000001)
        val Millivolt = Voltage("Millivolt", "mV", 0.0001)
        val Volt = Voltage("Volt", "V", 1.0)
        val Kilovolt = Voltage("Kilovolt", "kV", 1000.0)
        val Megavolt = Voltage("Megavolt", "MV", 1000000.0)
        val Gigavolt = Voltage("Gigavolt", "GV", 1000000000.0)
        val Teravolt = Voltage("Teravolt", "TV", 1000000000000.0)
        val Petavolt = Voltage("Petavolt", "PV", 1000000000000000.0)
    }
}

val Number.Picovolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Picovolt)
val Number.Nanovolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Nanovolt)
val Number.Microvolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Microvolt)
val Number.Millivolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Millivolt)
val Number.Volt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Volt)
val Number.Kilovolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Kilovolt)
val Number.Megavolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Megavolt)
val Number.Gigavolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Gigavolt)
val Number.Teravolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Teravolt)
val Number.Petavolt: Quantity<Voltage> get() = Quantity(this.toDouble(), Voltage.Petavolt)
