/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

/**
 * Defines the requirements for a hierarchy that can change -- by adding or removing elements
 */
interface MutableHierarchy<T> : Hierarchy<T> {
    fun addChild(parent: T, child: T): T
    fun insertChild(parent: T, index: Int, child: T)
    fun removeChild(parent: T, child: T)
    fun moveChild(oldParent: T, newParent: T, index: Int, child: T)
    fun setChildren(parent: T, children: List<T>)
    fun addChildren(parent: T, children: List<T>)
    fun removeChildren(children: List<T>)
    fun removeAll()
}