package com.macrofocus.common.collection

interface RandomAccessIterable<T> : Iterable<T> {
    fun size(): Int
    operator fun get(index: Int): T
}

fun <T> List<T>.asRandomAccessIterable(): RandomAccessIterable<T> {
    return object : RandomAccessIterable<T> {
        override fun size(): Int {
            return this@asRandomAccessIterable.size ?: 0
        }

        override fun get(index: Int): T {
            return this@asRandomAccessIterable.get(index)
        }

        override fun iterator(): Iterator<T> {
            return this@asRandomAccessIterable.iterator()
        }
    }
}

