package com.macrofocus.common.json

/**
 * Vends out implementation of JsonFactory.
 */
object Json {
    fun create(string: String): JsonString? {
        return instance().create(string)
    }

    fun create(bool: Boolean): JsonBoolean? {
        return instance().create(bool)
    }

    fun createArray(): JsonArray {
        return instance().createArray()
    }

    fun createNull(): JsonNull {
        return instance().createNull()
    }

    fun create(number: Double): JsonNumber? {
        return instance().create(number)
    }

    fun createObject(): JsonObject {
        return instance().createObject()
    }

    fun instance(): JsonFactory {
        return JsonFactory()
    }

    fun parse(jsonString: String): JsonObject {
        return instance().parse(jsonString)
    }
}