package com.macrofocus.common.json

/**
 * Base interface for all Json values.
 */
interface JsonValue {
    /**
     * Coerces underlying value to boolean according to the rules of Javascript coercion.
     */
    fun asBoolean(): Boolean

    /**
     * Coerces the underlying value to a number according to the rules of Javascript coercion.
     */
    fun asNumber(): Double

    /**
     * Coerces the underlying value to a String according to the rules of JavaScript coercion.
     */
    fun asString(): String?

    /**
     * Returns an enumeration representing the fundamental JSON type.
     */
    val type: com.macrofocus.common.json.JsonType

    /**
     * Returns a serialized JSON string representing this value.
     * @return
     */
    fun toJson(): String?

    /**
     * Equivalent of Javascript '==' operator comparison between two values.
     */
    fun jsEquals(value: JsonValue?): Boolean

    /**
     * If used in a GWT context (dev or prod mode), converts the object to a native JavaScriptObject
     * suitable for passing to JSNI methods. Otherwise, returns the current object in other contexts,
     * such as server-side use.
     */
    fun toNative(): Any?
}