package com.macrofocus.common.properties

import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.common.selection.SingleSelectionEvent
import com.macrofocus.common.selection.SingleSelectionListener

abstract class AbstractSingleSelectionCoordinator<A, B>(
    private val a: MutableSingleSelection<A>,
    private val b: MutableSingleSelection<B>
) {
    private var updatingSelection = false
    val a2bListener: SingleSelectionListener<A> = object : SingleSelectionListener<A> {
        override fun selectionChanged(event: SingleSelectionEvent<A>) {
            if (!updatingSelection) {
                updatingSelection = true
                b.selected = a2b(event.currentSelection)
                updatingSelection = false
            }
        }
    }
    val b2aListener: SingleSelectionListener<B> = object : SingleSelectionListener<B> {
        override fun selectionChanged(event: SingleSelectionEvent<B>) {
            if (!updatingSelection) {
                updatingSelection = true
                a.selected = b2a(event.currentSelection)
                updatingSelection = false
            }
        }
    }

    abstract fun a2b(b: A?): B
    abstract fun b2a(a: B?): A

    init {
        a.addSingleSelectionListener(a2bListener)
        b.addSingleSelectionListener(b2aListener)
    }
}