/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.properties

/**
 * This interface represents the current value of a named property.
 *
 * @param <T> the type of elements that the property can hold
</T> */
interface Property<T> {
    val value: T

    fun addPropertyListener(listener: PropertyListener<T>)

    /**
     * Add a listener to the list that's notified each time a change to the selection occurs. The listener will
     * automatically be disposed of should no other object have a reference to it.
     *
     * @param listener the SelectionListener
     */
    fun addWeakPropertyListener(listener: PropertyListener<T>)

    fun removePropertyListener(listener: PropertyListener<T>)
}