/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * This class provides a skeletal implementation of the MutableSelection interface to minimize the effort required to implement
 * this interface.
 */
abstract class AbstractMutableSelection<E> : AbstractSelection<E>(), MutableSelection<E> {
    override var isEnabled: Boolean
        get() = super.isEnabled
        set(value) {super.isEnabled = value}
}