/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * Defines the requirements for a single selection that can change.
 */
interface MutableSingleSelection<E> : SingleSelection<E>, MutableSelection<E> {
    /**
     * Change the selection to the given element.
     *
     * @param element the element to replace the current selection.
     */
    override var selected: E?
}