package com.macrofocus.common.transform

import com.macrofocus.common.interval.IntervalEvent
import com.macrofocus.common.interval.IntervalListener
import com.macrofocus.common.interval.MutableBoundedInterval
import com.macrofocus.common.math.isNaN

/**
 * Synchronize two range models with their respective coordinate axis models. This coordinator keeps the aspect
 * ratio constant.
 */
class RangesScreenTransformCoordinator(
    xRange: MutableBoundedInterval,
    yRange: MutableBoundedInterval
) {
    private var xRange: MutableBoundedInterval?
    private var yRange: MutableBoundedInterval?
    var updating = false
    val xRangeListener: IntervalListener = object : IntervalListener {
        override fun intervalChanged(event: IntervalEvent?) {
            if (!updating) {
                updating = true
                if (event!!.newExtent != event.oldExtent) {
//                    if (xRange.getStart() == xRange.getMinimum() && xRange.getExtent() == xRange.getMaximum() - xRange.getMinimum()) {
//                        resetValues(yRange);
//                    } else {
                    val xRangeRatio = xRange.extent / xRange.maximumExtent
                    val yDiff = yRange.extent - yRange.maximumExtent * xRangeRatio
                    adjustValues(yRange, yDiff)
                    //                    }
                }
                updating = false
            }
        }
    }
    val yRangeListener: IntervalListener = object : IntervalListener {
        override fun intervalChanged(event: IntervalEvent?) {
            if (!updating) {
                updating = true
                if (event!!.newExtent != event.oldExtent) {
//                    if (yRange.getStart() == yRange.getMinimum() && yRange.getExtent() == yRange.getMaximum() - yRange.getMinimum()) {
//                        resetValues(xRange);
//                    } else {
                    val yRangeRatio = yRange.extent / yRange.maximumExtent
                    val xDiff = xRange.extent - xRange.maximumExtent * yRangeRatio
                    adjustValues(xRange, xDiff)
                    //                    }
                }
                updating = false
            }
        }
    }

    private fun adjustValues(range: MutableBoundedInterval, diff: Double) {
        var diff = diff
        if (isNaN(diff)) {
            diff = 0.0
        }
        var value = range.start + diff / 2
        var extent = range.extent - diff
        if (value < range.minimum) {
            value = range.minimum
        }
        if (extent > range.maximumExtent) {
            extent = range.maximumExtent
        }
        if (value + extent > range.maximum) {
            value = range.maximum - extent
        }
        range.setValue(value, extent)
    }

    private fun resetValues(range: MutableBoundedInterval) {
        range.setValue(range.minimum, range.maximumExtent)
    }

    fun setRanges(xRange: MutableBoundedInterval?, yRange: MutableBoundedInterval?) {
        if (this.xRange != null) {
            this.xRange!!.removeIntervalListener(xRangeListener)
        }
        this.xRange = xRange
        if (this.xRange != null) {
            this.xRange!!.addIntervalListener(xRangeListener)
        }
        if (this.yRange != null) {
            this.yRange!!.removeIntervalListener(yRangeListener)
        }
        this.yRange = yRange
        if (this.yRange != null) {
            this.yRange!!.addIntervalListener(yRangeListener)
        }
        updating = true
        updating = false
    }

    init {
        this.xRange = xRange
        this.yRange = yRange
        xRange.addIntervalListener(xRangeListener)
        yRange.addIntervalListener(yRangeListener)
    }
}