package com.macrofocus.common.json

/**
 * Factory interface for parsing and creating JSON objects.
 */
actual class JsonFactory {
    /**
     * Create a JsonString from a Java String.
     *
     * @param string a Java String
     * @return the parsed JsonString
     */
    actual fun create(string: String): JsonString {
        TODO("Not yet implemented")
    }

    /**
     * Create a JsonNumber from a Java double.
     *
     * @param number a Java double
     * @return the parsed JsonNumber
     */
    actual fun create(number: Double): JsonNumber {
        TODO("Not yet implemented")
    }

    /**
     * Create a JsonBoolean from a Java boolean.
     *
     * @param bool a Java boolean
     * @return the parsed JsonBoolean
     */
    actual fun create(bool: Boolean): JsonBoolean {
        TODO("Not yet implemented")
    }

    /**
     * Create an empty JsonArray.
     *
     * @return a new JsonArray
     */
    actual fun createArray(): JsonArray {
        TODO("Not yet implemented")
    }

    /**
     * Create a JsonNull.
     *
     * @return a JsonNull instance
     */
    actual fun createNull(): JsonNull {
        TODO("Not yet implemented")
    }

    /**
     * Create an empty JsonObject.
     *
     * @return a new JsonObject
     */
    actual fun createObject(): JsonObject {
        TODO("Not yet implemented")
    }

    /**
     * Parse a String in JSON format and return a JsonValue of the appropriate
     * type.
     *
     * @param jsonString a String in JSON format
     * @return a parsed JsonValue
     */
    actual fun <T : JsonValue?> parse(jsonString: String): T {
        TODO("Not yet implemented")
    }

}