package com.macrofocus.common.interval

import com.macrofocus.common.properties.MutableProperty

/**
 * / ** Defines the requirements for a BoundedInterval that can change.
 */
interface MutableBoundedInterval : BoundedInterval, MutableInterval {
    fun setMinMax(min: Double, max: Double)
    fun setMinMaxExtent(min: Double, max: Double, minExtent: Double, maxExtent: Double)
    fun reset()

    override val startProperty: MutableProperty<Double>

    override val endProperty: MutableProperty<Double>

    override var minimumExtent: Double
    override var maximumExtent: Double

    override fun setValue(value: Double, extent: Double)
}
