package com.macrofocus.common.json

/**
 * Factory interface for parsing and creating JSON objects.
 */
expect class JsonFactory() {
    /**
     * Create a JsonString from a Java String.
     *
     * @param string a Java String
     * @return the parsed JsonString
     */
    fun create(string: String): JsonString

    /**
     * Create a JsonNumber from a Java double.
     *
     * @param number a Java double
     * @return the parsed JsonNumber
     */
    fun create(number: Double): JsonNumber

    /**
     * Create a JsonBoolean from a Java boolean.
     *
     * @param bool a Java boolean
     * @return the parsed JsonBoolean
     */
    fun create(bool: Boolean): JsonBoolean

    /**
     * Create an empty JsonArray.
     *
     * @return a new JsonArray
     */
    fun createArray(): JsonArray

    /**
     * Create a JsonNull.
     *
     * @return a JsonNull instance
     */
    fun createNull(): JsonNull

    /**
     * Create an empty JsonObject.
     *
     * @return a new JsonObject
     */
    fun createObject(): JsonObject

    /**
     * Parse a String in JSON format and return a JsonValue of the appropriate
     * type.
     *
     * @param jsonString a String in JSON format
     * @return a parsed JsonValue
     */
    @Throws(JsonException::class)
    fun <T : JsonValue?> parse(jsonString: String): T
}