package com.macrofocus.common.json

/**
 * Represents a Json object.
 */
interface JsonObject : JsonValue {
    /**
     * Return the element (uncoerced) as a JsonValue.
     */
    operator fun <T : JsonValue?> get(key: String): T

    /**
     * Return the element (uncoerced) as a JsonArray. If the type is not an array,
     * this can result in runtime errors.
     */
    fun getArray(key: String): JsonArray?

    /**
     * Return the element (uncoerced) as a boolean. If the type is not a boolean,
     * this can result in runtime errors.
     */
    fun getBoolean(key: String): Boolean

    /**
     * Return the element (uncoerced) as a number. If the type is not a number, this
     * can result in runtime errors.
     */
    fun getNumber(key: String): Double

    /**
     * Return the element (uncoerced) as a JsonObject If the type is not an object,,
     * this can result in runtime errors.
     */
    fun getObject(key: String): JsonObject?

    /**
     * Return the element (uncoerced) as a String. If the type is not a String, this
     * can result in runtime errors.
     */
    fun getString(key: String): String?

    /**
     * All keys of the object.
     */
    fun keys(): Array<String>

    /**
     * Set a given key to the given value.
     */
    fun put(key: String, value: JsonValue?)

    /**
     * Set a given key to the given String value.
     */
    fun put(key: String, value: String)

    /**
     * Set a given key to the given double value.
     */
    fun put(key: String, value: Double)

    /**
     * Set a given key to the given boolean value.
     */
    fun put(key: String, bool: Boolean)

    /**
     * Test whether a given key has present.
     */
    fun hasKey(key: String): Boolean

    /**
     * Remove a given key and associated value from the object.
     * @param key
     */
    fun remove(key: String?)
}