package com.macrofocus.common.properties

import kotlin.test.Test
import kotlin.test.assertEquals
import kotlin.test.assertNotEquals

class PropertyTest {
    @Test
    fun simpleInt() {
        val property = SimpleProperty(10)

        var changeCount = 0
        property.addPropertyListener(object : PropertyListener<Int> {
            override fun propertyChanged(event: PropertyEvent<Int>) {
                changeCount++
            }
        })

        // Initial state
        assertEquals(property.value, 10)
        assertEquals(changeCount, 0)

        // Setting new value
        property.value = 20
        assertEquals(property.value, 20)
        assertNotEquals(property.value, 10)
        assertEquals(changeCount, 1)

        // Setting same value (again)
        property.value = 20
        assertEquals(property.value, 20)
        assertNotEquals(property.value, 10)
        assertEquals(changeCount, 1)
    }

    @Test
    fun simpleDouble() {
        val property = SimpleProperty(10.0)

        var changeCount = 0
        property.addPropertyListener(object : PropertyListener<Double> {
            override fun propertyChanged(event: PropertyEvent<Double>) {
                changeCount++
            }
        })

        // Initial state
        assertEquals(property.value, 10.0)
        assertEquals(changeCount, 0)

        // Setting new value
        property.value = 20.0
        assertEquals(property.value, 20.0)
        assertNotEquals(property.value, 10.0)
        assertEquals(changeCount, 1)

        // Setting same value (again)
        property.value = 20.0
        assertEquals(property.value, 20.0)
        assertNotEquals(property.value, 10.0)
        assertEquals(changeCount, 1)
    }

    @Test
    fun simpleString() {
        val property = SimpleProperty("10")

        var changeCount = 0
        property.addPropertyListener(object : PropertyListener<String> {
            override fun propertyChanged(event: PropertyEvent<String>) {
                changeCount++
            }
        })

        // Initial state
        assertEquals(property.value, "10")
        assertEquals(changeCount, 0)

        // Setting new value
        property.value = "20"
        assertEquals(property.value, "20")
        assertNotEquals(property.value, "10")
        assertEquals(changeCount, 1)

        // Setting same value (again)
        property.value = "20"
        assertEquals(property.value, "20")
        assertNotEquals(property.value, "10")
        assertEquals(changeCount, 1)
    }

    @Test
    fun delegateInt() {
        val property = SimpleProperty(10)

        var changeCount = 0
        property.addPropertyListener(object : PropertyListener<Int> {
            override fun propertyChanged(event: PropertyEvent<Int>) {
                changeCount++
            }
        })

        var value by PropertyDelegates.mutable(property)

        // Initial state
        assertEquals(value, 10)
        assertEquals(changeCount, 0)

        // Setting new value
        value = 20
        assertEquals(value, 20)
        assertNotEquals(value, 10)
        assertEquals(changeCount, 1)

        // Setting same value (again)
        value = 20
        assertEquals(value, 20)
        assertNotEquals(value, 10)
        assertEquals(changeCount, 1)
    }
}