package com.macrofocus.common.json

/**
 * Implementation of JsonFactory interface using org.json library.
 */
actual class JsonFactory {
    actual fun create(string: String): JsonString {
        return JavaJsonString(string)
    }

    actual fun create(number: Double): JsonNumber {
        return JavaJsonNumber(number)
    }

    actual fun create(bool: Boolean): JsonBoolean {
        return JavaJsonBoolean(bool)
    }

    actual fun createArray(): JsonArray {
        return JavaJsonArray(this)
    }

    actual fun createNull(): JsonNull {
        return JavaJsonNull.NULL_INSTANCE
    }

    actual fun createObject(): JsonObject {
        return JavaJsonObject(this)
    }

    @Throws(JsonException::class)
    actual fun <T : JsonValue?> parse(jsonString: String): T {
        var jsonString = jsonString
        if (jsonString.startsWith("(") && jsonString.endsWith(")")) {
            // some clients send in (json) expecting an eval is required
            jsonString = jsonString.substring(1, jsonString.length - 1)
        }
        return JsonTokenizer(this, jsonString).nextValue()
    }
}